/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.mixin;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.endergetic.common.entity.bolloom.BalloonOrder;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomBalloon;
import com.teamabnormals.endergetic.common.item.BolloomBalloonItem;
import com.teamabnormals.endergetic.core.interfaces.BalloonHolder;
import com.teamabnormals.endergetic.core.interfaces.CustomBalloonPositioner;
import com.teamabnormals.endergetic.core.registry.other.EEDataProcessors;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Boat.class})
public abstract class BoatMixin
extends Entity
implements CustomBalloonPositioner {
    private static final ResourceLocation LARGE_BOAT_NAME = new ResourceLocation("boatload", "large_boat");

    private BoatMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void onBalloonAttached(BolloomBalloon balloon) {
        if (!balloon.f_19853_.f_46443_ && !balloon.hasModifiedBoatOrder) {
            HashMap orderMap = Maps.newHashMap((Map)((Map)((IDataManager)this).getValue(EEDataProcessors.ORDER_DATA)));
            orderMap.put(balloon.m_20148_(), BoatMixin.getClosestOpenOrder(orderMap));
            ((IDataManager)this).setValue(EEDataProcessors.ORDER_DATA, (Object)orderMap);
            balloon.hasModifiedBoatOrder = true;
        }
    }

    @Override
    public void onBalloonDetached(BolloomBalloon balloon) {
        if (!balloon.f_19853_.f_46443_) {
            HashMap orderMap = Maps.newHashMap((Map)((Map)((IDataManager)this).getValue(EEDataProcessors.ORDER_DATA)));
            orderMap.remove(balloon.m_20148_());
            ((IDataManager)this).setValue(EEDataProcessors.ORDER_DATA, (Object)orderMap);
        }
    }

    @Override
    public void updateAttachedPosition(BolloomBalloon balloon) {
        Map orderMap = (Map)((IDataManager)this).getValue(EEDataProcessors.ORDER_DATA);
        if (!orderMap.containsKey(balloon.m_20148_())) {
            return;
        }
        BalloonOrder balloonOrder = (BalloonOrder)((Object)orderMap.get(balloon.m_20148_()));
        boolean large = this.m_6095_() == ForgeRegistries.ENTITY_TYPES.getValue(LARGE_BOAT_NAME);
        Vec3 attachedOffset = new Vec3(large ? (double)balloonOrder.largeX : (double)balloonOrder.normalX, 0.0, large ? (double)balloonOrder.largeZ : (double)balloonOrder.normalZ).m_82524_((float)((double)(-this.m_146908_()) * (Math.PI / 180) - 1.5707963267948966));
        balloon.m_6034_(this.m_20185_() + attachedOffset.m_7096_() + (double)balloon.getSway() * Math.sin(-balloon.getVineYRot()), this.m_20186_() + balloon.m_6048_() + (double)balloon.m_20192_(), this.m_20189_() + attachedOffset.m_7094_() + (double)balloon.getSway() * Math.cos(-balloon.getVineYRot()));
    }

    private static BalloonOrder getClosestOpenOrder(Map<UUID, BalloonOrder> orderMap) {
        HashSet missingNumbers = Sets.newHashSet();
        Set<Integer> orders = BalloonOrder.toOrdinalSet(Sets.newHashSet(orderMap.values()));
        for (int i = 0; i < 4; ++i) {
            if (orders.contains(i)) continue;
            missingNumbers.add(i);
        }
        return BalloonOrder.byOrdinal(missingNumbers.isEmpty() ? orders.size() : ((Integer)missingNumbers.stream().sorted(Comparator.comparingInt(Math::abs)).collect(Collectors.toList()).get(0)).intValue());
    }

    @Inject(at={@At(value="TAIL")}, method={"floatBoat"})
    private void handleBalloonMotion(CallbackInfo info) {
        int balloons = ((BalloonHolder)((Object)this)).getBalloons().size();
        if (balloons > 0) {
            Vec3 motion = this.m_20184_();
            if (motion.m_7098_() <= 0.0 && balloons <= 2) {
                this.m_20256_(motion.m_82542_(1.0, (double)(0.85f / (float)balloons), 1.0));
            } else if (balloons > 2) {
                float boost = (float)balloons / 2.0f * 0.045f;
                this.m_20256_(new Vec3(motion.m_7096_(), Mth.m_14008_((double)(motion.m_7098_() + (double)boost), (double)-1.0, (double)boost), motion.m_7094_()));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"interact"}, cancellable=true)
    private void addBalloonAttachingInteraction(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> info) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof BolloomBalloonItem && BolloomBalloonItem.canAttachBalloonToTarget(this)) {
            player.m_21011_(hand, true);
            if (!this.f_19853_.f_46443_) {
                BolloomBalloonItem.attachToEntity(((BolloomBalloonItem)item).getBalloonColor(), this);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            info.setReturnValue((Object)InteractionResult.CONSUME);
        }
    }
}

