/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.suppsquared;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBraceBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ItemShelfBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SackBlock;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.common.items.TimberFrameItem;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.RegUtils;
import net.mehvahdjukaar.suppsquared.client.ClientPackProvider;
import net.mehvahdjukaar.suppsquared.common.HeavyKeyItem;
import net.mehvahdjukaar.suppsquared.common.PlaqueBlock;
import net.mehvahdjukaar.suppsquared.common.PlaqueBlockTile;
import net.mehvahdjukaar.suppsquared.common.SackDyeRecipe;
import net.mehvahdjukaar.suppsquared.common.ServerPackProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SuppSquared {
    public static final String MOD_ID = "suppsquared";
    public static final Logger LOGGER = LogManager.getLogger((String)"suppsquared");
    private static final RegHelper.VariantType[] TYPES = (RegHelper.VariantType[])List.of(RegHelper.VariantType.SLAB, RegHelper.VariantType.STAIRS, RegHelper.VariantType.VERTICAL_SLAB).toArray(RegHelper.VariantType[]::new);
    public static final Supplier<RecipeSerializer<SackDyeRecipe>> SACK_DYE_RECIPE = RegHelper.registerRecipeSerializer((ResourceLocation)new ResourceLocation("suppsquared:sack_dye"), () -> new SimpleRecipeSerializer(SackDyeRecipe::new));
    public static final Map<RegHelper.VariantType, Supplier<Block>> DAUBS = RegHelper.registerBlockSet((RegHelper.VariantType[])TYPES, (RegSupplier)ModRegistry.DAUB, (String)"suppsquared", (boolean)false);
    public static final Map<RegHelper.VariantType, Supplier<Block>> FRAMES = RegHelper.registerBlockSet((RegHelper.VariantType[])TYPES, (RegSupplier)ModRegistry.DAUB_FRAME, (String)"suppsquared", (boolean)false);
    public static final Map<WoodType, Block> ITEM_SHELVES = new LinkedHashMap<WoodType, Block>();
    public static final Map<DyeColor, Supplier<Block>> SACKS = Arrays.stream(DyeColor.values()).collect(Collectors.toUnmodifiableMap(d -> d, d -> SuppSquared.regBlock("sack_" + d.m_41065_(), () -> new SackBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76411_).m_60978_(0.8f).m_60918_((SoundType)ModSounds.SACK).m_155949_(d.m_41069_())))));
    public static final Map<DyeColor, Supplier<Item>> SACK_ITEMS = Arrays.stream(DyeColor.values()).collect(Collectors.toUnmodifiableMap(d -> d, d -> SuppSquared.regItem("sack_" + d.m_41065_(), () -> new SackItem(SACKS.get(d).get(), new Item.Properties().m_41491_(RegUtils.getTab((CreativeModeTab)CreativeModeTab.f_40750_, (String)"sack")).m_41487_(1)))));
    public static final Map<DyeColor, Supplier<Block>> GOLDEN_CANDLE_HOLDERS = RegUtils.registerCandleHolders((ResourceLocation)SuppSquared.res("gold_candle_holder"));
    public static final RegSupplier<FrameBlock> IRON_FRAME = SuppSquared.regBlock("metal_frame", () -> new FrameBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(5.0f, 6.0f).m_60988_().m_60918_(SoundType.f_56743_)));
    public static final Supplier<Item> IRON_FRAME_ITEM = SuppSquared.regItem("metal_frame", () -> new TimberFrameItem((Block)IRON_FRAME.get(), new Item.Properties().m_41491_(RegUtils.getTab((CreativeModeTab)CreativeModeTab.f_40749_, (String)"timber_frame"))));
    public static final Supplier<FrameBraceBlock> IRON_BRACE = SuppSquared.regBlock("metal_brace", () -> new FrameBraceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)IRON_FRAME.get()))));
    public static final Supplier<Item> TIMBER_BRACE_ITEM = SuppSquared.regItem("metal_brace", () -> new TimberFrameItem((Block)IRON_BRACE.get(), new Item.Properties().m_41491_(RegUtils.getTab((CreativeModeTab)CreativeModeTab.f_40749_, (String)"timber_frame"))));
    public static final Supplier<FrameBlock> IRON_CROSS_BRACE = SuppSquared.regBlock("metal_cross_brace", () -> new FrameBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)IRON_FRAME.get()))));
    public static final Supplier<Item> TIMBER_CROSS_BRACE_ITEM = SuppSquared.regItem("metal_cross_brace", () -> new TimberFrameItem((Block)IRON_CROSS_BRACE.get(), new Item.Properties().m_41491_(RegUtils.getTab((CreativeModeTab)CreativeModeTab.f_40749_, (String)"timber_frame"))));
    public static final Supplier<PlaqueBlock> GOLD_PLAQUE = SuppSquared.regWithItem("gold_plaque", () -> new PlaqueBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76398_).m_60918_(SoundType.f_56743_).m_60999_().m_60910_().m_60913_(1.0f, 1.0f)), CreativeModeTab.f_40750_);
    public static final Supplier<PlaqueBlock> IRON_PLAQUE = SuppSquared.regWithItem("iron_plaque", () -> new PlaqueBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GOLD_PLAQUE.get()))), CreativeModeTab.f_40750_);
    public static final Supplier<PlaqueBlock> COPPER_PLAQUE = SuppSquared.regWithItem("copper_plaque", () -> new PlaqueBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GOLD_PLAQUE.get()))), CreativeModeTab.f_40750_);
    public static final Supplier<BlockEntityType<PlaqueBlockTile>> PLAQUE_TILE = RegHelper.registerBlockEntityType((ResourceLocation)SuppSquared.res("plaque"), () -> PlatformHelper.newBlockEntityType(PlaqueBlockTile::new, (Block[])new Block[]{(Block)IRON_PLAQUE.get(), (Block)COPPER_PLAQUE.get(), (Block)GOLD_PLAQUE.get()}));
    public static final Supplier<HeavyKeyItem> SKELETON_KEY = RegHelper.registerItem((ResourceLocation)SuppSquared.res("heavy_key"), () -> new HeavyKeyItem(new Item.Properties().m_41486_().m_41487_(1).m_41497_(Rarity.UNCOMMON).m_41491_(RegUtils.getTab((CreativeModeTab)CreativeModeTab.f_40756_, (String)"key"))));

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
        if (PlatformHelper.getEnv().isClient()) {
            ClientPackProvider.INSTANCE.register();
        }
        ServerPackProvider.INSTANCE.register();
        BlockSetAPI.addDynamicBlockRegistration(SuppSquared::registerItemShelves, WoodType.class);
        BlockSetAPI.addDynamicItemRegistration(SuppSquared::registerItemShelfItems, WoodType.class);
    }

    public static void commonSetup() {
    }

    private static void registerItemShelves(Registrator<Block> event, Collection<WoodType> types) {
        for (WoodType wood : types) {
            ItemShelfBlock block;
            if (wood == WoodTypeRegistry.OAK_TYPE) continue;
            String name = wood.getVariantId("item_shelf");
            ItemShelfBlock instance = block = new ItemShelfBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60918_(SoundType.f_56736_).m_60913_(0.75f, 0.1f).m_60955_().m_60910_());
            event.register(SuppSquared.res(name), (Object)block);
            ITEM_SHELVES.put(wood, (Block)instance);
            wood.addChild("supplementaries:item_shelf", (Object)instance);
        }
    }

    public static void registerItemShelfItems(Registrator<Item> event, Collection<WoodType> woodTypes) {
        for (Map.Entry<WoodType, Block> entry : ITEM_SHELVES.entrySet()) {
            WoodType wood = entry.getKey();
            if (wood == WoodTypeRegistry.OAK_TYPE) continue;
            Block block = entry.getValue();
            WoodBasedBlockItem item = new WoodBasedBlockItem(block, new Item.Properties().m_41487_(16).m_41491_(RegUtils.getTab((CreativeModeTab)CreativeModeTab.f_40750_, (String)"hanging_sign")), wood, 200);
            event.register(Utils.getID((Block)block), (Object)item);
        }
        ITEM_SHELVES.put(WoodTypeRegistry.OAK_TYPE, (Block)ModRegistry.ITEM_SHELF.get());
        WoodTypeRegistry.OAK_TYPE.addChild("supplementaries:item_shelf", ModRegistry.ITEM_SHELF.get());
    }

    public static <T extends Item> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((ResourceLocation)SuppSquared.res(name), sup);
    }

    public static <T extends Block> RegSupplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((ResourceLocation)SuppSquared.res(name), sup);
    }

    public static <T extends Block> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, CreativeModeTab tab) {
        return SuppSquared.regWithItem(name, blockFactory, new Item.Properties().m_41491_(RegUtils.getTab((CreativeModeTab)tab, (String)name)), 0);
    }

    public static <T extends Block> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, CreativeModeTab tab, int burnTime) {
        return SuppSquared.regWithItem(name, blockFactory, new Item.Properties().m_41491_(RegUtils.getTab((CreativeModeTab)tab, (String)name)), burnTime);
    }

    public static <T extends Block> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, Item.Properties properties, int burnTime) {
        RegSupplier<T> block = SuppSquared.regBlock(name, blockFactory);
        SuppSquared.regBlockItem(name, block, properties, burnTime);
        return block;
    }

    public static RegSupplier<BlockItem> regBlockItem(String name, Supplier<? extends Block> blockSup, Item.Properties properties, int burnTime) {
        return RegHelper.registerItem((ResourceLocation)SuppSquared.res(name), () -> burnTime == 0 ? new BlockItem((Block)blockSup.get(), properties) : new WoodBasedBlockItem((Block)blockSup.get(), properties, burnTime));
    }
}

