/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.suppsquared.client;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.suppsquared.SuppSquared;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;

public class ClientPackProvider
extends DynClientResourcesProvider {
    public static final ClientPackProvider INSTANCE = new ClientPackProvider();

    public ClientPackProvider() {
        super(new DynamicTexturePack(SuppSquared.res("generated_pack"), Pack.Position.BOTTOM, true, true));
        ((DynamicTexturePack)this.dynamicPack).generateDebugResources = true;
        ((DynamicTexturePack)this.dynamicPack).addNamespaces(new String[]{"minecraft"});
        ((DynamicTexturePack)this.dynamicPack).addNamespaces(new String[]{"supplementaries"});
    }

    public Logger getLogger() {
        return SuppSquared.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        Respriter respriter;
        TextureImage template;
        StaticResource isItemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(SuppSquared.res("item_shelf_birch")));
        StaticResource isBlockState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(SuppSquared.res("item_shelf_birch")));
        StaticResource isModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(SuppSquared.res("item_shelves/birch")));
        SuppSquared.ITEM_SHELVES.forEach((wood, sign) -> {
            String id = Utils.getID((Block)sign).m_135815_();
            if (wood == WoodTypeRegistry.OAK_TYPE) {
                return;
            }
            try {
                this.addSimilarJsonResource(manager, isBlockState, s -> s.replace("item_shelf_birch", id).replace("birch", id.replace("item_shelf_", "")));
                this.addSimilarJsonResource(manager, isModel, s -> s.replace("item_shelf_birch", id).replace("birch", id.replace("item_shelf_", "")));
                this.addSimilarJsonResource(manager, isItemModel, s -> s.replace("item_shelf_birch", id).replace("birch", id.replace("item_shelf_", "")));
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate models for {} : {}", sign, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"items/item_shelf"));
            try {
                respriter = Respriter.of((TextureImage)template);
                SuppSquared.ITEM_SHELVES.forEach((wood, sign) -> {
                    ResourceLocation textureRes = SuppSquared.res("item/item_shelves/" + Utils.getID((Block)sign).m_135815_().replace("item_shelf_", ""));
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    TextureImage newImage = null;
                    Item signItem = wood.getItemOfThis("sign");
                    if (signItem != null) {
                        try (TextureImage vanillaSign2 = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)signItem));
                             TextureImage signMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"items/hanging_signs/sign_board_mask"));){
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign2, (TextureImage)signMask);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception vanillaSign2) {
                            // empty catch block
                        }
                    }
                    if (newImage == null) {
                        try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                            Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to generate Sign Post item texture for for {} : {}", sign, (Object)ex);
                        }
                    }
                    if (newImage != null) {
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Item Shelves item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"blocks/item_shelf"));
            try {
                respriter = Respriter.of((TextureImage)template);
                SuppSquared.ITEM_SHELVES.forEach((wood, sign) -> {
                    ResourceLocation textureRes = SuppSquared.res("block/item_shelves/" + Utils.getID((Block)sign).m_135815_().replace("item_shelf_", ""));
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        Palette palette = Palette.fromImage((TextureImage)plankTexture);
                        TextureImage newImage = respriter.recolor(palette);
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Item Shelf block texture for for {} : {}", sign, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Item Shelf block texture : ", (Throwable)ex);
        }
    }

    public void generateStaticAssetsOnStartup(ResourceManager manager) {
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        SuppSquared.ITEM_SHELVES.forEach((type, block) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"block.suppsquared.item_shelf", (BlockType)type, (Block)block));
    }

    public void generateSacks(ResourceManager manager) {
        try (TextureImage front_mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/front_mask"));
             TextureImage open_mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/open_mask"));
             TextureImage bottom = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"blocks/sack_bottom"));
             TextureImage closed = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"blocks/sack_closed"));
             TextureImage open = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"blocks/sack_open"));
             TextureImage top = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"blocks/sack_top"));
             TextureImage front = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"blocks/sack_front"));){
            Respriter bottom_res = Respriter.of((TextureImage)bottom);
            Respriter closed_res = Respriter.of((TextureImage)closed);
            Respriter open_res = Respriter.masked((TextureImage)open, (TextureImage)open_mask);
            Respriter top_res = Respriter.of((TextureImage)top);
            Respriter front_res = Respriter.masked((TextureImage)front, (TextureImage)front_mask);
            for (DyeColor d : DyeColor.values()) {
                try (TextureImage bottom_c = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/sack_" + d.m_41065_() + "_bottom"));
                     TextureImage closed_c = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/sack_" + d.m_41065_() + "_closed"));
                     TextureImage open_c = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/sack_" + d.m_41065_() + "_open"));
                     TextureImage top_c = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/sack_" + d.m_41065_() + "_top"));
                     TextureImage front_c = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/sack_" + d.m_41065_() + "_front"));){
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(SuppSquared.res("sack_" + d.m_41065_() + "_bottom"), bottom_res.recolor(Palette.fromImage((TextureImage)bottom_c)));
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(SuppSquared.res("sack_" + d.m_41065_() + "_closed"), closed_res.recolor(Palette.fromImage((TextureImage)closed_c)));
                    TextureImage i = open_res.recolor(Palette.fromImage((TextureImage)open_c, (TextureImage)open_mask));
                    open_c.crop(open_mask.makeCopy(), false);
                    i.applyOverlay(new TextureImage[]{open_c});
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(SuppSquared.res("sack_" + d.m_41065_() + "_open"), i);
                    TextureImage f = front_res.recolor(Palette.fromImage((TextureImage)front_c, (TextureImage)front_mask));
                    front_c.crop(front_mask.makeCopy(), false);
                    f.applyOverlay(new TextureImage[]{front_c});
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(SuppSquared.res("sack_" + d.m_41065_() + "_front"), f);
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(SuppSquared.res("sack_" + d.m_41065_() + "_top"), top_res.recolor(Palette.fromImage((TextureImage)top_c)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception ex) {
            boolean bl = true;
        }
    }
}

