/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.model;

import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.cobblegen.data.config.GeneratorMap;
import io.github.null2264.cobblegen.data.config.ResultList;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.data.model.Generator;
import io.github.null2264.cobblegen.util.Util;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface BuiltInGenerator
extends Generator {
    private String randomizeBlockId(Block key, String dim, Integer yLevel, GeneratorMap candidates, @Nullable String biome) {
        int idx;
        ResultList blockIds = candidates.getOrDefault(CGIdentifier.fromMC(Util.getBlockId(key)), candidates.getOrDefault(CGIdentifier.wildcard(), new ResultList()));
        ResultList filteredBlockIds = new ResultList();
        AtomicReference<Double> totalWeight = new AtomicReference<Double>(0.0);
        for (WeightedBlock block : blockIds) {
            if (block.dimensions != null && !block.dimensions.contains(dim) || block.excludedDimensions != null && block.excludedDimensions.contains(dim) || biome != null && CobbleGen.META_CONFIG.enableExperimentalFeatures.booleanValue() && (block.biomes != null && !block.biomes.contains(biome) || block.excludedBiomes != null && block.excludedBiomes.contains(biome)) || block.maxY != null && block.maxY.compareTo(yLevel) <= 0 || block.minY != null && block.minY.compareTo(yLevel) >= 0) continue;
            if (block.id.startsWith("#")) {
                try {
                    List<ResourceLocation> taggedBlocks = Util.getTaggedBlockIds(ResourceLocation.m_135820_((String)block.id.substring(1)));
                    for (ResourceLocation taggedBlock : taggedBlocks) {
                        filteredBlockIds.add(new WeightedBlock(taggedBlock.toString(), block.weight));
                        totalWeight.updateAndGet(v -> v + block.weight);
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            filteredBlockIds.add(block);
            totalWeight.updateAndGet(v -> v + block.weight);
        }
        if (filteredBlockIds.isEmpty()) {
            return null;
        }
        if (filteredBlockIds.size() == 1) {
            return ((WeightedBlock)filteredBlockIds.get((int)0)).id;
        }
        double r = Math.random() * totalWeight.get();
        for (idx = 0; idx < filteredBlockIds.size() - 1 && !((r -= ((WeightedBlock)filteredBlockIds.get((int)idx)).weight.doubleValue()) <= 0.0); ++idx) {
        }
        return ((WeightedBlock)filteredBlockIds.get((int)idx)).id;
    }

    default public Optional<BlockState> getBlockCandidate(LevelAccessor level, BlockPos pos, GeneratorMap candidates) {
        return this.getBlockCandidate(level, pos, candidates, null);
    }

    default public Optional<BlockState> getBlockCandidate(LevelAccessor level, BlockPos pos, GeneratorMap candidates, Block defaultBlock) {
        ResourceLocation id;
        String replacementId = this.randomizeBlockId(level.m_8055_(pos.m_7495_()).m_60734_(), Util.getDimension(level), pos.m_123342_(), candidates, Util.getBiome(level, pos));
        if (replacementId == null) {
            if (defaultBlock != null) {
                return Optional.of(defaultBlock.m_49966_());
            }
            return Optional.empty();
        }
        try {
            id = ResourceLocation.m_135820_((String)replacementId);
        }
        catch (Exception e) {
            id = Util.identifierOf(replacementId);
        }
        return Optional.of(Util.getBlock(id).m_49966_());
    }
}

