/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.compat.LoaderCompat;
import io.github.null2264.cobblegen.compat.TextCompat;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.integration.viewer.emi.FluidInteractionRecipe;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@EmiEntrypoint
public class CGEMIPlugin
implements EmiPlugin {
    public static final String ID_PREFIX = "fluid_interaction_";
    public static final Map<String, EmiRecipeCategory> FLUID_INTERACTION_CATEGORIES;

    private void input(EmiWorldInteractionRecipe.Builder recipe, EmiIngredient input, boolean catalyst, InputPosition position) {
        if (position.equals((Object)InputPosition.RIGHT)) {
            recipe.rightInput(input, catalyst);
        } else {
            recipe.leftInput(input);
        }
    }

    private void input(EmiWorldInteractionRecipe.Builder recipe, EmiIngredient input, boolean catalyst, Function<SlotWidget, SlotWidget> mutator, InputPosition position) {
        if (position.equals((Object)InputPosition.RIGHT)) {
            recipe.rightInput(input, catalyst, mutator);
        } else {
            recipe.leftInput(input, mutator);
        }
    }

    public void register(EmiRegistry registry) {
        if (!CobbleGen.META_CONFIG.enableRecipeViewer.booleanValue()) {
            return;
        }
        if (!CobbleGen.META_CONFIG.mergeEMIRecipeCategory.booleanValue()) {
            FLUID_INTERACTION_CATEGORIES.forEach((ignored, category) -> registry.addCategory(category));
            CobbleGen.FLUID_INTERACTION.getGenerators().forEach((fluid, generators) -> generators.forEach(generator -> generator.getOutput().forEach((modifierId, blocks) -> {
                Block modifier = null;
                if (!modifierId.isWildcard()) {
                    modifier = Util.getBlock(modifierId.toMC());
                }
                for (WeightedBlock block : blocks) {
                    registry.addRecipe((EmiRecipe)new FluidInteractionRecipe((Fluid)fluid, Util.notNullOr(generator.getFluid(), Fluids.f_76191_), Util.notNullOr(generator.getBlock(), Blocks.f_50016_), block, generator.getType(), Util.notNullOr(modifier, Blocks.f_50016_)));
                }
            })));
        } else {
            Minecraft minecraft = Minecraft.m_91087_();
            CobbleGen.FLUID_INTERACTION.getGenerators().forEach((fluid, generators) -> generators.forEach(generator -> generator.getOutput().forEach((modifierId, blocks) -> {
                EmiStack trigger = EmiStack.of((Fluid)fluid, (long)(LoaderCompat.isForge() != false ? 1000L : 81000L));
                Optional<Object> modifier = Optional.empty();
                if (!modifierId.isWildcard()) {
                    modifier = Optional.of(Util.getBlock(modifierId.toMC()));
                }
                for (WeightedBlock block : blocks) {
                    EmiStack neighbourRemainder;
                    EmiStack neighbour;
                    ResourceLocation neighbourId;
                    ResourceLocation resultId;
                    try {
                        resultId = ResourceLocation.m_135820_((String)block.id);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    EmiStack output = EmiStack.of((ItemLike)Util.getBlock(resultId));
                    ResourceLocation source = Util.getFluidId(fluid);
                    if (generator.getFluid() == null) {
                        neighbourId = Util.getBlockId(generator.getBlock());
                        neighbour = EmiStack.of((ItemLike)((ItemLike)Objects.requireNonNull(generator.getBlock())));
                    } else {
                        neighbourId = Util.getFluidId(generator.getFluid());
                        neighbour = EmiStack.of((Fluid)Objects.requireNonNull(generator.getFluid()), (long)(LoaderCompat.isForge() != false ? 1000L : 81000L));
                    }
                    if (CobbleGen.META_CONFIG.emi.removeOverlaps.booleanValue()) {
                        registry.removeRecipes(r -> new HashSet(r.getInputs()).containsAll(List.of(neighbour, trigger)) && r.getOutputs().contains(output) && r.getId().toString().startsWith("emi"));
                    }
                    ResourceLocation id = Util.identifierOf(ID_PREFIX + generator.getType().name().toLowerCase() + "-" + source.m_179910_() + "-" + resultId.m_179910_() + "-" + neighbourId.m_179910_() + "-" + modifierId.toDebugFileName());
                    EmiWorldInteractionRecipe.Builder recipe = EmiWorldInteractionRecipe.builder().id(id);
                    this.input(recipe, (EmiIngredient)trigger.copy().setRemainder(trigger), false, CobbleGen.META_CONFIG.emi.invertInput != false ? InputPosition.RIGHT : InputPosition.LEFT);
                    EmiStack emiStack = neighbourRemainder = neighbour.isEmpty() ? neighbour : neighbour.copy().setRemainder(neighbour);
                    if (modifier.isPresent()) {
                        this.input(recipe, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)modifier.get())), false, s -> s.appendTooltip((Component)TextCompat.translatable("tooltip.emi.fluid_interaction.basalt.soul_soil").m_130940_(ChatFormatting.GREEN)), CobbleGen.META_CONFIG.emi.invertInput != false ? InputPosition.LEFT : InputPosition.RIGHT);
                        this.input(recipe, (EmiIngredient)neighbourRemainder, false, s -> generator.getBlock() != null ? s.appendTooltip((Component)TextCompat.translatable("tooltip.emi.fluid_interaction.basalt.blue_ice").m_130940_(ChatFormatting.GREEN)) : s, CobbleGen.META_CONFIG.emi.invertInput != false ? InputPosition.LEFT : InputPosition.RIGHT);
                    } else {
                        this.input(recipe, (EmiIngredient)neighbourRemainder, false, CobbleGen.META_CONFIG.emi.invertInput != false ? InputPosition.LEFT : InputPosition.RIGHT);
                    }
                    recipe.output(output, s -> {
                        Integer maxY;
                        if (!CobbleGen.META_CONFIG.emi.addTooltip.booleanValue()) {
                            return s;
                        }
                        Integer minY = block.minY;
                        if (minY == null) {
                            minY = minecraft.f_91073_ != null ? minecraft.f_91073_.m_141937_() : 0;
                        }
                        if ((maxY = block.maxY) == null) {
                            maxY = minecraft.f_91073_ != null ? minecraft.f_91073_.m_151558_() : 256;
                        }
                        s.appendTooltip((Component)TextCompat.translatable("cobblegen.info.weight").m_7220_(Component.m_130674_((String)block.weight.toString())));
                        s.appendTooltip((Component)TextCompat.translatable("cobblegen.info.minY").m_7220_(Component.m_130674_((String)minY.toString())));
                        s.appendTooltip((Component)TextCompat.translatable("cobblegen.info.maxY").m_7220_(Component.m_130674_((String)maxY.toString())));
                        s.appendTooltip((Component)TextCompat.translatable("cobblegen.info.blacklistedDim").m_130940_(ChatFormatting.GREEN));
                        List<String> recipeBlacklist = block.excludedDimensions;
                        try {
                            for (String string : recipeBlacklist) {
                                ResourceLocation dimId;
                                try {
                                    dimId = ResourceLocation.m_135820_((String)string);
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                s.appendTooltip((Component)TextCompat.literal("- " + dimId));
                            }
                        }
                        catch (NullPointerException ignored) {
                            s.appendTooltip((Component)TextCompat.literal("- ").m_7220_((Component)TextCompat.translatable("cobblegen.dim.none")));
                        }
                        s.appendTooltip((Component)TextCompat.translatable("cobblegen.info.whitelistedDim").m_130940_(ChatFormatting.GREEN));
                        List<String> recipeWhitelist = block.dimensions;
                        try {
                            for (String dim : recipeWhitelist) {
                                ResourceLocation dimId;
                                try {
                                    dimId = ResourceLocation.m_135820_((String)dim);
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                s.appendTooltip((Component)TextCompat.literal("- " + dimId));
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            s.appendTooltip((Component)TextCompat.literal("- ").m_7220_((Component)TextCompat.translatable("cobblegen.dim.any")));
                        }
                        return s;
                    });
                    registry.addRecipe((EmiRecipe)recipe.build());
                }
            })));
        }
    }

    static {
        IBootstrap.dasBoot();
        FLUID_INTERACTION_CATEGORIES = Map.of("COBBLE", new EmiRecipeCategory(Util.identifierOf("fluid_interaction_cobble"), (EmiRenderable)EmiStack.of((ItemLike)Blocks.f_50652_)), "STONE", new EmiRecipeCategory(Util.identifierOf("fluid_interaction_stone"), (EmiRenderable)EmiStack.of((ItemLike)Blocks.f_50069_)), "BASALT", new EmiRecipeCategory(Util.identifierOf("fluid_interaction_basalt"), (EmiRenderable)EmiStack.of((ItemLike)Blocks.f_50137_)));
    }

    static enum InputPosition {
        LEFT,
        RIGHT;


        static {
            IBootstrap.dasBoot();
        }
    }
}

