/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import io.github.null2264.cobblegen.compat.LoaderCompat;
import io.github.null2264.cobblegen.compat.TextCompat;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.integration.viewer.FluidInteractionRecipeHolder;
import io.github.null2264.cobblegen.integration.viewer.emi.CGEMIPlugin;
import io.github.null2264.cobblegen.util.Constants;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;

public class FluidInteractionRecipe
extends FluidInteractionRecipeHolder
implements EmiRecipe {
    private final int initialHeight;

    public FluidInteractionRecipe(Fluid sourceFluid, Fluid neighbourFluid, Block neighbourBlock, WeightedBlock result, GeneratorType type, Block modifier) {
        super(sourceFluid, neighbourFluid, neighbourBlock, result, type, modifier);
        this.initialHeight = type.equals((Object)GeneratorType.STONE) ? 56 : 36;
    }

    public int getDisplayWidth() {
        return 150;
    }

    public int getDisplayHeight() {
        return this.initialHeight + 18 + 20 + 9 + 2;
    }

    public EmiRecipeCategory getCategory() {
        return CGEMIPlugin.FLUID_INTERACTION_CATEGORIES.get(this.getType().name());
    }

    public List<EmiIngredient> getInputs() {
        EmiStack source = EmiStack.of((Fluid)this.getSourceFluid(), (long)(LoaderCompat.isForge() != false ? 1000L : 81000L));
        EmiStack neighbour = EmiStack.of((Fluid)this.getNeighbourFluid(), (long)(LoaderCompat.isForge() != false ? 1000L : 81000L));
        return List.of(source.copy().setRemainder(source), this.getType().equals((Object)GeneratorType.BASALT) ? EmiStack.of((ItemLike)this.getNeighbourBlock()) : neighbour.copy().setRemainder(neighbour), EmiStack.of((ItemLike)this.getModifier()));
    }

    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemLike)this.getResult().getBlock()));
    }

    public void addWidgets(WidgetHolder widgets) {
        Integer maxY;
        int offset = 18;
        int gap = 2;
        Point base = new Point(0, 0);
        Point cold = (Point)base.clone();
        Point lava = (Point)base.clone();
        lava.x += 40;
        Point result = (Point)base.clone();
        result.x += 20;
        Point resultMod = (Point)result.clone();
        resultMod.y += 20;
        if (this.getType() == GeneratorType.STONE) {
            lava.x -= 20;
            cold.y += 20;
            result.y = resultMod.y;
            resultMod.y += 20;
        }
        widgets.addSlot(this.getInputs().get(0), lava.x, lava.y).catalyst(true);
        widgets.addSlot(this.getInputs().get(1), cold.x, cold.y).catalyst(true);
        widgets.addSlot((EmiIngredient)this.getOutputs().get(0), result.x, result.y).recipeContext((EmiRecipe)this);
        widgets.addSlot(this.getInputs().get(2), resultMod.x, resultMod.y).catalyst(true);
        Minecraft minecraft = Minecraft.m_91087_();
        Font textRenderer = minecraft.f_91062_;
        Integer minY = this.getResult().minY;
        if (minY == null) {
            minY = minecraft.f_91073_ != null ? minecraft.f_91073_.m_141937_() : 0;
        }
        if ((maxY = this.getResult().maxY) == null) {
            maxY = minecraft.f_91073_ != null ? minecraft.f_91073_.m_151558_() : 256;
        }
        List<MutableComponent> texts = List.of(TextCompat.translatable("cobblegen.info.weight").m_7220_(Component.m_130674_((String)this.getResult().weight.toString())), TextCompat.translatable("cobblegen.info.minY").m_7220_(Component.m_130674_((String)minY.toString())), TextCompat.translatable("cobblegen.info.maxY").m_7220_(Component.m_130674_((String)maxY.toString())));
        int y = base.y;
        for (Component component : texts) {
            Point labelPoint = new Point(this.getDisplayWidth() - textRenderer.m_92852_((FormattedText)component), y);
            widgets.addText(component, labelPoint.x, labelPoint.y, -1, true);
            y += 9;
        }
        MutableComponent text = TextCompat.translatable("cobblegen.info.dimensions");
        Point point = new Point(this.getDisplayWidth() / 2 - textRenderer.m_92852_((FormattedText)text) / 2, resultMod.y + 18 + 9);
        widgets.addText((Component)text, point.x, point.y, -1, true);
        Point dimensionBounds = (Point)base.clone();
        dimensionBounds.y = point.y + 18;
        Point whitelistBounds = (Point)dimensionBounds.clone();
        whitelistBounds.x += 18;
        ArrayList<ClientTooltipComponent> whitelist = new ArrayList<ClientTooltipComponent>();
        whitelist.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)TextCompat.translatable("cobblegen.info.whitelistedDim").m_7532_()));
        List<String> recipeWhitelist = this.getResult().dimensions;
        try {
            for (String dim : recipeWhitelist) {
                ResourceLocation id;
                try {
                    id = ResourceLocation.m_135820_((String)dim);
                }
                catch (Exception e) {
                    continue;
                }
                whitelist.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)TextCompat.literal("- " + id).m_7532_()));
            }
        }
        catch (NullPointerException ignored) {
            whitelist.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)TextCompat.literal("- ").m_7220_((Component)TextCompat.translatable("cobblegen.dim.any")).m_7532_()));
        }
        widgets.addTexture(Constants.JEI_UI_COMPONENT.toMC(), whitelistBounds.x, whitelistBounds.y, 15, 20, 0, 0).tooltip((mouseX, mouseY) -> whitelist);
        Point blacklistBounds = (Point)dimensionBounds.clone();
        blacklistBounds.x += this.getDisplayWidth() - 15 - 18;
        ArrayList<ClientTooltipComponent> blacklist = new ArrayList<ClientTooltipComponent>();
        blacklist.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)TextCompat.translatable("cobblegen.info.blacklistedDim").m_7532_()));
        List<String> recipeBlacklist = this.getResult().excludedDimensions;
        try {
            for (String dim : recipeBlacklist) {
                ResourceLocation id;
                try {
                    id = ResourceLocation.m_135820_((String)dim);
                }
                catch (Exception e) {
                    continue;
                }
                blacklist.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)TextCompat.literal("- " + id).m_7532_()));
            }
        }
        catch (NullPointerException ignored) {
            blacklist.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)TextCompat.literal("- ").m_7220_((Component)TextCompat.translatable("cobblegen.dim.none")).m_7532_()));
        }
        widgets.addTexture(Constants.JEI_UI_COMPONENT.toMC(), blacklistBounds.x, blacklistBounds.y, 15, 20, 15, 0).tooltip((mouseX, mouseY) -> blacklist);
    }

    public ResourceLocation getId() {
        ResourceLocation resultId;
        try {
            resultId = ResourceLocation.m_135820_((String)this.getResult().id);
        }
        catch (Exception e) {
            resultId = Util.identifierOf(this.getResult().id);
        }
        ResourceLocation source = Util.getFluidId(this.getSourceFluid());
        ResourceLocation neighbour = this.getNeighbourBlock().equals(Blocks.f_50016_) ? Util.getFluidId(this.getNeighbourFluid()) : Util.getBlockId(this.getNeighbourBlock());
        ResourceLocation modifierId = Util.identifierOf("none");
        if (!this.getModifier().equals(Blocks.f_50016_)) {
            modifierId = Util.getBlockId(this.getModifier());
        }
        return Util.identifierOf("fluid_interaction_" + this.getType().name().toLowerCase() + "-" + source.m_179910_() + "-" + resultId.m_179910_() + "-" + neighbour.m_179910_() + "-" + modifierId.m_179910_());
    }

    static {
        IBootstrap.dasBoot();
    }
}

