/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.null2264.cobblegen.compat.GraphicsCompat;
import io.github.null2264.cobblegen.compat.TextCompat;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.integration.viewer.FluidInteractionRecipeHolder;
import io.github.null2264.cobblegen.util.Constants;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class FluidInteractionCategory
implements IRecipeCategory<FluidInteractionRecipeHolder> {
    private final IDrawable background;
    private final Long full;
    private final IDrawable icon;
    private final GeneratorType type;
    private final int initialHeight;
    private final IDrawable whitelistIcon;
    private final IDrawable blacklistIcon;
    private int dimensionIconsY = 0;

    public FluidInteractionCategory(IGuiHelper guiHelper, IPlatformFluidHelper<?> fluidHelper, GeneratorType generatorType) {
        this.initialHeight = generatorType.equals((Object)GeneratorType.STONE) ? 56 : 36;
        this.background = guiHelper.createBlankDrawable(136, this.initialHeight + 18 + 20 + 9);
        this.full = 10L * fluidHelper.bucketVolume();
        ItemStack iconStack = Items.f_41852_.m_7968_();
        switch (generatorType) {
            case COBBLE: {
                iconStack = Items.f_42594_.m_7968_();
                break;
            }
            case STONE: {
                iconStack = Items.f_41905_.m_7968_();
                break;
            }
            case BASALT: {
                iconStack = Items.f_42051_.m_7968_();
            }
        }
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)iconStack);
        this.type = generatorType;
        this.whitelistIcon = guiHelper.drawableBuilder(Constants.JEI_UI_COMPONENT.toMC(), 0, 0, 15, 20).build();
        this.blacklistIcon = guiHelper.drawableBuilder(Constants.JEI_UI_COMPONENT.toMC(), 15, 0, 15, 20).build();
    }

    @NotNull
    public RecipeType<FluidInteractionRecipeHolder> getRecipeType() {
        return new RecipeType(Util.identifierOf(this.type), FluidInteractionRecipeHolder.class);
    }

    @NotNull
    public Component getTitle() {
        return TextCompat.translatable("cobblegen.generators." + this.type.name().toLowerCase());
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidInteractionRecipeHolder recipe, IFocusGroup focuses) {
        WeightedBlock output = recipe.getResult();
        Block modifier = recipe.getModifier();
        Fluid source = recipe.getSourceFluid();
        Fluid neighbourFluid = recipe.getNeighbourFluid();
        Block neighbourBlock = recipe.getNeighbourBlock();
        int offset = 18;
        int x = 0;
        int y = 0;
        int gap = 2;
        int coldY = y;
        int lavaX = x + 40;
        int resultX = x + 18 + 2;
        int resultY = y;
        int resultModY = y + 18 + 2;
        if (this.type.equals((Object)GeneratorType.STONE)) {
            lavaX = x + 18 + 2;
            coldY = y + 18 + 2;
            resultY = resultModY;
            resultModY = resultModY + 18 + 2;
        }
        IRecipeSlotBuilder coldBuilder = builder.addSlot(RecipeIngredientRole.INPUT, x, coldY);
        if (this.type.equals((Object)GeneratorType.BASALT)) {
            coldBuilder.addItemStack(neighbourBlock.m_5456_().m_7968_());
        } else {
            coldBuilder.addFluidStack(neighbourFluid, this.full.longValue());
        }
        builder.addSlot(RecipeIngredientRole.INPUT, lavaX, y).addFluidStack(source, this.full.longValue());
        builder.addSlot(RecipeIngredientRole.OUTPUT, resultX, resultY).addItemStack(output.getBlock().m_5456_().m_7968_());
        builder.addSlot(RecipeIngredientRole.INPUT, resultX, resultModY).addItemStack(modifier.m_5456_().m_7968_());
    }

    public void draw(FluidInteractionRecipeHolder recipe, IRecipeSlotsView recipeSlotsView, PoseStack graphicsTarget, double mouseX, double mouseY) {
        int n;
        Integer maxY;
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        Integer minY = recipe.getResult().minY;
        if (minY == null) {
            minY = minecraft.f_91073_ != null ? minecraft.f_91073_.m_141937_() : 0;
        }
        if ((maxY = recipe.getResult().maxY) == null) {
            maxY = minecraft.f_91073_ != null ? minecraft.f_91073_.m_151558_() : 256;
        }
        List<MutableComponent> texts = List.of(TextCompat.translatable("cobblegen.info.weight").m_7220_(Component.m_130674_((String)recipe.getResult().weight.toString())), TextCompat.translatable("cobblegen.info.minY").m_7220_(Component.m_130674_((String)minY.toString())), TextCompat.translatable("cobblegen.info.maxY").m_7220_(Component.m_130674_((String)maxY.toString())));
        int y = 0;
        for (Component component : texts) {
            int width = font.m_92852_((FormattedText)component);
            GraphicsCompat.drawString(graphicsTarget, component, this.getBackground().getWidth() - width, y, -8355712);
            Objects.requireNonNull(font);
            y += 9;
        }
        MutableComponent text = TextCompat.translatable("cobblegen.info.dimensions");
        int n2 = this.initialHeight + 9;
        GraphicsCompat.drawString(graphicsTarget, (Component)text, (int)((float)this.getBackground().getWidth() / 2.0f - (float)font.m_92852_((FormattedText)text) / 2.0f), n2, -8355712);
        Objects.requireNonNull(font);
        this.dimensionIconsY = n = n2 + 9 + 9;
        this.whitelistIcon.draw(graphicsTarget, 18, n);
        this.blacklistIcon.draw(graphicsTarget, this.getBackground().getWidth() - 15 - 18, n);
    }

    @NotNull
    public List<Component> getTooltipStrings(FluidInteractionRecipeHolder recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 18.0 && mouseX < 33.0 && mouseY > (double)this.dimensionIconsY && mouseY < (double)(this.dimensionIconsY + 20)) {
            ArrayList<Component> biomeList = new ArrayList<Component>();
            biomeList.add((Component)TextCompat.translatable("cobblegen.info.whitelistedDim"));
            List<String> recipeDimList = recipe.getResult().dimensions;
            try {
                for (String dim : recipeDimList) {
                    ResourceLocation id;
                    try {
                        id = ResourceLocation.m_135820_((String)dim);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    biomeList.add((Component)TextCompat.literal("- " + id));
                }
            }
            catch (NullPointerException ignored) {
                biomeList.add((Component)TextCompat.literal("- ").m_7220_((Component)TextCompat.translatable("cobblegen.dim.any")));
            }
            return biomeList;
        }
        int aetherX = this.getBackground().getWidth() - 18;
        if (mouseX > (double)(aetherX - 15) && mouseX < (double)aetherX && mouseY > (double)this.dimensionIconsY && mouseY < (double)(this.dimensionIconsY + 20)) {
            ArrayList<Component> biomeList = new ArrayList<Component>();
            biomeList.add((Component)TextCompat.translatable("cobblegen.info.blacklistedDim"));
            List<String> recipeDimList = recipe.getResult().excludedDimensions;
            try {
                for (String dim : recipeDimList) {
                    ResourceLocation id;
                    try {
                        id = ResourceLocation.m_135820_((String)dim);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    biomeList.add((Component)TextCompat.literal("- " + id));
                }
            }
            catch (NullPointerException ignored) {
                biomeList.add((Component)TextCompat.literal("- ").m_7220_((Component)TextCompat.translatable("cobblegen.dim.none")));
            }
            return biomeList;
        }
        return List.of();
    }

    static {
        IBootstrap.dasBoot();
    }
}

