/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.rei;

import io.github.null2264.cobblegen.compat.TextCompat;
import io.github.null2264.cobblegen.integration.viewer.rei.FluidInteractionRecipe;
import io.github.null2264.cobblegen.util.Constants;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class FluidInteractionCategory
implements DisplayCategory<FluidInteractionRecipe> {
    public static String ID_PREFIX;
    private final Renderer icon;
    private final GeneratorType type;
    private final int initialHeight;

    public FluidInteractionCategory(GeneratorType generatorType) {
        this.initialHeight = generatorType.equals((Object)GeneratorType.STONE) ? 56 : 36;
        ItemStack iconStack = Items.f_41852_.m_7968_();
        switch (generatorType) {
            case COBBLE: {
                iconStack = Items.f_42594_.m_7968_();
                break;
            }
            case STONE: {
                iconStack = Items.f_41905_.m_7968_();
                break;
            }
            case BASALT: {
                iconStack = Items.f_42051_.m_7968_();
            }
        }
        this.icon = EntryStacks.of((ItemStack)iconStack);
        this.type = generatorType;
    }

    public static CategoryIdentifier<? extends FluidInteractionRecipe> generateIdentifier(GeneratorType type) {
        return CategoryIdentifier.of((ResourceLocation)Util.identifierOf(ID_PREFIX + type.name().toLowerCase()));
    }

    public int getDisplayHeight() {
        return this.initialHeight + 6 + 18 + 20 + 9 + 6 + 2;
    }

    public Component getTitle() {
        return TextCompat.translatable("cobblegen.generators." + this.type.name().toLowerCase());
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public List<Widget> setupDisplay(FluidInteractionRecipe display, Rectangle bounds) {
        Integer maxY;
        int offset = 18;
        int gap = 2;
        int gapAgainstBound = 6;
        Rectangle base = bounds.clone();
        base.resize(18, 18);
        base.translate(6, 6);
        Rectangle cold = base.clone();
        Rectangle lava = base.clone();
        lava.x += 40;
        Rectangle result = base.clone();
        result.x += 20;
        Rectangle resultMod = result.clone();
        resultMod.y += 20;
        if (this.type == GeneratorType.STONE) {
            lava.x -= 20;
            cold.y += 20;
            result.y = resultMod.y;
            resultMod.y += 20;
        }
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add((Widget)Widgets.createSlot((Rectangle)lava).entries((Collection)display.getInputEntries().get(0)).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Rectangle)cold).entries((Collection)display.getInputEntries().get(1)).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Rectangle)result).entries((Collection)display.getOutputEntries().get(0)).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Rectangle)resultMod).entry((EntryStack)display.getInputEntries().get(2).get(0)).markInput().disableBackground());
        Minecraft minecraft = Minecraft.m_91087_();
        Integer minY = display.getResult().minY;
        if (minY == null) {
            minY = minecraft.f_91073_ != null ? minecraft.f_91073_.m_141937_() : 0;
        }
        if ((maxY = display.getResult().maxY) == null) {
            maxY = minecraft.f_91073_ != null ? minecraft.f_91073_.m_151558_() : 256;
        }
        List<MutableComponent> texts = List.of(TextCompat.translatable("cobblegen.info.weight").m_7220_(Component.m_130674_((String)display.getResult().weight.toString())), TextCompat.translatable("cobblegen.info.minY").m_7220_(Component.m_130674_((String)minY.toString())), TextCompat.translatable("cobblegen.info.maxY").m_7220_(Component.m_130674_((String)maxY.toString())));
        int y = base.y;
        for (Component component : texts) {
            Point labelPoint = new Point(bounds.x + this.getDisplayWidth(display) - 6, y);
            Label label = Widgets.createLabel((Point)labelPoint, (Component)component).rightAligned().noShadow().color(-12566464, -4473925);
            widgets.add((Widget)label);
            y += 9;
        }
        MutableComponent text = TextCompat.translatable("cobblegen.info.dimensions");
        Point point = new Point(bounds.getCenterX(), resultMod.y + 18 + 9);
        widgets.add((Widget)Widgets.createLabel((Point)point, (Component)text).centered().noShadow().color(-12566464, -4473925));
        Rectangle dimensionBounds = base.clone();
        dimensionBounds.resize(15, 20);
        dimensionBounds.y = point.y + 18;
        Rectangle whitelistBounds = dimensionBounds.clone();
        whitelistBounds.x += 18;
        Widget whitelistIcon = Widgets.createTexturedWidget((ResourceLocation)Constants.JEI_UI_COMPONENT.toMC(), (Rectangle)whitelistBounds, (float)0.0f, (float)0.0f, (int)256, (int)256);
        ArrayList<MutableComponent> whitelist = new ArrayList<MutableComponent>();
        whitelist.add(TextCompat.translatable("cobblegen.info.whitelistedDim"));
        List<String> recipeWhitelist = display.getResult().dimensions;
        try {
            for (String dim : recipeWhitelist) {
                ResourceLocation id;
                try {
                    id = ResourceLocation.m_135820_((String)dim);
                }
                catch (Exception e) {
                    continue;
                }
                whitelist.add(TextCompat.literal("- " + id));
            }
        }
        catch (NullPointerException ignored) {
            whitelist.add(TextCompat.literal("- ").m_7220_((Component)TextCompat.translatable("cobblegen.dim.any")));
        }
        widgets.add((Widget)Widgets.withTooltip((WidgetWithBounds)Widgets.withBounds((Widget)whitelistIcon, (Rectangle)whitelistBounds), whitelist));
        Rectangle blacklistBounds = dimensionBounds.clone();
        blacklistBounds.x += bounds.width - 15 - 18 - 12;
        Widget blacklistIcon = Widgets.createTexturedWidget((ResourceLocation)Constants.JEI_UI_COMPONENT.toMC(), (Rectangle)blacklistBounds, (float)15.0f, (float)0.0f, (int)256, (int)256);
        ArrayList<MutableComponent> blacklist = new ArrayList<MutableComponent>();
        blacklist.add(TextCompat.translatable("cobblegen.info.blacklistedDim"));
        List<String> recipeBlacklist = display.getResult().excludedDimensions;
        try {
            for (String dim : recipeBlacklist) {
                ResourceLocation id;
                try {
                    id = ResourceLocation.m_135820_((String)dim);
                }
                catch (Exception e) {
                    continue;
                }
                blacklist.add(TextCompat.literal("- " + id));
            }
        }
        catch (NullPointerException ignored) {
            blacklist.add(TextCompat.literal("- ").m_7220_((Component)TextCompat.translatable("cobblegen.dim.none")));
        }
        widgets.add((Widget)Widgets.withTooltip((WidgetWithBounds)Widgets.withBounds((Widget)blacklistIcon, (Rectangle)blacklistBounds), blacklist));
        return widgets;
    }

    public CategoryIdentifier<? extends FluidInteractionRecipe> getCategoryIdentifier() {
        return FluidInteractionCategory.generateIdentifier(this.type);
    }

    static {
        IBootstrap.dasBoot();
        ID_PREFIX = "fluid_interaction_";
    }
}

