/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.mixin.fluid;

import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LiquidBlock.class})
public abstract class FluidEventMixin {
    @Shadow
    @Final
    protected FlowingFluid f_54689_;

    @Unique
    private void doInteraction(Level level, BlockPos pos, BlockState state, CallbackInfo ci) {
        boolean success = CobbleGen.FLUID_INTERACTION.interact((LevelAccessor)level, pos, state);
        if (success) {
            ci.cancel();
        }
    }

    @Unique
    private void doInteraction(Level level, BlockPos pos, BlockState state, CallbackInfoReturnable<Boolean> cir) {
        boolean success = CobbleGen.FLUID_INTERACTION.interact((LevelAccessor)level, pos, state);
        if (success) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"onPlace"}, at={@At(value="HEAD")}, cancellable=true)
    private void fluidInteraction$onPlace(BlockState state, Level level, BlockPos pos, BlockState blockState2, boolean bl, CallbackInfo ci) {
        this.doInteraction(level, pos, state, ci);
    }

    @Inject(method={"neighborChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void fluidInteraction$neighborChangede(BlockState state, Level level, BlockPos pos, Block block, BlockPos blockPos2, boolean bl, CallbackInfo ci) {
        this.doInteraction(level, pos, state, ci);
    }

    @Inject(method={"shouldSpreadLiquid"}, at={@At(value="HEAD")}, cancellable=true)
    private void fluidInteraction$shouldSpreadLiquids(Level level, BlockPos pos, BlockState state, CallbackInfoReturnable<Boolean> cir) {
        this.doInteraction(level, pos, state, cir);
    }

    static {
        IBootstrap.dasBoot();
    }
}

