/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.util;

import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGLog {
    public static final Logger LOG;
    private static final String prefix = "[CobbleGen] ";

    public static void debug(String s, String ... a) {
        if (!CobbleGen.META_CONFIG.debugLog.booleanValue()) {
            return;
        }
        StringBuilder rt = new StringBuilder(prefix + s);
        for (String s1 : a) {
            rt.append(" ").append(s1);
        }
        LOG.info(rt.toString());
    }

    public static void info(String s, String ... a) {
        StringBuilder rt = new StringBuilder(prefix + s);
        for (String s1 : a) {
            rt.append(" ").append(s1);
        }
        LOG.info(rt.toString());
    }

    public static void warn(String s, String ... a) {
        StringBuilder rt = new StringBuilder(prefix + s);
        for (String s1 : a) {
            rt.append(" ").append(s1);
        }
        LOG.warn(rt.toString());
    }

    public static void error(String s, String ... a) {
        StringBuilder rt = new StringBuilder(prefix + s);
        for (String s1 : a) {
            rt.append(" ").append(s1);
        }
        LOG.error(rt.toString());
    }

    public static void error(String prefix, Throwable t) {
        String builder = prefix + CGLog.errorString(t);
        CGLog.error(builder, new String[0]);
    }

    public static void error(Throwable t) {
        CGLog.error(CGLog.errorString(t), new String[0]);
    }

    public static String errorString(Throwable t) {
        StackTraceElement[] trace;
        StringBuilder builder = new StringBuilder();
        builder.append(t.toString());
        for (StackTraceElement traceElement : trace = t.getStackTrace()) {
            builder.append("\n\tat ").append(traceElement);
        }
        return builder.toString();
    }

    static {
        IBootstrap.dasBoot();
        LOG = LoggerFactory.getLogger((String)"CobbleGen");
    }
}

