/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.util;

import io.github.null2264.cobblegen.CGPlugin;
import io.github.null2264.cobblegen.CobbleGenPlugin;
import io.github.null2264.cobblegen.compat.CollectionCompat;
import io.github.null2264.cobblegen.util.CGLog;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;

public class PluginFinder {
    public static List<PlugInContainer> getModPlugins() {
        return AnnotatedFinder.getInstances(CGPlugin.class, CobbleGenPlugin.class);
    }

    static {
        IBootstrap.dasBoot();
    }

    static class AnnotatedFinder {
        AnnotatedFinder() {
        }

        public static <T> List<PlugInContainer> getInstances(Class<?> annotationClass, Class<T> instanceClass) {
            Type annotationType = Type.getType(annotationClass);
            List allScanData = ModList.get().getAllScanData();
            ArrayList<PlugInContainer> instances = new ArrayList<PlugInContainer>();
            for (ModFileScanData data : allScanData) {
                List<String> modIds = CollectionCompat.streamToList(data.getIModInfoData().stream().flatMap(info -> info.getMods().stream()).map(IModInfo::getModId));
                String modId = "[" + String.join((CharSequence)", ", modIds) + "]";
                Set annotations = data.getAnnotations();
                for (ModFileScanData.AnnotationData a : annotations) {
                    if (!Objects.equals(a.annotationType(), annotationType)) continue;
                    String className = a.memberName();
                    try {
                        Class<?> asmClass = Class.forName(className);
                        Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                        Constructor<T> constructor = asmInstanceClass.getDeclaredConstructor(new Class[0]);
                        T instance = constructor.newInstance(new Object[0]);
                        instances.add(new PlugInContainer(modId, (CobbleGenPlugin)instance));
                    }
                    catch (Throwable t) {
                        CGLog.error("Failed to load: " + className + " ", t);
                    }
                }
            }
            return instances;
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    @ApiStatus.Internal
    public static class PlugInContainer {
        final String modId;
        final CobbleGenPlugin plugin;

        public PlugInContainer(String modId, CobbleGenPlugin plugin) {
            this.modId = modId;
            this.plugin = plugin;
        }

        public String getModId() {
            return this.modId;
        }

        public CobbleGenPlugin getPlugin() {
            return this.plugin;
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

