/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.util;

import io.github.null2264.cobblegen.compat.LoaderCompat;
import io.github.null2264.cobblegen.compat.RegistryCompat;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static ResourceLocation identifierOf(GeneratorType type) {
        return Util.identifierOf(type.name().toLowerCase());
    }

    public static ResourceLocation identifierOf(String id) {
        return Util.identifierOf("cobblegen", id);
    }

    public static ResourceLocation identifierOf(String namespace, String id) {
        return new ResourceLocation(namespace, id);
    }

    @NotNull
    public static <T> T notNullOr(@Nullable T nullable, @NotNull T notNull) {
        if (nullable == null) {
            return notNull;
        }
        return nullable;
    }

    @NotNull
    public static <T> Optional<T> optional(@Nullable T nullable) {
        if (nullable == null) {
            return Optional.empty();
        }
        return Optional.of(nullable);
    }

    public static boolean isPortingLibLoaded() {
        return LoaderCompat.isModLoaded("porting_lib");
    }

    public static boolean isAnyRecipeViewerLoaded() {
        return LoaderCompat.isModLoaded("roughlyenoughitems") || LoaderCompat.isModLoaded("jei") || LoaderCompat.isModLoaded("emi");
    }

    public static Fluid getFluid(ResourceLocation id) {
        return (Fluid)RegistryCompat.fluid().m_7745_(id);
    }

    public static ResourceLocation getFluidId(Fluid fluid) {
        return RegistryCompat.fluid().m_7981_((Object)fluid);
    }

    public static Block getBlock(ResourceLocation id) {
        return (Block)RegistryCompat.block().m_7745_(id);
    }

    public static ResourceLocation getBlockId(Block block) {
        return RegistryCompat.block().m_7981_((Object)block);
    }

    public static List<ResourceLocation> getTaggedBlockIds(ResourceLocation tagId) {
        TagKey blockTag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)tagId);
        Optional blockList = RegistryCompat.block().m_203431_(blockTag);
        ArrayList<ResourceLocation> blockIds = new ArrayList<ResourceLocation>();
        blockList.ifPresent(t -> t.m_203614_().forEach(taggedBlock -> {
            Optional key = taggedBlock.m_203543_();
            key.ifPresent(k -> blockIds.add(k.m_135782_()));
        }));
        return blockIds;
    }

    public static String getDimension(LevelAccessor level) {
        ResourceLocation dim = level.m_5962_().m_175515_(Registry.f_122818_).m_7981_((Object)level.m_6042_());
        return dim != null ? dim.toString() : "minecraft:overworld";
    }

    @Nullable
    public static String getBiome(LevelAccessor level, BlockPos position) {
        ResourceLocation biome = level.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)((Biome)level.m_204166_(position).m_203334_()));
        return biome != null ? biome.toString() : null;
    }

    static {
        IBootstrap.dasBoot();
    }
}

