/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.shadowed.manifold.util;

import io.github.null2264.shadowed.manifold.util.ReflectUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import jdk.internal.loader.BootLoader;
import jdk.internal.loader.ClassLoaders;

public class LazyClassPathLookupIterator<T>
implements Iterator<ServiceLoader.Provider<T>> {
    static final String PREFIX = "META-INF/services/";
    Set<String> providerNames = new HashSet<String>();
    Enumeration<URL> configs;
    Iterator<String> pending;
    ServiceLoader.Provider<T> nextProvider;
    ServiceConfigurationError nextError;
    Class<?> service;
    ClassLoader loader;

    LazyClassPathLookupIterator(Class<?> service, ClassLoader loader) {
        this.service = service;
        this.loader = loader;
    }

    private int parseLine(URL u, BufferedReader r, int lc, Set<String> names) throws IOException {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int start;
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                LazyClassPathLookupIterator.fail(this.service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                LazyClassPathLookupIterator.fail(this.service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = start = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                LazyClassPathLookupIterator.fail(this.service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (this.providerNames.add(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    private static void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
        LazyClassPathLookupIterator.fail(service, u + ":" + line + ": " + msg);
    }

    private Iterator<String> parse(URL u) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        try {
            URLConnection uc = u.openConnection();
            uc.setUseCaches(false);
            try (InputStream in = uc.getInputStream();
                 BufferedReader r = new BufferedReader(new InputStreamReader(in, "utf-8"));){
                int lc = 1;
                while ((lc = this.parseLine(u, r, lc, names)) >= 0) {
                }
            }
        }
        catch (IOException x) {
            LazyClassPathLookupIterator.fail(this.service, "Error accessing configuration file", x);
        }
        return names.iterator();
    }

    private Class<?> nextProviderClass() {
        if (this.configs == null) {
            try {
                String fullName = PREFIX + this.service.getName();
                this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : (this.loader == ClassLoaders.platformClassLoader() ? (BootLoader.hasClassPath() ? BootLoader.findResources(fullName) : Collections.emptyEnumeration()) : this.loader.getResources(fullName));
            }
            catch (IOException x) {
                LazyClassPathLookupIterator.fail(this.service, "Error locating configuration files", x);
            }
        }
        while (this.pending == null || !this.pending.hasNext()) {
            if (!this.configs.hasMoreElements()) {
                return null;
            }
            this.pending = this.parse(this.configs.nextElement());
        }
        String cn = this.pending.next();
        try {
            return Class.forName(cn, false, this.loader);
        }
        catch (ClassNotFoundException x) {
            LazyClassPathLookupIterator.fail(this.service, "Provider " + cn + " not found");
            return null;
        }
    }

    private boolean hasNextService() {
        while (this.nextProvider == null && this.nextError == null) {
            try {
                Class<?> clazz = this.nextProviderClass();
                if (clazz == null) {
                    return false;
                }
                if (this.service.isAssignableFrom(clazz)) {
                    Class<?> type = clazz;
                    Constructor<?> ctor = ReflectUtil.constructor(clazz, new Class[0]).getConstructor();
                    ProviderImpl p = new ProviderImpl(this.service, type, ctor);
                    this.nextProvider = p;
                    continue;
                }
                LazyClassPathLookupIterator.fail(this.service, clazz.getName() + " not a subtype");
            }
            catch (ServiceConfigurationError e) {
                this.nextError = e;
            }
        }
        return true;
    }

    private ServiceLoader.Provider<T> nextService() {
        if (!this.hasNextService()) {
            throw new NoSuchElementException();
        }
        ServiceLoader.Provider<T> provider = this.nextProvider;
        if (provider != null) {
            this.nextProvider = null;
            return provider;
        }
        ServiceConfigurationError e = this.nextError;
        assert (e != null);
        this.nextError = null;
        throw e;
    }

    @Override
    public boolean hasNext() {
        return this.hasNextService();
    }

    @Override
    public ServiceLoader.Provider<T> next() {
        return this.nextService();
    }

    private static class ProviderImpl<S>
    implements ServiceLoader.Provider<S> {
        final Class<S> service;
        final Class<? extends S> type;
        final Constructor<? extends S> ctor;

        ProviderImpl(Class<S> service, Class<? extends S> type, Constructor<? extends S> ctor) {
            this.service = service;
            this.type = type;
            this.ctor = ctor;
        }

        @Override
        public Class<? extends S> type() {
            return this.type;
        }

        @Override
        public S get() {
            return this.newInstance();
        }

        private S newInstance() {
            S p = null;
            Throwable exc = null;
            try {
                p = this.ctor.newInstance(new Object[0]);
            }
            catch (Throwable x) {
                exc = x;
            }
            if (exc != null) {
                if (exc instanceof InvocationTargetException) {
                    exc = exc.getCause();
                }
                String cn = this.ctor.getDeclaringClass().getName();
                LazyClassPathLookupIterator.fail(this.service, "Provider " + cn + " could not be instantiated", exc);
            }
            return p;
        }

        public int hashCode() {
            return Objects.hash(this.service, this.type);
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof ProviderImpl)) {
                return false;
            }
            ProviderImpl that = (ProviderImpl)ob;
            return this.service == that.service && this.type == that.type;
        }
    }
}

