/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.shadowed.manifold.util;

import io.github.null2264.shadowed.manifold.util.MethodScore;
import io.github.null2264.shadowed.manifold.util.PrimitiveUtil;
import io.github.null2264.shadowed.manifold.util.TypeAncestry;
import io.github.null2264.shadowed.manifold.util.concurrent.Cache;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MethodScorer {
    public static final int BOXED_COERCION_SCORE = 10;
    public static final int PRIMITIVE_COERCION_SCORE = 24;
    private static volatile MethodScorer INSTANCE = null;
    private final Cache<Pair<Class, Class>, Integer> _typeScoreCache = Cache.make("Type Score Cache", 10000, key -> this._addToScoreForTypes((Class)((Pair)key).fst, (Class)((Pair)key).snd));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodScorer instance() {
        if (INSTANCE != null) return INSTANCE;
        Class<MethodScorer> clazz = MethodScorer.class;
        synchronized (MethodScorer.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new MethodScorer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private MethodScorer() {
    }

    public List<MethodScore> scoreMethods(List<Method> funcTypes, List<Class> argTypes, Class returnType) {
        ArrayList<MethodScore> scores = new ArrayList<MethodScore>();
        for (Method funcType : funcTypes) {
            scores.add(this.scoreMethod(funcType, argTypes, returnType));
        }
        Collections.sort(scores);
        return scores;
    }

    public MethodScore scoreMethod(Method funcType, List<Class> argTypes, Class returnType) {
        MethodScore score = new MethodScore(null);
        score.setValid(true);
        score.setMethod(funcType);
        score.incScore(this.scoreMethod(score, funcType, argTypes, returnType));
        return score;
    }

    public int scoreMethod(MethodScore score, Method funcType, List<Class> argTypes, Class returnType) {
        int i;
        Class<?>[] paramTypes = funcType.getParameterTypes();
        int iScore = 0;
        for (i = 0; i < argTypes.size(); ++i) {
            if (paramTypes.length <= i) {
                iScore += 128;
                score.setErrant(true);
                continue;
            }
            Class argType = argTypes.get(i);
            int paramScore = this.addToScoreForTypes(paramTypes[i], argType);
            iScore += paramScore;
            if (paramScore < 126) continue;
            score.setErrant(true);
        }
        for (i = argTypes.size(); i < paramTypes.length; ++i) {
            iScore += 127;
            score.setErrant(true);
        }
        if (funcType.isVarArgs()) {
            ++iScore;
        }
        if (funcType.getReturnType() != Void.TYPE) {
            int returnScore = this.addToScoreForTypes(returnType, funcType.getReturnType());
            iScore += returnScore;
            if (returnScore >= 126) {
                score.setErrant(true);
            }
        }
        return iScore;
    }

    public int addToScoreForTypes(Class paramType, Class argType) {
        if (argType == paramType) {
            return 0;
        }
        return this._typeScoreCache.get(new Pair<Class, Class>(paramType, argType));
    }

    public int _addToScoreForTypes(Class<?> paramType, Class argType) {
        Class boxedArgType;
        Class primitiveArgType;
        Class primitiveParamType;
        int iScore = paramType.equals(argType) ? 0 : (!paramType.isPrimitive() && argType == Void.TYPE ? 1 : (this.arePrimitiveTypesCompatible(paramType, argType) ? PrimitiveUtil.getPriorityOf(paramType, argType) : (PrimitiveUtil.isBoxedTypeFor(paramType, argType) || PrimitiveUtil.isBoxedTypeFor(argType, paramType) ? 10 : (argType.isPrimitive() && PrimitiveUtil.isBoxed(paramType) && this.arePrimitiveTypesCompatible(primitiveParamType = PrimitiveUtil.getPrimitiveType(paramType), argType) ? 10 + PrimitiveUtil.getPriorityOf(primitiveParamType, argType) : (PrimitiveUtil.isBoxed(argType) && paramType.isPrimitive() && this.arePrimitiveTypesCompatible(paramType, primitiveArgType = PrimitiveUtil.getPrimitiveType(argType)) ? 10 + PrimitiveUtil.getPriorityOf(paramType, primitiveArgType) : (PrimitiveUtil.isBoxed(argType) && PrimitiveUtil.isBoxed(paramType) && this.arePrimitiveTypesCompatible(primitiveParamType = PrimitiveUtil.getPrimitiveType(paramType), primitiveArgType = PrimitiveUtil.getPrimitiveType(argType)) ? 20 + PrimitiveUtil.getPriorityOf(primitiveParamType, primitiveArgType) : (argType.isPrimitive() && argType != Void.TYPE && !paramType.isPrimitive() && paramType.isAssignableFrom(boxedArgType = PrimitiveUtil.getBoxedType(argType)) ? 10 + this.addDegreesOfSeparation(paramType, boxedArgType) : (paramType.isAssignableFrom(argType) ? this.addDegreesOfSeparation(paramType, argType) : 126))))))));
        return iScore;
    }

    private boolean arePrimitiveTypesCompatible(Class paramType, Class argType) {
        return PrimitiveUtil.arePrimitiveTypesAssignable(paramType, argType) || paramType.isPrimitive() && argType.isPrimitive() && paramType != Boolean.TYPE && argType != Boolean.TYPE && paramType != Character.TYPE && argType != Character.TYPE && paramType != Void.TYPE && argType != Void.TYPE && PrimitiveUtil.losesInformation(argType, paramType) <= 1;
    }

    public int addDegreesOfSeparation(Class parameterType, Class exprType) {
        return this.addDegreesOfSeparation(parameterType, TypeAncestry.instance().getTypesInAncestry(exprType));
    }

    public int addDegreesOfSeparation(Class<?> parameterType, Set<? extends Class> types) {
        int iScore = 0;
        for (Class clazz : types) {
            if (parameterType == clazz || !parameterType.isAssignableFrom(clazz)) continue;
            ++iScore;
        }
        return iScore;
    }

    static class Pair<F, S> {
        private F fst;
        private S snd;

        public Pair(F fst, S snd) {
            this.fst = fst;
            this.snd = snd;
        }
    }
}

