/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.animations.BodyPart;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.UseAnim;

public class EatDrinkAnimation
extends BasicAnimation {
    private BodyPart[] target;
    private final BodyPart[] left = new BodyPart[]{BodyPart.LEFT_ARM};
    private final BodyPart[] right = new BodyPart[]{BodyPart.RIGHT_ARM};
    private final BodyPart[] leftFixed = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.BODY};
    private final BodyPart[] rightFixed = new BodyPart[]{BodyPart.RIGHT_ARM, BodyPart.BODY};

    @Override
    public boolean isEnabled() {
        return NEAnimationsLoader.config.enableEatDrinkAnimation;
    }

    @Override
    public boolean isValid(AbstractClientPlayer entity, PlayerData data) {
        UseAnim action;
        if (entity.m_21212_() > 0 && ((action = entity.m_21211_().m_41780_()) == UseAnim.EAT || action == UseAnim.DRINK)) {
            this.target = entity.m_7655_() == InteractionHand.MAIN_HAND ? (entity.m_5737_() == HumanoidArm.RIGHT ? (NEAnimationsLoader.config.enableRotationLocking ? this.rightFixed : this.right) : (NEAnimationsLoader.config.enableRotationLocking ? this.leftFixed : this.left)) : (entity.m_5737_() == HumanoidArm.RIGHT ? (NEAnimationsLoader.config.enableRotationLocking ? this.leftFixed : this.left) : (NEAnimationsLoader.config.enableRotationLocking ? this.rightFixed : this.right));
            return true;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayer entity, PlayerData data) {
        return this.target;
    }

    @Override
    public int getPriority(AbstractClientPlayer entity, PlayerData data) {
        return 2500;
    }

    @Override
    public void apply(AbstractClientPlayer entity, PlayerData data, PlayerModel<AbstractClientPlayer> model, BodyPart part, float delta, float tickCounter) {
        if (part == BodyPart.BODY) {
            data.disableBodyRotation(true);
            entity.m_5618_(entity.m_6080_());
            entity.f_20884_ = entity.f_20886_;
            return;
        }
        HumanoidArm arm = part == BodyPart.LEFT_ARM ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        AnimationUtil.applyArmTransforms(model, arm, -Mth.m_14179_((float)(-1.0f * (entity.m_146909_() - 90.0f) / 180.0f), (float)1.0f, (float)2.0f) + Mth.m_14031_((float)((float)(System.currentTimeMillis() % 20000L) / 30.0f)) * 0.1f, -0.3f, 0.3f);
    }
}

