/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.animations.BodyPart;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LookAtItemAnimation
extends BasicAnimation {
    private Set<Item> holdingItems = new HashSet<Item>();
    private final BodyPart[] bothHands = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM};
    private final BodyPart[] left = new BodyPart[]{BodyPart.LEFT_ARM};
    private final BodyPart[] right = new BodyPart[]{BodyPart.RIGHT_ARM};
    private BodyPart[] target = this.bothHands;

    @Override
    public boolean isEnabled() {
        this.bind();
        return NEAnimationsLoader.config.holdUpAllItems || !this.holdingItems.isEmpty();
    }

    private void bind() {
        this.holdingItems.clear();
        Item invalid = (Item)Registry.f_122827_.m_7745_(new ResourceLocation("minecraft", "air"));
        for (String itemId : NEAnimationsLoader.config.holdingItems) {
            try {
                Item item = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(itemId.split(":")[0], itemId.split(":")[1]));
                if (invalid == item) continue;
                this.holdingItems.add(item);
            }
            catch (Exception ex) {
                NEAnimationsLoader.LOGGER.info("Unknown item to add to the holding list: " + itemId);
            }
        }
    }

    @Override
    public boolean isValid(AbstractClientPlayer entity, PlayerData data) {
        boolean leftArm;
        ItemStack itemInRightHand = entity.m_21120_(entity.m_5737_() == HumanoidArm.LEFT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        ItemStack itemInLeftHand = entity.m_21120_(entity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        boolean rightArm = this.holdingItems.contains(itemInRightHand.m_41720_()) || NEAnimationsLoader.config.holdUpAllItems && !itemInRightHand.m_41619_() && (!entity.f_20911_ || entity.m_5737_() != HumanoidArm.RIGHT);
        boolean bl = leftArm = this.holdingItems.contains(itemInLeftHand.m_41720_()) || NEAnimationsLoader.config.holdUpAllItems && !itemInLeftHand.m_41619_() && (!entity.f_20911_ || entity.m_5737_() != HumanoidArm.LEFT);
        if (rightArm && leftArm) {
            this.target = this.bothHands;
            return true;
        }
        if (rightArm) {
            this.target = this.right;
            return true;
        }
        if (leftArm) {
            this.target = this.left;
            return true;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayer entity, PlayerData data) {
        return this.target;
    }

    @Override
    public int getPriority(AbstractClientPlayer entity, PlayerData data) {
        return 300;
    }

    @Override
    public void apply(AbstractClientPlayer entity, PlayerData data, PlayerModel<AbstractClientPlayer> model, BodyPart part, float delta, float tickCounter) {
        HumanoidArm arm = part == BodyPart.LEFT_ARM ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        AnimationUtil.applyArmTransforms(model, arm, -Mth.m_14179_((float)(-1.0f * (entity.m_146909_() - 90.0f) / 180.0f), (float)1.0f, (float)1.5f), -0.2f, 0.3f);
    }
}

