/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.logic;

import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.notenoughanimations.RotationLock;
import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class PlayerTransformer {
    private boolean doneLatebind = false;
    private final Minecraft mc = Minecraft.m_91087_();
    private int frameId = 0;
    private boolean renderingFirstPersonArm = false;

    public void updateModel(AbstractClientPlayer entity, PlayerModel<AbstractClientPlayer> model, float idk, float swing, CallbackInfo info) {
        if (!this.doneLatebind) {
            this.lateBind();
        }
        if (this.mc.f_91073_ == null || this.renderingFirstPersonArm) {
            return;
        }
        float deltaTick = Minecraft.m_91087_().m_91297_();
        NEAnimationsLoader.INSTANCE.animationProvider.applyAnimations(entity, model, deltaTick, swing);
        if (NEAnimationsLoader.config.enableAnimationSmoothing && entity instanceof PlayerData) {
            PlayerData data = (PlayerData)entity;
            float[] last = data.getLastRotations();
            boolean differentFrame = !data.isUpdated(this.frameId);
            long passedNs = System.nanoTime() - data.lastUpdate();
            float timePassed = (float)passedNs / 1000000.0f;
            float speed = NEAnimationsLoader.config.animationSmoothingSpeed;
            this.interpolate(model.f_102812_, last, 0, timePassed, differentFrame, speed);
            this.interpolate(model.f_102811_, last, 3, timePassed, differentFrame, speed);
            if (!NEAnimationsLoader.config.disableLegSmoothing) {
                this.interpolate(model.f_102814_, last, 6, timePassed, differentFrame, speed);
                this.interpolate(model.f_102813_, last, 9, timePassed, differentFrame, speed);
            }
            if (entity == this.mc.f_91075_) {
                if (NEAnimationsLoader.config.rotationLock == RotationLock.SMOOTH && entity.m_20202_() == null) {
                    this.interpolateYawBodyHead(entity, last, 12, timePassed, differentFrame, 6.0f);
                }
                if (NEAnimationsLoader.config.rotationLock == RotationLock.FIXED && entity.m_20202_() == null && differentFrame) {
                    entity.f_20883_ = entity.f_20885_;
                    entity.f_20884_ = entity.f_20886_;
                }
            }
            data.setUpdated(this.frameId);
        }
    }

    public void preUpdate(AbstractClientPlayer livingEntity, PlayerModel<AbstractClientPlayer> playerModel, float tick, float swing, CallbackInfo info) {
        if (this.mc.f_91073_ == null || this.renderingFirstPersonArm) {
            return;
        }
        NEAnimationsLoader.INSTANCE.animationProvider.preUpdate(livingEntity, playerModel);
    }

    private void lateBind() {
        NEAnimationsLoader.INSTANCE.animationProvider.refreshEnabledAnimations();
        this.doneLatebind = true;
    }

    public void nextFrame() {
        ++this.frameId;
    }

    public void renderingFirstPersonArm(boolean flag) {
        this.renderingFirstPersonArm = flag;
    }

    private void interpolate(ModelPart model, float[] last, int offset, float timePassed, boolean differentFrame, float speed) {
        if (!differentFrame) {
            model.f_104203_ = last[offset];
            model.f_104204_ = last[offset + 1];
            model.f_104205_ = last[offset + 2];
            return;
        }
        if (timePassed > 100.0f) {
            last[offset] = model.f_104203_;
            last[offset + 1] = model.f_104204_;
            last[offset + 2] = model.f_104205_;
            this.cleanInvalidData(last, offset);
            return;
        }
        float amount = 1.0f / (1000.0f / timePassed) * speed;
        amount = Math.min(amount, 1.0f);
        amount = Math.max(amount, 0.0f);
        last[offset] = last[offset] + (model.f_104203_ - last[offset]) * amount;
        last[offset + 1] = last[offset + 1] + (AnimationUtil.wrapDegrees(model.f_104204_) - AnimationUtil.wrapDegrees(last[offset + 1])) * amount;
        last[offset + 2] = last[offset + 2] + (model.f_104205_ - last[offset + 2]) * amount;
        this.cleanInvalidData(last, offset);
        model.f_104203_ = last[offset];
        model.f_104204_ = last[offset + 1];
        model.f_104205_ = last[offset + 2];
    }

    private void interpolateYawBodyHead(AbstractClientPlayer entity, float[] last, int offset, float timePassed, boolean differentFrame, float speed) {
        if (!differentFrame) {
            entity.f_20884_ = entity.f_20883_ = last[offset];
            return;
        }
        if (timePassed > 100.0f) {
            last[offset] = entity.f_20885_;
            return;
        }
        if (entity.f_20885_ - last[offset] > 90.0f) {
            speed *= 5.0f;
        }
        if (entity.f_20885_ - last[offset] < -90.0f) {
            speed *= 5.0f;
        }
        float amount = 1.0f / (1000.0f / timePassed) * speed;
        amount = Math.min(amount, 1.0f);
        entity.f_20884_ = last[offset];
        int n = offset;
        last[n] = last[n] + (entity.f_20885_ - last[offset]) * amount;
        entity.f_20883_ = last[offset];
    }

    private void cleanInvalidData(float[] data, int offset) {
        if (Float.isNaN(data[offset])) {
            data[offset] = 0.0f;
        }
        if (Float.isNaN(data[offset + 1])) {
            data[offset + 1] = 0.0f;
        }
        if (Float.isNaN(data[offset + 2])) {
            data[offset + 2] = 0.0f;
        }
    }
}

