/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.client.render;

import com.github.alexthe666.citadel.client.render.LightningBoltData;
import com.github.alexthe666.citadel.client.render.LightningRender;
import com.github.alexthe668.domesticationinnovation.client.ClientProxy;
import com.github.alexthe668.domesticationinnovation.client.model.BlazingBarModel;
import com.github.alexthe668.domesticationinnovation.client.model.ShadowHandModel;
import com.github.alexthe668.domesticationinnovation.client.render.DIRenderTypes;
import com.github.alexthe668.domesticationinnovation.client.render.TextureSizer;
import com.github.alexthe668.domesticationinnovation.server.enchantment.DIEnchantmentRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import com.github.alexthe668.domesticationinnovation.server.item.DIItemRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeRenderTypes;

public class LayerPetOverlays
extends RenderLayer {
    private static final ItemStack MAGNET = new ItemStack((ItemLike)DIItemRegistry.MAGNET.get());
    private static final int CLOUD_COUNT = 14;
    private static final Vec3[] CLOUD_OFFSETS = new Vec3[14];
    private static final Vec3[] CLOUD_SCALES = new Vec3[14];
    private static final ShadowHandModel SHADOW_HAND_MODEL = new ShadowHandModel();
    private static final BlazingBarModel BLAZING_BAR_MODEL = new BlazingBarModel();
    private static final ResourceLocation BLAZE_TEXTURE = new ResourceLocation("textures/entity/blaze.png");
    private static final ResourceLocation AURA_TEXTURE = new ResourceLocation("domesticationinnovation", "textures/healing_aura.png");
    private static final Map<ResourceLocation, Integer> MODELS_TO_XSIZE = new HashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, Integer> MODELS_TO_YSIZE = new HashMap<ResourceLocation, Integer>();
    private final RenderLayerParent parent;
    private final LightningRender lightningRender = new LightningRender();
    private final LightningBoltData.BoltRenderInfo healthBoltData = new LightningBoltData.BoltRenderInfo(0.3f, 0.0f, 0.0f, 0.0f, new Vector4f(0.4f, 0.0f, 0.0f, 0.4f), 0.2f);
    private final LightningBoltData.BoltRenderInfo shadowBoltData = new LightningBoltData.BoltRenderInfo(0.3f, 0.0f, 0.0f, 0.0f, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), 0.2f);

    public LayerPetOverlays(RenderLayerParent parent) {
        super(parent);
        this.parent = parent;
    }

    private static void addVertexPairAlex(VertexConsumer p_174308_, Matrix4f p_174309_, float p_174310_, float p_174311_, float p_174312_, int p_174313_, int p_174314_, int p_174315_, int p_174316_, float p_174317_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_) {
        float f = (float)p_174321_ / 8.0f;
        int i = (int)Mth.m_14179_((float)f, (float)p_174313_, (float)p_174314_);
        int j = (int)Mth.m_14179_((float)f, (float)p_174315_, (float)p_174316_);
        int k = LightTexture.m_109885_((int)i, (int)j);
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = p_174310_ * f;
        float f6 = p_174311_ < 0.0f ? p_174311_ * f * f : p_174311_ - p_174311_ * (1.0f - f) * (1.0f - f);
        float f7 = p_174312_ * f;
        p_174308_.m_85982_(p_174309_, f5 - p_174319_, f6 + p_174318_, f7 + p_174320_).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
        p_174308_.m_85982_(p_174309_, f5 + p_174319_, f6 + p_174317_ - p_174318_, f7 - p_174320_).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
    }

    public static <E extends Entity> void renderShadowString(Entity from, Vec3 fromVec, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, Vec3 to) {
        poseStack.m_85836_();
        double d3 = fromVec.f_82479_;
        double d4 = fromVec.f_82480_;
        double d5 = fromVec.f_82481_;
        poseStack.m_85837_(d3, d4, d5);
        float f = (float)(to.f_82479_ - d3);
        float f1 = (float)(to.f_82480_ - d4);
        float f2 = (float)(to.f_82481_ - d5);
        float f3 = 0.025f;
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        BlockPos blockpos = new BlockPos(fromVec);
        BlockPos blockpos1 = new BlockPos(to);
        int i = 0;
        int j = from.f_19853_.m_45517_(LightLayer.BLOCK, blockpos1);
        int k = from.f_19853_.m_45517_(LightLayer.SKY, blockpos);
        int l = from.f_19853_.m_45517_(LightLayer.SKY, blockpos1);
        for (int i1 = 0; i1 <= 8; ++i1) {
            float width = 0.05f - (float)i1 / 8.0f * 0.025f;
            LayerPetOverlays.addVertexPairAlex(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.2f, width, width, width, i1, false);
        }
        poseStack.m_85849_();
    }

    private static void vertex(VertexConsumer p_114090_, Matrix4f p_114091_, Matrix3f p_114092_, int p_114093_, float p_114094_, int p_114095_, int p_114096_, int p_114097_, float alpha) {
        p_114090_.m_85982_(p_114091_, p_114094_ - 0.5f, (float)p_114095_ - 0.5f, 0.0f).m_85950_(255.0f, 255.0f, 255.0f, alpha * 255.0f).m_7421_((float)p_114096_, (float)p_114097_).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114093_).m_85977_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public void m_6494_(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Entity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (TameableUtils.couldBeTamed(entity)) {
            int t;
            int shadowHandCount;
            Entity owner;
            Entity suck;
            LivingEntity living = (LivingEntity)entity;
            float f = Mth.m_14189_((float)partialTicks, (float)living.f_20884_, (float)living.f_20883_);
            float realAge = (float)living.f_19797_ + partialTicks;
            if (TameableUtils.hasEnchant(living, DIEnchantmentRegistry.IMMUNITY_FRAME) && TameableUtils.getImmuneTime((LivingEntity)entity) > 0) {
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(DIRenderTypes.IFRAME_GLINT);
                float alpha = 0.5f;
                matrixStackIn.m_85836_();
                this.m_117386_().m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)((LivingEntity)entity), (float)0.0f), 1.0f, 1.0f, 1.0f, alpha);
                matrixStackIn.m_85849_();
            }
            if (TameableUtils.hasEnchant(living, DIEnchantmentRegistry.MAGNETIC) && (suck = TameableUtils.getPetAttackTarget(living)) != null) {
                double d0 = Mth.m_14139_((double)partialTicks, (double)suck.f_19854_, (double)suck.m_20185_()) - Mth.m_14139_((double)partialTicks, (double)living.f_19854_, (double)living.m_20185_());
                double d1 = Mth.m_14139_((double)partialTicks, (double)suck.f_19855_, (double)suck.m_20186_()) - Mth.m_14139_((double)partialTicks, (double)living.f_19855_, (double)living.m_20186_());
                double d2 = Mth.m_14139_((double)partialTicks, (double)suck.f_19856_, (double)suck.m_20189_()) - Mth.m_14139_((double)partialTicks, (double)living.f_19856_, (double)living.m_20189_());
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                float f2 = (float)(-(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                matrixStackIn.m_85836_();
                matrixStackIn.m_85845_(Vector3f.f_122224_.m_122240_(f));
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f1));
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(f2));
                matrixStackIn.m_85836_();
                float bob1 = (float)Math.sin(realAge * 0.5f) * 0.05f;
                float bob2 = (float)Math.sin(realAge * 0.3f) * 0.09f - 0.03f;
                float bob3 = (float)Math.cos(realAge * 0.1f) * 0.05f;
                matrixStackIn.m_85837_((double)bob1, (double)(1.25f - entity.m_20206_() * 0.5f - bob2), (double)(-entity.m_20205_() - 0.125f - bob3));
                matrixStackIn.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
                matrixStackIn.m_85841_(1.6f, 1.6f, 3.0f);
                Minecraft.m_91087_().m_91291_().m_174269_(MAGNET, ItemTransforms.TransformType.GROUND, packedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, entity.m_19879_());
                matrixStackIn.m_85849_();
                matrixStackIn.m_85849_();
            }
            if (TameableUtils.hasEnchant(living, DIEnchantmentRegistry.HEALTH_SIPHON) && (owner = TameableUtils.getOwnerOf((Entity)living)) != null && owner.m_6084_() && owner.m_20270_((Entity)living) < 100.0f) {
                float x = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
                float y = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_());
                float z = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
                if (living.f_20916_ > 0 && living.f_20916_ == living.f_20917_ - 1) {
                    float height = -2.0f + entity.m_20206_() * 0.8f;
                    float ownerHeight = -2.0f + owner.m_20206_() * 0.6f;
                    LightningBoltData bolt = new LightningBoltData(this.healthBoltData, new Vec3((double)x, (double)(y + height), (double)z), owner.m_20182_().m_82520_(0.0, (double)ownerHeight, 0.0), 3).size(0.5f).lifespan(5).spawn(LightningBoltData.SpawnFunction.NO_DELAY);
                    this.lightningRender.update((Object)living, bolt, partialTicks);
                }
                matrixStackIn.m_85836_();
                matrixStackIn.m_85845_(Vector3f.f_122224_.m_122240_(f));
                matrixStackIn.m_85845_(Vector3f.f_122222_.m_122240_(180.0f));
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_((double)(-x), (double)(-y), (double)(-z));
                this.lightningRender.render(partialTicks, matrixStackIn, bufferIn);
                matrixStackIn.m_85849_();
                matrixStackIn.m_85849_();
            }
            if (TameableUtils.hasEnchant(living, DIEnchantmentRegistry.VOID_CLOUD) && !living.m_20072_() && !living.m_20096_() && TameableUtils.getFallDistance(living) >= 3.0f) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_((double)0.4f, (double)(1.25f + entity.m_20206_()), (double)0.2f);
                matrixStackIn.m_85845_(Vector3f.f_122224_.m_122240_(f));
                matrixStackIn.m_85845_(Vector3f.f_122222_.m_122240_(180.0f));
                for (int i = 0; i < 14; ++i) {
                    float xSin = (float)Math.sin(realAge * 0.05f + (float)i * 2.0f) * 0.1f;
                    float ySin = (float)Math.cos(realAge * 0.05f + (float)i * 2.0f) * 0.1f;
                    float zSin = (float)Math.sin(realAge * 0.05f + (float)i * 2.0f - 2.0f) * 0.1f;
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_85837_(LayerPetOverlays.CLOUD_OFFSETS[i].f_82479_ + (double)xSin, LayerPetOverlays.CLOUD_OFFSETS[i].f_82480_ + (double)ySin, LayerPetOverlays.CLOUD_OFFSETS[i].f_82481_ + (double)zSin);
                    matrixStackIn.m_85841_((float)LayerPetOverlays.CLOUD_SCALES[i].f_82479_ + xSin, (float)LayerPetOverlays.CLOUD_SCALES[i].f_82480_ + ySin, (float)LayerPetOverlays.CLOUD_SCALES[i].f_82481_ + xSin);
                    this.renderVoidCloudCube(entity, matrixStackIn, bufferIn.m_6299_(DIRenderTypes.VOID_CLOUD));
                    matrixStackIn.m_85849_();
                }
                matrixStackIn.m_85849_();
            }
            if (TameableUtils.isZombiePet(living)) {
                ResourceLocation mobTexture = this.m_117347_((Entity)living);
                Pair<Integer, Integer> xandyDimensions = TextureSizer.getTextureWidth(mobTexture);
                VertexConsumer zombieBuffer = bufferIn.m_6299_(DIRenderTypes.getZombieOverlay(mobTexture, (Integer)xandyDimensions.getFirst(), (Integer)xandyDimensions.getSecond()));
                float alpha = 0.1f;
                matrixStackIn.m_85836_();
                this.m_117386_().m_7695_(matrixStackIn, zombieBuffer, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)((LivingEntity)entity), (float)0.0f), 0.0f, 0.5f, 0.0f, alpha);
                matrixStackIn.m_85849_();
            }
            if ((shadowHandCount = TameableUtils.getEnchantLevel(living, DIEnchantmentRegistry.SHADOW_HANDS)) > 0) {
                Entity punching = TameableUtils.getPetAttackTarget(living);
                double d0 = 0.0;
                double d1 = 0.0;
                double d2 = 0.0;
                if (punching != null) {
                    d0 = Mth.m_14139_((double)partialTicks, (double)punching.f_19854_, (double)punching.m_20185_()) - Mth.m_14139_((double)partialTicks, (double)living.f_19854_, (double)living.m_20185_());
                    d1 = Mth.m_14139_((double)partialTicks, (double)punching.f_19855_, (double)punching.m_20186_()) - Mth.m_14139_((double)partialTicks, (double)living.f_19855_, (double)living.m_20186_());
                    d2 = Mth.m_14139_((double)partialTicks, (double)punching.f_19856_, (double)punching.m_20189_()) - Mth.m_14139_((double)partialTicks, (double)living.f_19856_, (double)living.m_20189_());
                }
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                float f2 = (float)(-(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                for (int i = 0; i < shadowHandCount; ++i) {
                    float punch = this.getPunchFor(living, i, partialTicks) / 10.0f;
                    VertexConsumer vertexconsumer = bufferIn.m_6299_(DIRenderTypes.SHADOW_HAND_ENTITY);
                    float xSpread = shadowHandCount <= 1 ? 0.0f : (float)i / (float)(shadowHandCount - 1) - 0.5f;
                    float xOffset = shadowHandCount <= 1 ? 0.0f : Mth.m_14031_((float)((float)((double)xSpread * Math.PI))) * 1.8f;
                    float zOffset = shadowHandCount <= 1 ? 0.25f : Mth.m_14089_((float)((float)((double)xSpread * Math.PI))) * 1.8f;
                    float yOffset = -zOffset * 0.3f;
                    Vec3 fromPos = new Vec3(0.0, (double)(1.25f - entity.m_20206_() * 0.5f), (double)(-entity.m_20205_() * 0.3f));
                    Vec3 handTranslate = new Vec3((double)(xOffset * entity.m_20205_()), (double)(1.0f + yOffset) + Math.sin(realAge * 0.2f + (float)i * 1.5f) * (double)0.15f, (double)(zOffset * entity.m_20205_()));
                    if (punching != null) {
                        Vec3 vec3 = new Vec3(d0, d1, d2).m_82490_((double)punch);
                        handTranslate = handTranslate.m_82549_(vec3).m_82524_((float)Math.PI + f1 * ((float)Math.PI / 180));
                    }
                    matrixStackIn.m_85836_();
                    if (punching != null) {
                        matrixStackIn.m_85845_(Vector3f.f_122224_.m_122240_(f));
                        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f1));
                        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(f2));
                    }
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_85837_(handTranslate.f_82479_, handTranslate.f_82480_, handTranslate.f_82481_);
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_85837_(0.0, (double)-1.15f, (double)-0.15f);
                    SHADOW_HAND_MODEL.animateShadowHand(punch, i, shadowHandCount, realAge);
                    SHADOW_HAND_MODEL.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)((LivingEntity)entity), (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
                    matrixStackIn.m_85849_();
                    matrixStackIn.m_85849_();
                    matrixStackIn.m_85836_();
                    LayerPetOverlays.renderShadowString(entity, fromPos, partialTicks, matrixStackIn, bufferIn, handTranslate);
                    matrixStackIn.m_85849_();
                    matrixStackIn.m_85849_();
                }
            }
            if (TameableUtils.hasEnchant(living, DIEnchantmentRegistry.BLAZING_PROTECTION)) {
                int bars = TameableUtils.getBlazingProtectionBars(living);
                float f1 = realAge * 7.0f;
                float seperation = 360.0f / ((float)TameableUtils.getEnchantLevel(living, DIEnchantmentRegistry.BLAZING_PROTECTION) * 2.0f);
                VertexConsumer vertexconsumer = bufferIn.m_6299_(ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)BLAZE_TEXTURE));
                matrixStackIn.m_85836_();
                matrixStackIn.m_85845_(Vector3f.f_122224_.m_122240_(f));
                for (int i = 0; i < bars; ++i) {
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f1 += seperation));
                    float bob = (float)Math.sin((double)(realAge * 0.6f) + Math.toRadians(seperation * (float)i)) * 0.15f - 0.07f;
                    matrixStackIn.m_85837_(0.0, (double)(0.4f - entity.m_20206_() * 0.5f - bob), (double)(-entity.m_20205_() - 0.2f));
                    BLAZING_BAR_MODEL.animateBar(f1);
                    BLAZING_BAR_MODEL.m_7695_(matrixStackIn, vertexconsumer, 240, LivingEntityRenderer.m_115338_((LivingEntity)((LivingEntity)entity), (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
                    matrixStackIn.m_85849_();
                }
                matrixStackIn.m_85849_();
            }
            if (TameableUtils.hasEnchant(living, DIEnchantmentRegistry.HEALING_AURA) && (t = TameableUtils.getHealingAuraTime(living)) > 0) {
                float time = t > 20 ? 200.0f - Math.max(180.0f, (float)t - partialTicks) : (float)t - partialTicks;
                float pulse = 0.9f + (float)(Math.sin(ageInTicks * 0.056f) * (double)0.1f + (double)0.1f);
                float healscale = Math.min(time, 20.0f) / 20.0f * 2.2f * pulse;
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(0.0, (double)(1.8f - entity.m_20206_() * 0.5f), 0.0);
                matrixStackIn.m_85845_(Vector3f.f_122224_.m_122240_(f));
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(realAge * 3.0f));
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                matrixStackIn.m_85841_(3.0f * healscale, 3.0f * healscale, 3.0f * healscale);
                VertexConsumer vertexconsumer = bufferIn.m_6299_(DIRenderTypes.HEALING_AURA);
                PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
                Matrix4f matrix4f = posestack$pose.m_85861_();
                Matrix3f matrix3f = posestack$pose.m_85864_();
                LayerPetOverlays.vertex(vertexconsumer, matrix4f, matrix3f, 240, 0.0f, 0, 0, 1, 1.0f);
                LayerPetOverlays.vertex(vertexconsumer, matrix4f, matrix3f, 240, 1.0f, 0, 1, 1, 1.0f);
                LayerPetOverlays.vertex(vertexconsumer, matrix4f, matrix3f, 240, 1.0f, 1, 1, 0, 1.0f);
                LayerPetOverlays.vertex(vertexconsumer, matrix4f, matrix3f, 240, 0.0f, 1, 0, 0, 1.0f);
                matrixStackIn.m_85849_();
            }
        }
    }

    private float getPunchFor(LivingEntity living, int i, float partialTicks) {
        int[] arr = TameableUtils.getShadowPunchTimes(living);
        if (arr.length > i) {
            if (ClientProxy.shadowPunchRenderData.containsKey(living) && ClientProxy.shadowPunchRenderData.get(living).length > i) {
                int[] prevArr = ClientProxy.shadowPunchRenderData.get(living);
                return (float)prevArr[i] + (float)(arr[i] - prevArr[i]) * partialTicks;
            }
            return arr[i];
        }
        return 0.0f;
    }

    private void renderVoidCloudCube(Entity entity, PoseStack poseStack, VertexConsumer consumer) {
        Matrix4f cubeAt = poseStack.m_85850_().m_85861_();
        this.renderVoidCloudFace(entity, cubeAt, consumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, Direction.SOUTH);
        this.renderVoidCloudFace(entity, cubeAt, consumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Direction.NORTH);
        this.renderVoidCloudFace(entity, cubeAt, consumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.EAST);
        this.renderVoidCloudFace(entity, cubeAt, consumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.WEST);
        this.renderVoidCloudFace(entity, cubeAt, consumer, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.DOWN);
        this.renderVoidCloudFace(entity, cubeAt, consumer, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP);
    }

    private void renderVoidCloudFace(Entity entity, Matrix4f p_173696_, VertexConsumer p_173697_, float p_173698_, float p_173699_, float p_173700_, float p_173701_, float p_173702_, float p_173703_, float p_173704_, float p_173705_, Direction p_173706_) {
        p_173697_.m_85982_(p_173696_, p_173698_, p_173700_, p_173702_).m_86008_(240).m_5752_();
        p_173697_.m_85982_(p_173696_, p_173699_, p_173700_, p_173703_).m_86008_(240).m_5752_();
        p_173697_.m_85982_(p_173696_, p_173699_, p_173701_, p_173704_).m_86008_(240).m_5752_();
        p_173697_.m_85982_(p_173696_, p_173698_, p_173701_, p_173705_).m_86008_(240).m_5752_();
    }

    static {
        Random random = new Random(500L);
        for (int i = 0; i < 14; ++i) {
            LayerPetOverlays.CLOUD_OFFSETS[i] = new Vec3((double)(random.nextFloat() - 0.5f), (double)(0.2f * (random.nextFloat() - 0.5f)), (double)(random.nextFloat() - 0.5f)).m_82490_((double)1.2f);
            LayerPetOverlays.CLOUD_SCALES[i] = new Vec3((double)(0.6f + random.nextFloat() * 0.2f), (double)(0.4f + random.nextFloat() * 0.2f), (double)(0.4f + random.nextFloat() * 0.2f));
        }
    }
}

