/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.shieldexp.events;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import org.infernalstudios.shieldexp.ShieldExpansion;
import org.infernalstudios.shieldexp.access.LivingEntityAccess;
import org.infernalstudios.shieldexp.events.FovEvents;
import org.infernalstudios.shieldexp.events.TooltipEvents;
import org.infernalstudios.shieldexp.init.ItemsInit;
import org.infernalstudios.shieldexp.init.ShieldDataLoader;

@Mod.EventBusSubscriber(modid="shieldexp", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    public static void setup() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        MinecraftForge.EVENT_BUS.register((Object)new FovEvents());
        MinecraftForge.EVENT_BUS.register((Object)new TooltipEvents());
        ClientEvents.initShields();
        ClientEvents.copyOptionalResourcePackIfMissing();
    }

    private static void initShields() {
        ItemPropertyFunction blockFn = (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f;
        for (RegistryObject<ShieldItem> shieldItem : ItemsInit.SHIELDS) {
            ItemProperties.register((Item)((Item)shieldItem.get()), (ResourceLocation)new ResourceLocation("minecraft:blocking"), (ItemPropertyFunction)blockFn);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && Minecraft.m_91087_().f_91066_.f_92096_.m_90857_() && LivingEntityAccess.get(player).getBlocking() && player.m_6117_()) {
            player.m_5810_();
        }
    }

    @SubscribeEvent
    public void onLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ShieldDataLoader.clearAll();
    }

    private static void copyOptionalResourcePackIfMissing() {
        File dir = new File(".", "resourcepacks");
        File target = new File(dir, "SE Vanilla Consistency 1.19.2.zip");
        if (!target.exists()) {
            try {
                int len;
                dir.mkdirs();
                InputStream in = ShieldExpansion.class.getResourceAsStream("/assets/shieldexp/SE_Vanilla_Consistency_1.19.2.zip");
                FileOutputStream out = new FileOutputStream(target);
                byte[] buf = new byte[16384];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

