/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.shieldexp.events;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.shieldexp.access.LivingEntityAccess;
import org.infernalstudios.shieldexp.init.Config;
import org.infernalstudios.shieldexp.init.ShieldDataLoader;
import org.infernalstudios.shieldexp.init.SoundsInit;

@Mod.EventBusSubscriber(modid="shieldexp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ShieldExpansionEvents {
    @SubscribeEvent
    public void onStartUsing(LivingEntityUseItemEvent.Start event) {
        Player player;
        Item item = event.getItem().m_41720_();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_36335_().m_41519_(item)) {
            event.setCanceled(true);
            return;
        }
        if (Config.isShield(item).booleanValue() && (livingEntity = event.getEntity()) instanceof Player) {
            player = (Player)livingEntity;
            if (player.f_20921_ == 0.0f) {
                int parryTicks = ShieldExpansionEvents.getShieldValue(item, "parryTicks").intValue();
                if (Config.lenientParryEnabled().booleanValue()) {
                    parryTicks *= 2;
                }
                LivingEntityAccess.get(player).setParryWindow(parryTicks);
                LivingEntityAccess.get(player).setBlockedCooldown(10);
                LivingEntityAccess.get(player).setUsedStamina(0);
                AttributeModifier speedModifier = new AttributeModifier(player.m_20148_(), "Blocking Speed", 4.0 * ShieldExpansionEvents.getShieldValue(item, "speedFactor"), AttributeModifier.Operation.MULTIPLY_TOTAL);
                if (!player.m_21051_(Attributes.f_22279_).m_22109_(speedModifier) && !Config.speedModifierDisabled().booleanValue()) {
                    player.m_21051_(Attributes.f_22279_).m_22118_(speedModifier);
                }
                if (!LivingEntityAccess.get(player).getBlocking()) {
                    LivingEntityAccess.get(player).setBlocking(true);
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onStartUsingClient(LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ModList.get().isLoaded("bettercombat") && Minecraft.m_91087_().f_91066_.f_92096_.m_90857_()) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onStopUsing(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity;
        Item item = event.getItem().m_41720_();
        if ((event instanceof LivingEntityUseItemEvent.Stop || event instanceof LivingEntityUseItemEvent.Finish) && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (Config.isShield(item).booleanValue()) {
                this.removeBlocking(player);
                if (LivingEntityAccess.get(player).getBlockedCooldown() <= 0 && !Config.stashingCooldownDisabled().booleanValue() && !Config.cooldownDisabled().booleanValue()) {
                    player.m_36335_().m_41524_(item, ShieldExpansionEvents.getShieldValue(item, "cooldownTicks").intValue());
                }
            }
        }
    }

    @SubscribeEvent
    public void onUseTick(LivingEntityUseItemEvent.Tick event) {
        Item item = event.getItem().m_41720_();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (Config.isShield(item).booleanValue() && LivingEntityAccess.get(player).getBlocking() && player.f_20921_ > 0.0f) {
                this.removeBlocking(player);
                if (LivingEntityAccess.get(player).getBlockedCooldown() <= 0 && !Config.stashingCooldownDisabled().booleanValue() && !Config.cooldownDisabled().booleanValue()) {
                    player.m_36335_().m_41524_(item, ShieldExpansionEvents.getShieldValue(item, "cooldownTicks").intValue());
                }
                player.m_5810_();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Item item = player.m_21211_().m_41720_();
        Item lastShield = LivingEntityAccess.get(player).getLastShield().m_41720_();
        if (!Config.isShield(item).booleanValue()) {
            this.removeBlocking(player);
        }
        if (!Config.isShield(player.m_21205_().m_41720_()).booleanValue() && !Config.isShield(player.m_21206_().m_41720_()).booleanValue() && LivingEntityAccess.get(player).getBlocking()) {
            this.removeBlocking(player);
            player.m_5810_();
        }
        if (lastShield != item && Config.isShield(lastShield).booleanValue() && !Config.stashingCooldownDisabled().booleanValue() && !Config.cooldownDisabled().booleanValue() && player.m_6117_() && !player.m_36335_().m_41519_(lastShield) && LivingEntityAccess.get(player).getBlockedCooldown() <= 0) {
            player.m_36335_().m_41524_(lastShield, ShieldExpansionEvents.getShieldValue(lastShield, "cooldownTicks").intValue());
        }
        if (Config.isShield(item).booleanValue()) {
            LivingEntityAccess.get(player).setLastShield(item.m_7968_());
        } else {
            LivingEntityAccess.get(player).setLastShield(new ItemStack((ItemLike)Items.f_41852_));
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingAttackEvent event) {
        Player player;
        DamageSource source = event.getSource();
        Entity directEntity = source.m_7640_();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && this.validateBlocking(player = (Player)livingEntity) && (source.m_19385_().equals("player") || source.m_19385_().equals("mob"))) {
            Item item = player.m_21211_().m_41720_();
            player.f_19853_.m_5594_(null, player.m_20097_(), SoundEvents.f_12346_, SoundSource.HOSTILE, 1.0f, 1.0f);
            if (!player.f_19853_.f_46443_) {
                CriteriaTriggers.f_10574_.m_35174_((ServerPlayer)player, source, event.getAmount(), 0.0f, true);
            }
            if (LivingEntityAccess.get(player).getParryWindow() > 0) {
                player.f_19853_.m_5594_(null, player.m_20097_(), (SoundEvent)SoundsInit.PARRY_SOUND.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                if (directEntity instanceof LivingEntity) {
                    LivingEntity livingEntity2 = (LivingEntity)directEntity;
                    if (Config.isShield(item).booleanValue() && ShieldExpansionEvents.getShieldValue(item, "parryDamage") != 0.0) {
                        livingEntity2.m_6469_(DamageSource.m_19364_((LivingEntity)player), event.getAmount() * ShieldExpansionEvents.getShieldValue(item, "parryDamage").floatValue() + ShieldExpansionEvents.getShieldValue(item, "flatDamage").floatValue());
                    }
                    livingEntity2.m_147240_((double)0.55f, directEntity.m_20184_().f_82479_, directEntity.m_20184_().f_82481_);
                    livingEntity2.m_147240_(0.5, player.m_20185_() - livingEntity2.m_20185_(), player.m_20189_() - livingEntity2.m_20189_());
                }
                this.damageItem(player, 1);
            } else {
                this.damageItem(player, (int)event.getAmount());
                if (event.getAmount() > 5.0f) {
                    this.stamina(player, item, 3);
                } else if (event.getAmount() > 0.0f) {
                    this.stamina(player, item, 2);
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Player player;
        EntityHitResult entityRayTraceResult;
        Entity entity;
        Entity projectile = event.getEntity();
        HitResult rayTraceResult = event.getRayTraceResult();
        if (rayTraceResult instanceof EntityHitResult && (entity = (entityRayTraceResult = (EntityHitResult)rayTraceResult).m_82443_()) instanceof Player && this.validateBlocking(player = (Player)entity)) {
            Item item = player.m_21211_().m_41720_();
            player.f_19853_.m_5594_(null, player.m_20097_(), SoundEvents.f_12346_, SoundSource.HOSTILE, 1.0f, 1.0f);
            if (!player.f_19853_.f_46443_) {
                CriteriaTriggers.f_10574_.m_35174_((ServerPlayer)player, new IndirectEntityDamageSource("arrow", projectile, null).m_19366_(), 0.0f, 0.0f, true);
            }
            if (LivingEntityAccess.get(player).getParryWindow() > 0) {
                player.f_19853_.m_5594_(null, player.m_20097_(), (SoundEvent)SoundsInit.PARRY_SOUND.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                projectile.m_20256_(projectile.m_20184_().m_82490_(-1.0));
                projectile.m_217006_(projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_());
                this.damageItem(player, 1);
            } else {
                this.damageItem(player, 1);
                this.stamina(player, item, 1);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onExplosionImpact(LivingAttackEvent event) {
        Player player;
        DamageSource source = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && this.validateBlocking(player = (Player)livingEntity) && source.m_19385_().contains("explosion")) {
            Item item = player.m_21211_().m_41720_();
            double damageFactor = 1.0 - ShieldExpansionEvents.getShieldValue(item, "blastResistance");
            double usedDurability = (double)event.getAmount() * damageFactor;
            player.f_19853_.m_5594_(null, player.m_20097_(), SoundEvents.f_12346_, SoundSource.HOSTILE, 1.0f, 1.0f);
            float damageTaken = 0.0f;
            if (LivingEntityAccess.get(player).getParryWindow() > 0) {
                player.f_19853_.m_5594_(null, player.m_20097_(), (SoundEvent)SoundsInit.PARRY_SOUND.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                this.damageItem(player, (int)usedDurability);
                if (!Config.cooldownDisabled().booleanValue()) {
                    if (event.getAmount() >= 15.0f) {
                        if (damageFactor > 0.0) {
                            player.m_36335_().m_41524_(item, (int)((double)ShieldExpansionEvents.getShieldValue(item, "cooldownTicks").intValue() * damageFactor));
                            this.removeBlocking(player);
                            player.m_5810_();
                        }
                    } else if (event.getAmount() >= 10.0f) {
                        player.m_36335_().m_41524_(item, (int)((double)(ShieldExpansionEvents.getShieldValue(item, "cooldownTicks").intValue() / 2) * damageFactor));
                        this.removeBlocking(player);
                        player.m_5810_();
                    } else if (event.getAmount() > 5.0f) {
                        this.stamina(player, item, (int)(3.0 * damageFactor));
                    } else if (event.getAmount() > 0.0f) {
                        this.stamina(player, item, (int)(2.0 * damageFactor));
                    }
                }
                event.setCanceled(true);
            } else {
                this.damageItem(player, (int)usedDurability);
                if (!Config.cooldownDisabled().booleanValue()) {
                    if (event.getAmount() >= 15.0f) {
                        player.m_36335_().m_41524_(item, (int)((double)ShieldExpansionEvents.getShieldValue(item, "cooldownTicks").intValue() + (double)(ShieldExpansionEvents.getShieldValue(item, "cooldownTicks").intValue() * 2) * damageFactor));
                        this.removeBlocking(player);
                        player.m_5810_();
                    } else if (event.getAmount() >= 10.0f) {
                        player.m_36335_().m_41524_(item, (int)((double)ShieldExpansionEvents.getShieldValue(item, "cooldownTicks").intValue() + (double)ShieldExpansionEvents.getShieldValue(item, "cooldownTicks").intValue() * damageFactor));
                        this.removeBlocking(player);
                        player.m_5810_();
                    } else if (event.getAmount() > 5.0f) {
                        player.m_36335_().m_41524_(item, ShieldExpansionEvents.getShieldValue(item, "cooldownTicks").intValue());
                        this.removeBlocking(player);
                        player.m_5810_();
                    } else if (event.getAmount() > 0.0f) {
                        this.stamina(player, item, 3);
                    }
                }
                event.setCanceled(true);
                if (Config.advancedExplosionsEnabled().booleanValue()) {
                    damageTaken = (float)((double)(event.getAmount() / 2.0f) * damageFactor);
                    player.m_6469_(new DamageSource("partialblast"), damageTaken);
                }
            }
            if (!player.f_19853_.f_46443_) {
                CriteriaTriggers.f_10574_.m_35174_((ServerPlayer)player, event.getSource(), event.getAmount(), damageTaken, true);
            }
        }
    }

    public void removeBlocking(Player player) {
        player.m_21051_(Attributes.f_22279_).m_22120_(player.m_20148_());
        if (LivingEntityAccess.get(player).getBlocking()) {
            LivingEntityAccess.get(player).setBlocking(false);
        }
        LivingEntityAccess.get(player).setParryWindow(0);
    }

    public boolean validateBlocking(Player player) {
        return Config.isShield(player.m_21211_().m_41720_()) != false && LivingEntityAccess.get(player).getBlocking() && player.f_20921_ == 0.0f && !player.m_36335_().m_41519_(player.m_21211_().m_41720_());
    }

    public static Double getShieldValue(Item item, String value) {
        String key = ForgeRegistries.ITEMS.getKey((Object)item).toString();
        return ShieldDataLoader.SHIELD_STATS.containsKey(key) ? ShieldDataLoader.SHIELD_STATS.get(key).get(value) : ShieldDataLoader.SHIELD_STATS.get("shieldexp:default").get(value);
    }

    public void stamina(Player player, Item item, int stamina) {
        if (!Config.cooldownDisabled().booleanValue()) {
            LivingEntityAccess.get(player).setUsedStamina(LivingEntityAccess.get(player).getUsedStamina() + stamina);
            int maxStamina = ShieldExpansionEvents.getShieldValue(item, "stamina").intValue();
            if (Config.lenientStaminaEnabled().booleanValue()) {
                maxStamina *= 2;
            }
            if (LivingEntityAccess.get(player).getUsedStamina() >= maxStamina) {
                player.m_36335_().m_41524_(item, ShieldExpansionEvents.getShieldValue(item, "cooldownTicks").intValue());
                this.removeBlocking(player);
                player.m_5810_();
            }
        }
    }

    public void damageItem(Player player, int amount) {
        player.m_21211_().m_41622_(amount, (LivingEntity)player, player1 -> {
            player1.m_21166_(player.m_7655_() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            this.removeBlocking(player);
            player.m_5810_();
        });
    }
}

