/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.capability;

import de.cadentem.additional_enchantments.capability.CapabilityHandler;
import de.cadentem.additional_enchantments.config.ServerConfig;
import de.cadentem.additional_enchantments.enchantments.HomingEnchantment;
import de.cadentem.additional_enchantments.enchantments.HunterEnchantment;
import de.cadentem.additional_enchantments.enchantments.OreSightEnchantment;
import de.cadentem.additional_enchantments.enchantments.PerceptionEnchantment;
import de.cadentem.additional_enchantments.enchantments.VoidingEnchantment;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Explosion;

public class PlayerData {
    public MobEffectCategory effectFilter = MobEffectCategory.HARMFUL;
    public Explosion.BlockInteraction explosionType = Explosion.BlockInteraction.BREAK;
    public HomingEnchantment.TypeFilter homingTypeFilter = HomingEnchantment.TypeFilter.ANY;
    public HomingEnchantment.Priority homingPriority = HomingEnchantment.Priority.CLOSEST;
    public PerceptionEnchantment.DisplayType displayType = PerceptionEnchantment.DisplayType.ALL;
    public Rarity itemFilter = Rarity.COMMON;
    public OreSightEnchantment.OreRarity oreRarity = OreSightEnchantment.OreRarity.ALL;
    public VoidingEnchantment.State voidingState = VoidingEnchantment.State.ENABLED;
    private int hunterStacks;
    public boolean isOnHunterBlock;
    private int delayStacks;

    public void cycleEffectFilter() {
        this.effectFilter = (MobEffectCategory)this.cycle((Enum<?>)this.effectFilter);
    }

    public void cycleExplosionType() {
        this.explosionType = this.explosionType == Explosion.BlockInteraction.BREAK ? Explosion.BlockInteraction.NONE : Explosion.BlockInteraction.BREAK;
    }

    public void cycleHomingFilter() {
        this.homingTypeFilter = (HomingEnchantment.TypeFilter)this.cycle(this.homingTypeFilter);
    }

    public void cycleHomingPriority() {
        this.homingPriority = (HomingEnchantment.Priority)this.cycle(this.homingPriority);
    }

    public void cycleDisplayType() {
        this.displayType = (PerceptionEnchantment.DisplayType)this.cycle(this.displayType);
    }

    public void cycleItemFilter() {
        this.itemFilter = (Rarity)this.cycle((Enum<?>)this.itemFilter);
    }

    public void cycleOreRarity() {
        this.oreRarity = (OreSightEnchantment.OreRarity)this.cycle(this.oreRarity);
    }

    public void cycleVoiding() {
        this.voidingState = (VoidingEnchantment.State)this.cycle(this.voidingState);
    }

    private Enum<?> cycle(Enum<?> type) {
        Class<?> declaringClass;
        ?[] values;
        int ordinal = type.ordinal();
        ordinal = ordinal == (values = (declaringClass = type.getDeclaringClass()).getEnumConstants()).length - 1 ? 0 : ++ordinal;
        return (Enum)values[ordinal];
    }

    public boolean hasHunterStacks() {
        if (this.hunterStacks > 0) {
            return true;
        }
        return this.delayStacks > 0;
    }

    public int getHunterStacks() {
        return this.hunterStacks;
    }

    public void clearHunterStacks(Player player) {
        this.hunterStacks = 0;
        this.setDelayStacks(player);
    }

    public void increaseHunterStacks(Player player, int enchantmentLevel) {
        if (!player.m_9236_().m_5776_()) {
            this.delayStacks = 10;
            CapabilityHandler.syncPlayerData(player);
        }
        this.hunterStacks = Math.min(HunterEnchantment.getMaxStacks(enchantmentLevel), this.hunterStacks + 1);
    }

    public void reduceHunterStacks(Player player, int enchantmentLevel) {
        if (this.hunterStacks > 0 && player.f_19797_ % Math.max(1, enchantmentLevel / (Integer)ServerConfig.HUNTER_STACK_REDUCTION.get()) == 0) {
            this.hunterStacks = Math.max(0, this.hunterStacks - 1);
            this.setDelayStacks(player);
        }
    }

    public boolean hasMaxHunterStacks(int enchantmentLevel) {
        return this.hunterStacks >= HunterEnchantment.getMaxStacks(enchantmentLevel);
    }

    public void reduceDelayStacks() {
        this.delayStacks = Math.max(0, this.delayStacks - 1);
    }

    private void setDelayStacks(Player player) {
        if (this.hunterStacks == 0 && player.m_9236_().m_5776_()) {
            this.delayStacks = 10;
        }
    }

    public CompoundTag serializeNBT(boolean onlyPersistent) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("effectFilter", this.effectFilter.ordinal());
        tag.m_128405_("explosionType", this.explosionType.ordinal());
        tag.m_128405_("homingTypeFilter", this.homingTypeFilter.ordinal());
        tag.m_128405_("homingPriority", this.homingPriority.ordinal());
        tag.m_128405_("itemFilter", this.itemFilter.ordinal());
        tag.m_128405_("oreRarity", this.oreRarity.ordinal());
        tag.m_128405_("voidingState", this.voidingState.ordinal());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.effectFilter = MobEffectCategory.values()[tag.m_128451_("effectFilter")];
        this.explosionType = Explosion.BlockInteraction.values()[tag.m_128451_("explosionType")];
        this.homingTypeFilter = HomingEnchantment.TypeFilter.values()[tag.m_128451_("homingTypeFilter")];
        this.homingPriority = HomingEnchantment.Priority.values()[tag.m_128451_("homingPriority")];
        this.itemFilter = Rarity.values()[tag.m_128451_("itemFilter")];
        this.oreRarity = OreSightEnchantment.OreRarity.values()[tag.m_128451_("oreRarity")];
        this.voidingState = VoidingEnchantment.State.values()[tag.m_128451_("voidingState")];
    }
}

