/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.capability;

import de.cadentem.additional_enchantments.capability.CapabilityHandler;
import de.cadentem.additional_enchantments.capability.ProjectileData;
import de.cadentem.additional_enchantments.client.ClientProxy;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectileDataProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Map<String, LazyOptional<ProjectileData>> SERVER_CACHE = new HashMap<String, LazyOptional<ProjectileData>>();
    public static final Map<String, LazyOptional<ProjectileData>> CLIENT_CACHE = new HashMap<String, LazyOptional<ProjectileData>>();
    private final ProjectileData handler = new ProjectileData();
    private final LazyOptional<ProjectileData> instance = LazyOptional.of(() -> this.handler);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        return capability == CapabilityHandler.PROJECTILE_DATA_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return ((ProjectileData)this.instance.orElseThrow(() -> new IllegalArgumentException("Capability instance was not present"))).serializeNBT();
    }

    public void deserializeNBT(CompoundTag tag) {
        ((ProjectileData)this.instance.orElseThrow(() -> new IllegalArgumentException("Capability instance was not present"))).deserializeNBT(tag);
    }

    public static LazyOptional<ProjectileData> getCapability(Entity entity) {
        if (entity instanceof Projectile) {
            Map<String, LazyOptional<ProjectileData>> sidedCache = entity.m_9236_().m_5776_() ? CLIENT_CACHE : SERVER_CACHE;
            return sidedCache.computeIfAbsent(entity.m_20149_(), key -> {
                LazyOptional capability = entity.getCapability(CapabilityHandler.PROJECTILE_DATA_CAPABILITY);
                capability.addListener(ignored -> sidedCache.remove(key));
                return capability;
            });
        }
        return LazyOptional.empty();
    }

    public static void removeCachedEntry(Entity entity) {
        if (entity.m_9236_().m_5776_()) {
            if (entity == ClientProxy.getLocalPlayer()) {
                CLIENT_CACHE.clear();
            } else {
                CLIENT_CACHE.remove(entity.m_20149_());
            }
        } else {
            SERVER_CACHE.remove(entity.m_20149_());
        }
    }
}

