/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.cadentem.additional_enchantments.capability.PlayerDataProvider;
import de.cadentem.additional_enchantments.enchantments.HunterEnchantment;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class HunterLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public HunterLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, @NotNull AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!player.m_20145_() || player.m_5833_()) {
            return;
        }
        int enchantmentLevel = HunterEnchantment.getClientEnchantmentLevel((Player)player);
        if (enchantmentLevel > 0 && !player.m_21023_(MobEffects.f_19609_)) {
            PlayerDataProvider.getCapability((Entity)player).ifPresent(data -> {
                if (data.hasHunterStacks()) {
                    VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110467_((ResourceLocation)player.m_108560_()));
                    ((PlayerModel)this.m_117386_()).m_7695_(poseStack, buffer, packedLight, PlayerRenderer.m_115338_((LivingEntity)player, (float)0.0f), 1.0f, 1.0f, 1.0f, HunterLayer.getAlpha(data.getHunterStacks(), enchantmentLevel));
                }
            });
        }
    }

    @SubscribeEvent
    public static void updateHunterStacks(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        PlayerDataProvider.getCapability((Entity)event.player).ifPresent(data -> {
            int enchantmentLevel = HunterEnchantment.getClientEnchantmentLevel(event.player);
            data.reduceDelayStacks();
            if (enchantmentLevel > 0) {
                if (HunterEnchantment.isBlockHunterRelevant(event.player.m_146900_()) || HunterEnchantment.isBlockHunterRelevant(event.player.m_20075_())) {
                    data.increaseHunterStacks(event.player, enchantmentLevel);
                } else {
                    data.reduceHunterStacks(event.player, enchantmentLevel);
                }
            } else {
                data.clearHunterStacks(event.player);
            }
        });
    }

    public static float getAlpha(int hunterStacks, int enchantmentLevel) {
        return 1.0f - (float)hunterStacks / (float)HunterEnchantment.getMaxStacks(enchantmentLevel);
    }
}

