/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.client;

import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import de.cadentem.additional_enchantments.capability.PlayerData;
import de.cadentem.additional_enchantments.capability.PlayerDataProvider;
import de.cadentem.additional_enchantments.client.ClientProxy;
import de.cadentem.additional_enchantments.config.ClientConfig;
import de.cadentem.additional_enchantments.data.AEBlockTags;
import de.cadentem.additional_enchantments.enchantments.OreSightEnchantment;
import de.cadentem.additional_enchantments.mixin.client.FrustumAccess;
import de.cadentem.additional_enchantments.mixin.client.LevelRendererAccess;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class OreSightHandler {
    private static Map<Integer, Boolean[]> CHUNK_CACHE;
    private static Map<Long, Integer> BLOCK_CACHE;
    private static int CACHE_EXPIRE;
    private static final Vec3i[] COLORS;

    @SubscribeEvent
    public static void handleOreSightEnchantment(RenderLevelStageEvent event) {
        int enchantmentLevel;
        LocalPlayer localPlayer;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (CHUNK_CACHE == null || BLOCK_CACHE == null || (Integer)ClientConfig.CACHE_EXPIRE.get() != CACHE_EXPIRE) {
            CACHE_EXPIRE = (Integer)ClientConfig.CACHE_EXPIRE.get();
            OreSightHandler.initCaches();
        }
        if ((localPlayer = Minecraft.m_91087_().f_91074_) != null && (enchantmentLevel = OreSightEnchantment.getClientEnchantmentLevel()) > 0) {
            PlayerDataProvider.getCapability((Entity)localPlayer).ifPresent(playerData -> {
                PoseStack poseStack = event.getPoseStack();
                poseStack.m_85836_();
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                RenderSystem.m_69465_();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferBuilder = tesselator.m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
                OreSightHandler.drawLines(localPlayer, enchantmentLevel + 1, playerData, poseStack, bufferBuilder, event.getLevelRenderer());
                tesselator.m_85914_();
                poseStack.m_85849_();
                RenderSystem.m_69482_();
                RenderType.m_110463_().m_110188_();
            });
        }
    }

    private static void initCaches() {
        CHUNK_CACHE = CacheBuilder.newBuilder().expireAfterWrite((long)CACHE_EXPIRE, TimeUnit.SECONDS).concurrencyLevel(1).build().asMap();
        BLOCK_CACHE = CacheBuilder.newBuilder().expireAfterWrite((long)CACHE_EXPIRE, TimeUnit.SECONDS).concurrencyLevel(1).build().asMap();
    }

    private static void drawLines(LocalPlayer localPlayer, int radius, PlayerData playerData, PoseStack poseStack, BufferBuilder bufferBuilder, LevelRenderer levelRenderer) {
        if (playerData.oreRarity == OreSightEnchantment.OreRarity.NONE) {
            return;
        }
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        BlockPos startPosition = localPlayer.m_20183_();
        ChunkPos currentChunkPosition = new ChunkPos(startPosition);
        LevelChunk currentChunk = null;
        int minChunkX = startPosition.m_123341_() - radius;
        int maxChunkX = startPosition.m_123341_() + radius;
        int minChunkY = Math.max(localPlayer.m_9236_().m_141937_(), startPosition.m_123342_() - radius);
        int maxChunkY = Math.min(localPlayer.m_9236_().m_151558_(), startPosition.m_123342_() + radius);
        int minChunkZ = startPosition.m_123343_() - radius;
        int maxChunkZ = startPosition.m_123343_() + radius;
        boolean foundSection = false;
        BlockPos.MutableBlockPos mutablePosition = BlockPos.f_121853_.m_122032_();
        FrustumAccess cullingFrustum = (FrustumAccess)((LevelRendererAccess)levelRenderer).getCullingFrustum();
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                int sectionX = SectionPos.m_123171_((int)x);
                int sectionZ = SectionPos.m_123171_((int)z);
                if (currentChunk == null || currentChunkPosition.f_45578_ != sectionX || currentChunkPosition.f_45579_ != sectionZ) {
                    currentChunkPosition = new ChunkPos(sectionX, sectionZ);
                    currentChunk = localPlayer.m_9236_().m_6325_(sectionX, sectionZ);
                }
                foundSection = false;
                for (int y = maxChunkY; y >= minChunkY; --y) {
                    int sectionIndex = currentChunk.m_151564_(y);
                    LevelChunkSection section = currentChunk.m_183278_(sectionIndex);
                    mutablePosition.m_122178_(x, y, z);
                    if (foundSection || OreSightHandler.containsOres(currentChunk, section, sectionIndex, playerData.oreRarity)) {
                        OreSightEnchantment.OreRarity rarity;
                        float zMax;
                        foundSection = true;
                        float xMin = (float)((double)x - camera.m_7096_());
                        float yMin = (float)((double)y - camera.m_7098_());
                        float zMin = (float)((double)z - camera.m_7094_());
                        float yMax = (float)((double)(1 + y) - camera.m_7098_());
                        float xMax = (float)((double)(1 + x) - camera.m_7096_());
                        if (cullingFrustum.isCubeInFrustum(xMin, yMin, zMin, xMax, yMax, zMax = (float)((double)(1 + z) - camera.m_7094_())) && (rarity = OreSightHandler.getRarity(currentChunk, (BlockPos)mutablePosition)) != OreSightEnchantment.OreRarity.NONE && rarity.ordinal() >= playerData.oreRarity.ordinal()) {
                            boolean[] renderSides = new boolean[Direction.values().length];
                            for (Direction direction : Direction.values()) {
                                BlockPos relative = mutablePosition.m_5484_(direction, 1);
                                renderSides[direction.ordinal()] = OreSightHandler.isWithin(relative, minChunkX, minChunkY, minChunkZ, maxChunkX, maxChunkY, maxChunkZ) ? rarity != OreSightHandler.getRarity(currentChunk, relative) : true;
                            }
                            OreSightHandler.drawLines(bufferBuilder, poseStack.m_85850_().m_85861_(), poseStack.m_85850_().m_85864_(), xMin, yMin, zMin, xMax, yMax, zMax, renderSides, COLORS[rarity.ordinal()]);
                        }
                    }
                    if (foundSection || y == minChunkY) continue;
                    y = Math.max(minChunkY, SectionPos.m_123223_((int)SectionPos.m_123171_((int)y)));
                }
                if (foundSection || z == maxChunkZ) continue;
                z = Math.min(maxChunkZ, SectionPos.m_123223_((int)(SectionPos.m_123171_((int)z) + 1)));
            }
            if (foundSection || x == maxChunkX) continue;
            x = Math.min(maxChunkX, SectionPos.m_123223_((int)(SectionPos.m_123171_((int)x) + 1)));
        }
    }

    private static boolean isWithin(BlockPos position, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        return position.m_123341_() >= xMin && position.m_123341_() <= xMax && position.m_123342_() >= yMin && position.m_123342_() <= yMax && position.m_123343_() >= zMin && position.m_123343_() <= zMax;
    }

    private static boolean containsOres(LevelChunk chunk, LevelChunkSection section, int sectionIndex, OreSightEnchantment.OreRarity configuration) {
        if (configuration == OreSightEnchantment.OreRarity.NONE) {
            return false;
        }
        Integer key = chunk.m_7697_().hashCode();
        Boolean[] containsOres = CHUNK_CACHE.get(key);
        if (containsOres == null || containsOres[sectionIndex] == null) {
            boolean containsOre;
            boolean bl = containsOre = !section.m_188008_() && section.m_63002_(state -> OreSightHandler.isRelevantRarity(state, configuration));
            if (CACHE_EXPIRE > 0) {
                if (containsOres == null) {
                    containsOres = new Boolean[chunk.m_7103_().length];
                }
                containsOres[sectionIndex] = containsOre;
                CHUNK_CACHE.put(key, containsOres);
            } else {
                return containsOre;
            }
        }
        return containsOres[sectionIndex];
    }

    private static OreSightEnchantment.OreRarity getRarity(LevelChunk chunk, BlockPos position) {
        Long key = position.m_121878_();
        Integer ordinal = BLOCK_CACHE.get(key);
        if (ordinal == null) {
            OreSightEnchantment.OreRarity rarity;
            if (OreSightHandler.isWithin(position, chunk.m_7697_().m_45604_(), position.m_123342_(), chunk.m_7697_().m_45605_(), chunk.m_7697_().m_45608_(), position.m_123342_(), chunk.m_7697_().m_45609_())) {
                rarity = OreSightHandler.getRarity(chunk.m_8055_(position));
            } else {
                Player localPlayer = ClientProxy.getLocalPlayer();
                if (localPlayer != null) {
                    rarity = OreSightHandler.getRarity(localPlayer.m_9236_().m_8055_(position));
                } else {
                    return OreSightEnchantment.OreRarity.NONE;
                }
            }
            ordinal = rarity.ordinal();
            if (CACHE_EXPIRE > 0) {
                BLOCK_CACHE.put(key, ordinal);
            }
        }
        return OreSightEnchantment.OreRarity.values()[ordinal];
    }

    private static OreSightEnchantment.OreRarity getRarity(BlockState state) {
        OreSightEnchantment.OreRarity rarity = state.m_60795_() ? OreSightEnchantment.OreRarity.NONE : (state.m_204336_(AEBlockTags.ORE_SIGHT_BLACKLIST) ? OreSightEnchantment.OreRarity.NONE : (state.m_204336_(AEBlockTags.RARE_ORE) ? OreSightEnchantment.OreRarity.RARE : (state.m_204336_(AEBlockTags.UNCOMMON_ORE) ? OreSightEnchantment.OreRarity.UNCOMMON : (state.m_204336_(AEBlockTags.COMMON_ORE) ? OreSightEnchantment.OreRarity.COMMON : (state.m_204336_(Tags.Blocks.ORES) ? OreSightEnchantment.OreRarity.ALL : OreSightEnchantment.OreRarity.NONE)))));
        return rarity;
    }

    private static boolean isRelevantRarity(BlockState state, OreSightEnchantment.OreRarity configuration) {
        OreSightEnchantment.OreRarity rarity = OreSightHandler.getRarity(state);
        if (rarity == OreSightEnchantment.OreRarity.NONE) {
            return false;
        }
        return rarity.ordinal() >= configuration.ordinal();
    }

    private static void drawLines(BufferBuilder bufferBuilder, Matrix4f lastPose, Matrix3f normal, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, boolean[] renderSides, Vec3i color) {
        boolean renderNegativeY = renderSides[Direction.DOWN.ordinal()];
        boolean renderPositiveY = renderSides[Direction.UP.ordinal()];
        boolean renderNegativeZ = renderSides[Direction.NORTH.ordinal()];
        boolean renderPositiveZ = renderSides[Direction.SOUTH.ordinal()];
        boolean renderNegativeX = renderSides[Direction.WEST.ordinal()];
        boolean renderPositiveX = renderSides[Direction.EAST.ordinal()];
        if (renderNegativeY && renderNegativeZ) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, minX, minY, minZ, maxX, minY, minZ, 1, 0, 0, color);
        }
        if (renderNegativeX && renderNegativeZ) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, minX, minY, minZ, minX, maxY, minZ, 0, 1, 0, color);
        }
        if (renderNegativeX && renderNegativeY) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, minX, minY, minZ, minX, minY, maxZ, 0, 0, 1, color);
        }
        if (renderPositiveX && renderNegativeZ) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, maxX, minY, minZ, maxX, maxY, minZ, 0, 1, 0, color);
        }
        if (renderPositiveY && renderNegativeZ) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, maxX, maxY, minZ, minX, maxY, minZ, -1, 0, 0, color);
        }
        if (renderPositiveY && renderNegativeX) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, minX, maxY, minZ, minX, maxY, maxZ, 0, 0, 1, color);
        }
        if (renderPositiveZ && renderNegativeX) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, minX, maxY, maxZ, minX, minY, maxZ, 0, -1, 0, color);
        }
        if (renderPositiveZ && renderNegativeY) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, minX, minY, maxZ, maxX, minY, maxZ, 1, 0, 0, color);
        }
        if (renderPositiveX && renderNegativeY) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, maxX, minY, maxZ, maxX, minY, minZ, 0, 0, -1, color);
        }
        if (renderPositiveY && renderPositiveZ) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, minX, maxY, maxZ, maxX, maxY, maxZ, 1, 0, 0, color);
        }
        if (renderPositiveX && renderPositiveZ) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, maxX, minY, maxZ, maxX, maxY, maxZ, 0, 1, 0, color);
        }
        if (renderPositiveX && renderPositiveY) {
            OreSightHandler.drawLine(bufferBuilder, lastPose, normal, maxX, maxY, minZ, maxX, maxY, maxZ, 0, 0, 1, color);
        }
    }

    private static void drawLine(BufferBuilder bufferBuilder, Matrix4f lastPose, Matrix3f normal, float fromX, float fromY, float fromZ, float toX, float toY, float toZ, int normalX, int normalY, int normalZ, Vec3i color) {
        bufferBuilder.m_85982_(lastPose, fromX, fromY, fromZ).m_6122_(color.m_123341_(), color.m_123342_(), color.m_123343_(), 255).m_85977_(normal, (float)normalX, (float)normalY, (float)normalZ).m_5752_();
        bufferBuilder.m_85982_(lastPose, toX, toY, toZ).m_6122_(color.m_123341_(), color.m_123342_(), color.m_123343_(), 255).m_85977_(normal, (float)normalX, (float)normalY, (float)normalZ).m_5752_();
    }

    static {
        CACHE_EXPIRE = 2;
        COLORS = new Vec3i[]{new Vec3i(255, 255, 255), new Vec3i(165, 42, 42), new Vec3i(255, 215, 0), new Vec3i(64, 224, 208), new Vec3i(0, 0, 0)};
    }
}

