/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.config;

import de.cadentem.additional_enchantments.config.EnchantmentConfiguration;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.BooleanValue PERCEPTION_SHOW_INVISIBLE;
    public static ForgeConfigSpec.DoubleValue TIPPED_DURATION_BASE;
    public static ForgeConfigSpec.DoubleValue TIPPED_DURATION_MULTIPLIER;
    public static ForgeConfigSpec.DoubleValue WITHER_CHANCE_MULTIPLIER;
    public static ForgeConfigSpec.DoubleValue WITHER_DURATION_BASE;
    public static ForgeConfigSpec.DoubleValue WITHER_DURATION_MULTIPLIER;
    public static ForgeConfigSpec.DoubleValue WITHER_DAMAGE_BASE;
    public static ForgeConfigSpec.DoubleValue WITHER_DAMAGE_MULTIPLIER;
    public static ForgeConfigSpec.IntValue WITHER_DAMAGE_TICK_RATE;
    public static ForgeConfigSpec.DoubleValue PLAGUE_CHANCE_MULTIPLIER;
    public static ForgeConfigSpec.DoubleValue PLAGUE_DURATION_BASE;
    public static ForgeConfigSpec.DoubleValue PLAGUE_DURATION_MULTIPLIER;
    public static ForgeConfigSpec.DoubleValue PLAGUE_DAMAGE_BASE;
    public static ForgeConfigSpec.DoubleValue PLAGUE_DAMAGE_MULTIPLIER;
    public static ForgeConfigSpec.IntValue PLAGUE_DAMAGE_TICK_RATE;
    public static ForgeConfigSpec.IntValue HUNTER_STACK_REDUCTION;
    public static ForgeConfigSpec.DoubleValue EXPLOSIVE_TIP_RADIUS_MULTIPLIER;
    public static ForgeConfigSpec.DoubleValue FASTER_ATTACKS_MULTIPLIER;
    public static ForgeConfigSpec.DoubleValue SHATTER_CHANCE_BASE;
    public static ForgeConfigSpec.DoubleValue SHATTER_CHANCE_MULTIPLIER;
    public static ForgeConfigSpec.DoubleValue SHATTER_DAMAGE_MULTIPLIER;
    public static final Map<String, EnchantmentConfiguration> enchantmentConfigurations;
    private static final Map<String, Integer> ENCHANTMENTS;

    public static int getDefaultMaxLevel(String id) {
        return ENCHANTMENTS.get(id);
    }

    static {
        enchantmentConfigurations = new HashMap<String, EnchantmentConfiguration>();
        ENCHANTMENTS = new HashMap<String, Integer>();
        ENCHANTMENTS.put("explosive_tip", 4);
        ENCHANTMENTS.put("faster_attacks", 4);
        ENCHANTMENTS.put("homing", 4);
        ENCHANTMENTS.put("plague", 6);
        ENCHANTMENTS.put("shatter", 4);
        ENCHANTMENTS.put("straight_shot", 4);
        ENCHANTMENTS.put("tipped", 4);
        ENCHANTMENTS.put("wither", 6);
        ENCHANTMENTS.put("perception", 4);
        ENCHANTMENTS.put("confusion", 5);
        ENCHANTMENTS.put("ore_sight", 5);
        ENCHANTMENTS.put("hunter", 6);
        ENCHANTMENTS.put("bracewalk", 4);
        ENCHANTMENTS.put("hydro_shock", 5);
        ENCHANTMENTS.put("voiding", 1);
        for (String enchantment : ENCHANTMENTS.keySet()) {
            BUILDER.push(enchantment);
            EnchantmentConfiguration enchantmentConfiguration = new EnchantmentConfiguration();
            if (ENCHANTMENTS.get(enchantment) > 1) {
                enchantmentConfiguration.maxLevel = BUILDER.comment("Maximum acquirable level of the enchantment").defineInRange("max_level", ENCHANTMENTS.get(enchantment).intValue(), 1, 15);
            }
            enchantmentConfiguration.isEnabled = BUILDER.comment("Enable or disable the enchantment completely").define("is_enabled", true);
            enchantmentConfiguration.isDiscoverable = BUILDER.comment("Determines if this enchantment can appear in loot / the enchantment table etc.").define("is_discoverable", true);
            enchantmentConfiguration.isAllowedOnBooks = BUILDER.comment("Allow the enchantment to be applied to books").define("is_allowed_on_books", true);
            enchantmentConfiguration.isTradeable = BUILDER.comment("Determines if the enchantment appears in trades").define("is_tradeable", true);
            enchantmentConfiguration.isTreasure = BUILDER.comment("Treasure enchantments usually do not appear in the enchantment table").define("is_treasure", false);
            switch (enchantment) {
                case "perception": {
                    PERCEPTION_SHOW_INVISIBLE = BUILDER.comment("Enable / Disable outlines on invisible entities").define("perception_show_invisible", true);
                    break;
                }
                case "tipped": {
                    TIPPED_DURATION_BASE = BUILDER.comment("Base duration (in seconds) for the applied effect").defineInRange("tipped_duration_base", 3.0, 0.0, 60.0);
                    TIPPED_DURATION_MULTIPLIER = BUILDER.comment("How much the enchantment level affect the duration (1 * <multiplier>) (result will be in seconds)").defineInRange("tipped_duration_multiplier", 2.0, 0.0, 10.0);
                    break;
                }
                case "wither": {
                    WITHER_CHANCE_MULTIPLIER = BUILDER.comment("Chance for the effect to apply (level * <chance_multiplier>) (result of 1 means 100%)").defineInRange("wither_chance_multiplier", 0.1, 0.0, 1.0);
                    WITHER_DURATION_BASE = BUILDER.comment("Base duration (in seconds) for the applied effect").defineInRange("wither_duration_base", 3.0, 0.0, 60.0);
                    WITHER_DURATION_MULTIPLIER = BUILDER.comment("How much the enchantment level affects the duration (1 * <multiplier>) (result will be in seconds)").defineInRange("wither_duration_multiplier", 2.0, 0.0, 10.0);
                    WITHER_DAMAGE_BASE = BUILDER.comment("Base damage for the wither effect (the effect level (amplifier) gets added to this damage)").defineInRange("wither_damage_base", 1.0, 0.0, 100.0);
                    WITHER_DAMAGE_MULTIPLIER = BUILDER.comment("Multiplier to the (<base_damage> + amplifier) result").defineInRange("wither_damage_multiplier", 0.75, 0.0, 10.0);
                    WITHER_DAMAGE_TICK_RATE = BUILDER.comment("Determines how often the wither effect ticks (i.e. deals damage) - when (duration % (Math.max(1, 20 - amplifier / <damage_tick_rate>))) is equal to 0 the effect tick will happen").defineInRange("wither_damage_tick_rate", 2, 1, 15);
                    break;
                }
                case "plague": {
                    PLAGUE_CHANCE_MULTIPLIER = BUILDER.comment("Chance for the effect to apply (level * <chance_multiplier>) (result of 1 means 100%)").defineInRange("plague_chance_multiplier", 0.1, 0.0, 1.0);
                    PLAGUE_DURATION_BASE = BUILDER.comment("Base duration (in seconds) for the applied effect").defineInRange("plague_duration_base", 3.0, 0.0, 60.0);
                    PLAGUE_DURATION_MULTIPLIER = BUILDER.comment("How much the enchantment level affects the duration (1 * <multiplier>) (result will be in seconds)").defineInRange("plague_duration_multiplier", 2.0, 0.0, 10.0);
                    PLAGUE_DAMAGE_BASE = BUILDER.comment("Base damage for the plague effect (the effect level (amplifier) gets added to this damage)").defineInRange("plague_damage_base", 1.0, 0.0, 100.0);
                    PLAGUE_DAMAGE_MULTIPLIER = BUILDER.comment("Multiplier to the (<base_damage> + amplifier) result").defineInRange("plague_damage_multiplier", 0.5, 0.0, 10.0);
                    PLAGUE_DAMAGE_TICK_RATE = BUILDER.comment("Determines how often the plague effect ticks (i.e. deals damage) - when (duration % (Math.max(1, 20 - amplifier / <damage_tick_rate>))) is equal to 0 the effect tick will happen").defineInRange("plague_damage_tick_rate", 3, 1, 15);
                    break;
                }
                case "hunter": {
                    HUNTER_STACK_REDUCTION = BUILDER.comment("Determines how much enchantment levels affect the speed of losing stacks - when (tick_count % (level / <reduction>)) is equal to 0 the stacks will reduce by 1").defineInRange("hunter_stack_reduction", 3, 1, 15);
                    break;
                }
                case "explosive_tip": {
                    EXPLOSIVE_TIP_RADIUS_MULTIPLIER = BUILDER.comment("Multiplier to the enchantment level which will determine the explosion radius (level * <multiplier>) (result will at least by 0.1)").defineInRange("explosive_tip_radius_multiplier", 1.0, 0.0, 100.0);
                    break;
                }
                case "faster_attacks": {
                    FASTER_ATTACKS_MULTIPLIER = BUILDER.comment("Multiplier to the enchantment level which will determine the attack speed bonus (level * <multiplier>) (result will apply as multiply_base)").defineInRange("faster_attacks_multiplier", 0.15, 0.0, 10.0);
                    break;
                }
                case "shatter": {
                    SHATTER_CHANCE_BASE = BUILDER.comment("Base chance for the projectile to shatter and deal area of effect damage (1 means 100%)").defineInRange("shatter_chance_base", 0.3, 0.0, 1.0);
                    SHATTER_CHANCE_MULTIPLIER = BUILDER.comment("Multiplier to the enchantment level to determine the bonus to the base chance (level * <chance_multiplier>)").defineInRange("shatter_chance_modifier", 0.1, 0.0, 1.0);
                    SHATTER_DAMAGE_MULTIPLIER = BUILDER.comment("Multiplier to the enchantment level to determine the area of effect damage (level * <damage_multiplier>)").defineInRange("shatter_damage_multiplier", 0.5, 0.0, 10.0);
                }
            }
            enchantmentConfigurations.put(enchantment, enchantmentConfiguration);
            BUILDER.pop();
        }
        SPEC = BUILDER.build();
    }
}

