/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.core.effects;

import de.cadentem.additional_enchantments.config.ServerConfig;
import de.cadentem.additional_enchantments.data.AEEntityTags;
import de.cadentem.additional_enchantments.registry.AEMobEffects;
import de.cadentem.additional_enchantments.registry.AEParticles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PlagueEffect
extends MobEffect {
    public PlagueEffect() {
        super(MobEffectCategory.HARMFUL, 5149489);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        livingEntity.m_6469_(DamageSource.f_19319_, (((Double)ServerConfig.PLAGUE_DAMAGE_BASE.get()).floatValue() + (float)amplifier) * ((Double)ServerConfig.PLAGUE_DAMAGE_MULTIPLIER.get()).floatValue());
        if ((double)(1 + amplifier) * 0.05 > livingEntity.m_217043_().m_188500_()) {
            AABB boundingBox = livingEntity.m_20191_().m_82400_((double)(1 + amplifier));
            Level level = livingEntity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 center = boundingBox.m_82399_();
                double size = boundingBox.m_82309_();
                int particleCount = (int)(16.0 * Math.pow(1 + amplifier, 1.5));
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)AEParticles.PLAGUE.get()), center.m_7096_(), center.m_7098_(), center.m_7094_(), Math.min(1000, particleCount), size / 2.0, size / 2.0, size / 2.0, 0.0);
            }
            List entities = livingEntity.m_9236_().m_6443_(LivingEntity.class, boundingBox, plagueTarget -> {
                TamableAnimal tamable;
                if (plagueTarget instanceof Player || plagueTarget instanceof TamableAnimal && (tamable = (TamableAnimal)plagueTarget).m_21826_() instanceof Player) {
                    return false;
                }
                if (plagueTarget.m_6095_().m_204039_(AEEntityTags.PLAGUE_BLACKLIST)) {
                    return false;
                }
                return !plagueTarget.m_21023_((MobEffect)AEMobEffects.PLAGUE.get());
            });
            entities.forEach(plagueTarget -> {
                if (plagueTarget.m_217043_().m_188499_()) {
                    int spreadAmplifier = amplifier / 2;
                    plagueTarget.m_7292_(new MobEffectInstance((MobEffect)AEMobEffects.PLAGUE.get(), 20 * (int)((Double)ServerConfig.PLAGUE_DURATION_BASE.get() + (double)spreadAmplifier), spreadAmplifier));
                }
            });
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % Math.max(1, 20 - (1 + amplifier) / (Integer)ServerConfig.PLAGUE_DAMAGE_TICK_RATE.get()) == 0;
    }
}

