/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.core.entity;

import de.cadentem.additional_enchantments.config.ServerConfig;
import de.cadentem.additional_enchantments.registry.AEEntityTypes;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class ShardArrow
extends AbstractArrow {
    private static final ParticleOptions PARTICLES = new ItemParticleOption(ParticleTypes.f_123752_, Items.f_151049_.m_7968_());
    public int enchantmentLevel;

    public ShardArrow(EntityType<ShardArrow> type, Level level) {
        super(type, level);
    }

    public ShardArrow(Level level, LivingEntity shooter) {
        super((EntityType)AEEntityTypes.SHARD_ARROW.get(), shooter, level);
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        this.handleHit();
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        this.handleHit();
    }

    @NotNull
    protected ItemStack m_7941_() {
        return Items.f_151049_.m_7968_();
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_144179_;
    }

    public void m_36740_(@NotNull SoundEvent soundEvent) {
        if (soundEvent == SoundEvents.f_11840_) {
            return;
        }
        super.m_36740_(soundEvent);
    }

    private void handleHit() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double chance = (Double)ServerConfig.SHATTER_CHANCE_BASE.get() + (double)this.enchantmentLevel * (Double)ServerConfig.SHATTER_CHANCE_MULTIPLIER.get();
            if (serverLevel.m_213780_().m_188500_() <= chance) {
                float damage = (float)this.enchantmentLevel * ((Double)ServerConfig.SHATTER_DAMAGE_MULTIPLIER.get()).floatValue();
                this.sendParticles();
                serverLevel.m_6443_(LivingEntity.class, this.m_20191_().m_82400_((double)(2 + this.enchantmentLevel)), livingEntity -> {
                    Entity owner = this.m_37282_();
                    if (owner == null) {
                        return true;
                    }
                    if (livingEntity == owner) return false;
                    if (livingEntity.m_7307_(owner)) {
                        return false;
                    }
                    if (!(owner instanceof LivingEntity)) return true;
                    LivingEntity livingOwner = (LivingEntity)owner;
                    if (!(livingEntity instanceof TamableAnimal)) return true;
                    TamableAnimal tamable = (TamableAnimal)livingEntity;
                    if (tamable.m_21830_(livingOwner)) return false;
                    return true;
                }).forEach(livingEntity -> livingEntity.m_6469_(DamageSource.m_19346_((AbstractArrow)this, (Entity)this.m_37282_()).m_19389_(), damage));
                this.m_146870_();
            }
        }
    }

    private void sendParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double xzOffset = this.m_20205_() * (float)this.enchantmentLevel;
            double yOffset = this.m_20206_() * (float)this.enchantmentLevel;
            int particleCount = (int)(8.0 * Math.pow(this.enchantmentLevel, 1.5));
            serverLevel.m_8767_(PARTICLES, this.m_20185_(), this.m_20186_(), this.m_20189_(), Math.min(1000, particleCount), xzOffset, yOffset, xzOffset, 0.0);
        }
    }
}

