/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.enchantments;

import de.cadentem.additional_enchantments.config.ServerConfig;
import de.cadentem.additional_enchantments.enchantments.base.AEEnchantmentCategory;
import de.cadentem.additional_enchantments.enchantments.base.ConfigurableEnchantment;
import de.cadentem.additional_enchantments.registry.AEEnchantments;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FasterAttacksEnchantment
extends ConfigurableEnchantment {
    private static final String ATTRIBUTE_UUID = "578e84b7-327d-4a19-87f1-cb5de98a977d";

    public FasterAttacksEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, AEEnchantmentCategory.MELEE, EquipmentSlot.MAINHAND, "faster_attacks");
    }

    @SubscribeEvent
    public static void handlerPlayerTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.f_19797_ % 10 != 0) {
            return;
        }
        AttributeInstance attribute = livingEntity.m_21051_(Attributes.f_22283_);
        if (attribute != null) {
            int enchantmentLevel = livingEntity.m_21205_().getEnchantmentLevel((Enchantment)AEEnchantments.FASTER_ATTACKS.get());
            AttributeModifier modifier = attribute.m_22111_(UUID.fromString(ATTRIBUTE_UUID));
            if (modifier != null) {
                attribute.m_22130_(modifier);
            }
            if (enchantmentLevel > 0) {
                attribute.m_22118_(new AttributeModifier(UUID.fromString(ATTRIBUTE_UUID), "Faster Attacks enchantment", (double)enchantmentLevel * (Double)ServerConfig.FASTER_ATTACKS_MULTIPLIER.get(), AttributeModifier.Operation.MULTIPLY_BASE));
            }
        }
    }
}

