/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.enchantments;

import com.google.common.cache.CacheBuilder;
import de.cadentem.additional_enchantments.enchantments.base.ConfigurableEnchantment;
import de.cadentem.additional_enchantments.mixin.TridentAccess;
import de.cadentem.additional_enchantments.registry.AEEnchantments;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class HydroShockEnchantment
extends ConfigurableEnchantment {
    public static final Map<String, Boolean> FIRE_IMMUNE_LOOT = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build().asMap();
    private static final String LIGHTNING_BOLT_TAG = "additional_enchantments.";

    public HydroShockEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.TRIDENT, EquipmentSlot.MAINHAND, "hydro_shock");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleDamage(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        if (target.m_9236_().m_5776_()) {
            return;
        }
        Entity attacker = event.getSource().m_7639_();
        boolean wasThrown = false;
        if (attacker instanceof LivingEntity) {
            int enchantmentLevel;
            LivingEntity livingAttacker = (LivingEntity)attacker;
            Entity entity = event.getSource().m_7640_();
            if (entity instanceof TridentAccess) {
                TridentAccess trident = (TridentAccess)entity;
                enchantmentLevel = trident.getTridentItem().getEnchantmentLevel((Enchantment)AEEnchantments.HYDRO_SHOCK.get());
                wasThrown = true;
            } else {
                enchantmentLevel = livingAttacker.m_21205_().getEnchantmentLevel((Enchantment)AEEnchantments.HYDRO_SHOCK.get());
            }
            if (enchantmentLevel > 0) {
                if (target.m_6126_() || target.m_6060_() || target.m_20069_() || target.m_9236_().m_46758_(target.m_20183_())) {
                    float multiplier = 1.0f + (float)enchantmentLevel / 7.0f;
                    event.setAmount(event.getAmount() * multiplier);
                }
                if (wasThrown && (double)enchantmentLevel / 5.0 > livingAttacker.m_217043_().m_188500_()) {
                    LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(attacker.m_9236_());
                    FIRE_IMMUNE_LOOT.put(attacker.m_20149_(), true);
                    if (bolt != null) {
                        bolt.m_20049_("additional_enchantments.safe");
                        bolt.m_20049_(LIGHTNING_BOLT_TAG + attacker.m_20149_());
                        bolt.m_146884_(target.m_20182_());
                        attacker.m_9236_().m_7967_((Entity)bolt);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void makeLootFireImmune(LivingDropsEvent event) {
        LightningBolt bolt;
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof LightningBolt && (bolt = (LightningBolt)attacker).m_19880_().contains("additional_enchantments..safe") || attacker instanceof LivingEntity && FIRE_IMMUNE_LOOT.getOrDefault(attacker.m_20149_(), false).booleanValue()) {
            Set fireImmuneItems = event.getDrops().stream().map(itemEntity -> new ItemEntity(itemEntity.m_9236_(), itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), itemEntity.m_32055_()){

                public boolean m_5825_() {
                    return true;
                }
            }).collect(Collectors.toSet());
            event.getDrops().clear();
            event.getDrops().addAll(fireImmuneItems);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleLightningBolt(EntityStruckByLightningEvent event) {
        LightningBolt bolt = event.getLightning();
        Entity target = event.getEntity();
        if (bolt.m_19880_().contains("additional_enchantments.safe") && (target instanceof ItemEntity || target instanceof ExperienceOrb || bolt.m_19880_().contains(LIGHTNING_BOLT_TAG + target.m_20149_()))) {
            event.setCanceled(true);
        }
    }

    public void m_7677_(@NotNull LivingEntity attacker, @NotNull Entity target, int level) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.m_20095_();
        }
    }
}

