/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.enchantments.base;

import de.cadentem.additional_enchantments.config.EnchantmentConfiguration;
import de.cadentem.additional_enchantments.config.ServerConfig;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurableEnchantment
extends Enchantment {
    protected final String id;

    protected ConfigurableEnchantment(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot[] slots, String id) {
        super(rarity, category, slots);
        this.id = id;
    }

    protected ConfigurableEnchantment(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot slot, String id) {
        this(rarity, category, new EquipmentSlot[]{slot}, id);
    }

    public int m_6183_(int level) {
        return (level - 1) * 10 + 5;
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + 30;
    }

    public int m_6586_() {
        return ServerConfig.SPEC.isLoaded() ? (Integer)ServerConfig.enchantmentConfigurations.get((Object)this.id).maxLevel.get() : ServerConfig.getDefaultMaxLevel(this.id);
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack stack) {
        return (!ServerConfig.SPEC.isLoaded() || (Boolean)ServerConfig.enchantmentConfigurations.get((Object)this.id).isEnabled.get() != false) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean m_6081_(@NotNull ItemStack stack) {
        return (!ServerConfig.SPEC.isLoaded() || (Boolean)ServerConfig.enchantmentConfigurations.get((Object)this.id).isEnabled.get() != false) && super.m_6081_(stack);
    }

    public boolean m_6592_() {
        if (ServerConfig.SPEC.isLoaded()) {
            EnchantmentConfiguration enchantmentConfiguration = ServerConfig.enchantmentConfigurations.get(this.id);
            return (Boolean)enchantmentConfiguration.isEnabled.get() != false && (Boolean)enchantmentConfiguration.isDiscoverable.get() != false;
        }
        return super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        if (ServerConfig.SPEC.isLoaded()) {
            EnchantmentConfiguration enchantmentConfiguration = ServerConfig.enchantmentConfigurations.get(this.id);
            return (Boolean)enchantmentConfiguration.isEnabled.get() != false && (Boolean)enchantmentConfiguration.isAllowedOnBooks.get() != false;
        }
        return super.isAllowedOnBooks();
    }

    public boolean m_6594_() {
        if (ServerConfig.SPEC.isLoaded()) {
            EnchantmentConfiguration enchantmentConfiguration = ServerConfig.enchantmentConfigurations.get(this.id);
            return (Boolean)enchantmentConfiguration.isEnabled.get() != false && (Boolean)enchantmentConfiguration.isTradeable.get() != false;
        }
        return super.m_6594_();
    }

    public boolean m_6591_() {
        return ServerConfig.SPEC.isLoaded() ? ((Boolean)ServerConfig.enchantmentConfigurations.get((Object)this.id).isTreasure.get()).booleanValue() : super.m_6591_();
    }
}

