/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.buzzier_bees.core;

import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.buzzier_bees.client.model.GrizzlyBearModel;
import com.teamabnormals.buzzier_bees.client.render.entity.GrizzlyBearRenderer;
import com.teamabnormals.buzzier_bees.client.render.entity.MoobloomRenderer;
import com.teamabnormals.buzzier_bees.core.BBConfig;
import com.teamabnormals.buzzier_bees.core.data.server.BBAdvancementProvider;
import com.teamabnormals.buzzier_bees.core.data.server.modifiers.BBAdvancementModifierProvider;
import com.teamabnormals.buzzier_bees.core.data.server.modifiers.BBBiomeModifierProvider;
import com.teamabnormals.buzzier_bees.core.data.server.modifiers.BBLootModifierProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBBannerPatternTagsProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBBiomeTagsProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBBlockTagsProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBEntityTypeTagsProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBItemTagsProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBPaintingVariantTagsProvider;
import com.teamabnormals.buzzier_bees.core.other.BBClientCompat;
import com.teamabnormals.buzzier_bees.core.other.BBCompat;
import com.teamabnormals.buzzier_bees.core.other.BBModelLayers;
import com.teamabnormals.buzzier_bees.core.registry.BBBannerPatterns;
import com.teamabnormals.buzzier_bees.core.registry.BBEntityTypes;
import com.teamabnormals.buzzier_bees.core.registry.BBFeatures;
import com.teamabnormals.buzzier_bees.core.registry.BBMobEffects;
import com.teamabnormals.buzzier_bees.core.registry.BBPaintingVariants;
import com.teamabnormals.buzzier_bees.core.registry.BBParticleTypes;
import net.minecraft.client.model.CowModel;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="buzzier_bees")
public class BuzzierBees {
    public static final String MOD_ID = "buzzier_bees";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("buzzier_bees");

    public BuzzierBees() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        BBPaintingVariants.PAINTING_VARIANTS.register(bus);
        BBParticleTypes.PARTICLE_TYPES.register(bus);
        BBMobEffects.POTIONS.register(bus);
        BBMobEffects.MOB_EFFECTS.register(bus);
        BBBannerPatterns.BANNER_PATTERNS.register(bus);
        BBFeatures.BBPlacedFeatures.PLACED_FEATURES.register(bus);
        BBFeatures.BBConfiguredFeatures.CONFIGURED_FEATURES.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BBConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BBCompat.registerCompat();
            BBMobEffects.registerRecipes();
            BBEntityTypes.registerEntitySpawns();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(BBClientCompat::registerClientCompat);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        BBBlockTagsProvider blockTags = new BBBlockTagsProvider(generator, existingFileHelper);
        generator.m_236039_(includeServer, (DataProvider)blockTags);
        generator.m_236039_(includeServer, (DataProvider)new BBItemTagsProvider(generator, blockTags, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new BBEntityTypeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new BBBiomeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new BBBannerPatternTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new BBPaintingVariantTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new BBAdvancementProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new BBLootModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new BBAdvancementModifierProvider(generator));
        generator.m_236039_(includeServer, BBBiomeModifierProvider.create(generator, existingFileHelper));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BBModelLayers.GRIZZLY_BEAR, GrizzlyBearModel::createBodyLayer);
        event.registerLayerDefinition(BBModelLayers.MOOBLOOM, CowModel::m_170516_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)BBEntityTypes.MOOBLOOM.get(), MoobloomRenderer::new);
        event.registerEntityRenderer((EntityType)BBEntityTypes.GRIZZLY_BEAR.get(), GrizzlyBearRenderer::new);
    }
}

