/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.buzzier_bees.core.data.server.modifiers;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.buzzier_bees.core.other.tags.BBBiomeTags;
import com.teamabnormals.buzzier_bees.core.registry.BBEntityTypes;
import com.teamabnormals.buzzier_bees.core.registry.BBFeatures;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BBBiomeModifierProvider {
    public static JsonCodecProvider<BiomeModifier> create(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        RegistryAccess.Writable access = RegistryAccess.m_206197_();
        Registry biomeRegistry = access.m_175515_(Registry.f_122885_);
        Registry placedFeatures = access.m_175515_(Registry.f_194567_);
        HashMap<ResourceLocation, BiomeModifier> modifiers = new HashMap<ResourceLocation, BiomeModifier>();
        BBBiomeModifierProvider.addModifier(modifiers, "remove_animal/cow", (BiomeModifier)new ForgeBiomeModifiers.RemoveSpawnsBiomeModifier(BBBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, BBBiomeTags.HAS_MOOBLOOM), (HolderSet)HolderSet.m_205800_(List.of((Holder)ForgeRegistries.ENTITY_TYPES.getHolder((Object)EntityType.f_20557_).get()))));
        BBBiomeModifierProvider.addModifier(modifiers, "add_animal/moobloom", (BiomeModifier)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(BBBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, BBBiomeTags.HAS_MOOBLOOM), List.of(new MobSpawnSettings.SpawnerData((EntityType)BBEntityTypes.MOOBLOOM.get(), 12, 4, 4))));
        BBBiomeModifierProvider.addModifier(modifiers, "add_feature/buttercup", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(BBBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, BBBiomeTags.HAS_BUTTERCUP), BBBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, BBFeatures.BBPlacedFeatures.FLOWER_BUTTERCUP), GenerationStep.Decoration.VEGETAL_DECORATION));
        BBBiomeModifierProvider.addModifier(modifiers, "add_feature/white_clover", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(BBBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, BBBiomeTags.HAS_WHITE_CLOVER), BBBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, BBFeatures.BBPlacedFeatures.FLOWER_WHITE_CLOVER), GenerationStep.Decoration.VEGETAL_DECORATION));
        BBBiomeModifierProvider.addModifier(modifiers, "add_feature/pink_clover", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(BBBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, BBBiomeTags.HAS_PINK_CLOVER), BBBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, BBFeatures.BBPlacedFeatures.FLOWER_PINK_CLOVER), GenerationStep.Decoration.VEGETAL_DECORATION));
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"buzzier_bees", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)access), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, modifiers);
    }

    private static HolderSet<Biome> tag(Registry<Biome> biomeRegistry, TagKey<Biome> tagKey) {
        return new HolderSet.Named(biomeRegistry, tagKey);
    }

    private static void addModifier(HashMap<ResourceLocation, BiomeModifier> modifiers, String name, BiomeModifier modifier) {
        modifiers.put(new ResourceLocation("buzzier_bees", name), modifier);
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> of(Registry<PlacedFeature> placedFeatures, RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> placedFeatures.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }
}

