/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.InControl;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.rules.ExperienceRule;
import mcjty.incontrol.rules.LootRule;
import mcjty.incontrol.rules.PhaseRule;
import mcjty.incontrol.rules.SpawnRule;
import mcjty.incontrol.rules.SpecialRule;
import mcjty.incontrol.rules.SummonAidRule;
import mcjty.incontrol.tools.varia.JSonTools;
import net.minecraft.world.level.Level;

public class RulesManager {
    private static final List<SpawnRule> rules = new ArrayList<SpawnRule>();
    private static List<SpawnRule> filteredRules = null;
    private static final List<SummonAidRule> summonAidRules = new ArrayList<SummonAidRule>();
    private static List<SummonAidRule> filteredSummonAidRules = null;
    private static final List<LootRule> lootRules = new ArrayList<LootRule>();
    private static List<LootRule> filteredLootRules = null;
    private static final List<ExperienceRule> experienceRules = new ArrayList<ExperienceRule>();
    private static List<ExperienceRule> filteredExperienceRules = null;
    private static final List<SpecialRule> specialRules = new ArrayList<SpecialRule>();
    private static List<SpecialRule> filteredSpecialRules = null;
    public static List<PhaseRule> phaseRules = new ArrayList<PhaseRule>();
    private static String path;

    public static void reloadRules() {
        rules.clear();
        summonAidRules.clear();
        lootRules.clear();
        experienceRules.clear();
        phaseRules.clear();
        specialRules.clear();
        RulesManager.onPhaseChange();
        RulesManager.readAllRules();
    }

    public static void setRulePath(Path path) {
        RulesManager.path = path.toString();
    }

    public static void readRules() {
        RulesManager.readAllRules();
    }

    public static void onPhaseChange() {
        filteredRules = null;
        filteredSummonAidRules = null;
        filteredLootRules = null;
        filteredExperienceRules = null;
        filteredSpecialRules = null;
    }

    public static List<SpawnRule> getFilteredRules(Level world) {
        if (filteredRules == null) {
            Set<String> phases = DataStorage.getData(world).getPhases();
            filteredRules = rules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredRules;
    }

    public static List<SpecialRule> getFilteredSpecialRules(Level world) {
        if (filteredSpecialRules == null) {
            Set<String> phases = DataStorage.getData(world).getPhases();
            filteredSpecialRules = specialRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredSpecialRules;
    }

    public static List<SummonAidRule> getFilteredSummonAidRules(Level world) {
        if (filteredSummonAidRules == null) {
            Set<String> phases = DataStorage.getData(world).getPhases();
            filteredSummonAidRules = summonAidRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredSummonAidRules;
    }

    public static List<LootRule> getFilteredLootRules(Level world) {
        if (filteredLootRules == null) {
            Set<String> phases = DataStorage.getData(world).getPhases();
            filteredLootRules = lootRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredLootRules;
    }

    public static List<ExperienceRule> getFilteredExperienceRuiles(Level world) {
        if (filteredExperienceRules == null) {
            Set<String> phases = DataStorage.getData(world).getPhases();
            filteredExperienceRules = experienceRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredExperienceRules;
    }

    private static boolean exists(String file) {
        File f = new File(file);
        return f.exists() && !f.isDirectory();
    }

    private static void readAllRules() {
        File directory = new File(path + File.separator + "incontrol");
        if (!directory.exists()) {
            directory.mkdir();
        }
        RulesManager.safeCall("spawn.json", () -> RulesManager.readRules(path, "spawn.json", SpawnRule::parse, rules));
        RulesManager.safeCall("summonaid.json", () -> RulesManager.readRules(path, "summonaid.json", SummonAidRule::parse, summonAidRules));
        RulesManager.safeCall("loot.json", () -> RulesManager.readRules(path, "loot.json", LootRule::parse, lootRules));
        RulesManager.safeCall("experience.json", () -> RulesManager.readRules(path, "experience.json", ExperienceRule::parse, experienceRules));
        RulesManager.safeCall("phases.json", () -> RulesManager.readRules(path, "phases.json", PhaseRule::parse, phaseRules));
        RulesManager.safeCall("special.json", () -> RulesManager.readRules(path, "special.json", SpecialRule::parse, specialRules));
    }

    private static void safeCall(String name, Runnable code) {
        try {
            code.run();
        }
        catch (Exception e) {
            ErrorHandler.error("JSON error in '" + name + "': check log for details (" + e.getMessage() + ")");
            InControl.setup.getLogger().log(org.apache.logging.log4j.Level.ERROR, "Error parsing '" + name + "'", (Throwable)e);
        }
    }

    private static <T> void readRules(String path, String filename, BiFunction<JsonElement, Integer, T> parser, List<T> rules) {
        JsonElement element = RulesManager.getRootElement(path, filename);
        if (element == null) {
            return;
        }
        int i = 0;
        for (JsonElement entry : element.getAsJsonArray()) {
            T rule = parser.apply(entry, i);
            if (rule != null) {
                rules.add(rule);
            } else {
                InControl.setup.getLogger().log(org.apache.logging.log4j.Level.ERROR, "Rule " + i + " in " + filename + " is invalid, skipping!");
            }
            ++i;
        }
    }

    private static JsonElement getRootElement(String path, String filename) {
        return JSonTools.getRootElement(path, filename, InControl.setup.getLogger());
    }
}

