/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.teamabnormals.upgrade_aquatic.client.model.PikeModel;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.layers.GlowingPikeRenderLayer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.layers.PikeCarriedItemRenderLayer;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import java.util.Locale;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PikeRenderer
extends MobRenderer<Pike, PikeModel<Pike>> {
    public PikeRenderer(EntityRendererProvider.Context context) {
        super(context, new PikeModel(context.m_174023_(PikeModel.LOCATION)), 0.6f);
        this.m_115326_(new GlowingPikeRenderLayer(this));
        this.m_115326_(new PikeCarriedItemRenderLayer((RenderLayerParent<Pike, PikeModel<Pike>>)this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(Pike pike) {
        return new ResourceLocation("upgrade_aquatic", String.format("textures/entity/pike/%s.png", pike.getPikeType().name().toLowerCase(Locale.ROOT)));
    }

    protected void setupRotations(Pike pike, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)pike, matrixStack, ageInTicks, rotationYaw, partialTicks);
        float f = 4.3f * Mth.m_14031_((float)(0.6f * ageInTicks));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(f));
        if (!pike.m_20069_()) {
            matrixStack.m_85837_((double)0.1f, (double)0.1f, (double)-0.1f);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
        }
    }

    protected void scale(Pike pike, PoseStack matrixStack, float partialTickTime) {
        float scale = pike.getPikeType().pikeSize.renderSize;
        matrixStack.m_85841_(scale, scale, scale);
    }
}

