/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block;

import com.teamabnormals.upgrade_aquatic.common.block.entity.BedrollBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BedrollBlock
extends BedBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private final DyeColor color;

    public BedrollBlock(DyeColor colorIn, BlockBehaviour.Properties builder) {
        super(colorIn, builder);
        this.color = colorIn;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BedrollBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, OCCUPIED, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance * 0.2f);
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        if (entityIn.m_6047_()) {
            super.m_5548_(worldIn, entityIn);
        } else if (entityIn.m_20184_().f_82480_ < 0.0) {
            entityIn.m_20334_(entityIn.m_20184_().f_82479_, -entityIn.m_20184_().f_82480_ * (double)0.66f, entityIn.m_20184_().f_82481_);
            if (!(entityIn instanceof LivingEntity)) {
                entityIn.m_20334_(entityIn.m_20184_().f_82479_, entityIn.m_20184_().f_82480_ * (double)0.3f, entityIn.m_20184_().f_82481_);
            }
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == BedrollBlock.getDirectionToOther((BedPart)stateIn.m_61143_(PART), (Direction)stateIn.m_61143_((Property)f_54117_))) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_(PART) != stateIn.m_61143_(PART) ? (BlockState)stateIn.m_61124_((Property)OCCUPIED, (Comparable)((Boolean)facingState.m_61143_((Property)OCCUPIED))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
            worldIn.m_46747_(pos);
        }
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!worldIn.f_46443_ && player.m_7500_() && (bedpart = (BedPart)state.m_61143_(PART)) == BedPart.FOOT && (blockstate = worldIn.m_8055_(blockpos = pos.m_121945_(BedrollBlock.getDirectionToOther(bedpart, (Direction)state.m_61143_((Property)f_54117_))))).m_60734_() == this && blockstate.m_61143_(PART) == BedPart.HEAD) {
            worldIn.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            worldIn.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    private static Direction getDirectionToOther(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction enumfacing = context.m_8125_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(enumfacing);
        if (context.m_43725_().m_8055_(blockpos).m_60734_() == Blocks.f_49990_) {
            return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)enumfacing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE) : null;
        }
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)enumfacing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE) : null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (!worldIn.f_46443_) {
            BlockPos blockpos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
            worldIn.m_7731_(blockpos, (BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
            worldIn.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)worldIn, pos, 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public DyeColor m_49554_() {
        return this.color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long m_7799_(BlockState state, BlockPos pos) {
        BlockPos blockpos = pos.m_5484_((Direction)state.m_61143_((Property)f_54117_), state.m_61143_(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.m_14130_((int)blockpos.m_123341_(), (int)pos.m_123342_(), (int)blockpos.m_123343_());
    }
}

