/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.mojang.datafixers.util.Pair;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class MagmaCakeBlock
extends Block {
    public static final BooleanProperty SECOND_CAKE = BooleanProperty.m_61465_((String)"second_cake");
    public static final DirectionProperty SECOND_CAKE_FACING = DirectionProperty.m_61546_((String)"second_facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)6);
    protected static final VoxelShape[][] SHAPE_BY_BITE = new VoxelShape[][]{{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)13.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)11.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)9.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)7.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)5.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0)}, {Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)}, {Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0)}, {Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)11.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)9.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)7.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)8.0, (double)15.0)}};
    protected static final VoxelShape[][] SECOND_SHAPE_BY_BITE = new VoxelShape[][]{{Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)11.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)7.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)5.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)3.0), (BooleanOp)BooleanOp.f_82695_)}, {Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)3.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)5.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)7.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)9.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)11.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)13.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_)}, {Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)3.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)5.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)7.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)9.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)13.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_)}, {Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)11.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)9.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)7.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)5.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)3.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_)}};
    public final Supplier<Item> pieSlice;

    public MagmaCakeBlock(BlockBehaviour.Properties properties, Supplier<Item> pieSlice) {
        super(properties);
        this.pieSlice = pieSlice;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0))).m_61124_((Property)SECOND_CAKE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SECOND_CAKE_FACING, (Comparable)Direction.NORTH));
    }

    public ItemStack getPieSliceItem() {
        return new ItemStack((ItemLike)this.pieSlice.get());
    }

    public int getMaxBites() {
        return 7;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean isSecondCake = (Boolean)state.m_61143_((Property)SECOND_CAKE);
        int second_direction = ((Direction)state.m_61143_((Property)SECOND_CAKE_FACING)).m_122416_();
        int direction = ((Direction)state.m_61143_((Property)FACING)).m_122416_();
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (isSecondCake) {
            return SECOND_SHAPE_BY_BITE[second_direction][bites];
        }
        return SHAPE_BY_BITE[direction][bites];
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (heldStack.m_150930_((Item)MNDItems.MAGMA_CAKE.get())) {
                return this.secondCake(level, pos, state, player);
            }
            if (heldStack.m_204117_(ModTags.KNIVES)) {
                return this.cutSlice(level, pos, state, player);
            }
            if (this.consumeBite(level, pos, state, player) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
            if (heldStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        if (heldStack.m_150930_((Item)MNDItems.MAGMA_CAKE.get())) {
            return this.secondCake(level, pos, state, player);
        }
        if (heldStack.m_204117_(ModTags.KNIVES)) {
            return this.cutSlice(level, pos, state, player);
        }
        return this.consumeBite(level, pos, state, player);
    }

    protected InteractionResult secondCake(Level level, BlockPos pos, BlockState state, Player player) {
        Direction direction = player.m_6350_().m_122424_();
        ItemStack heldStack = player.m_21205_();
        if ((Integer)state.m_61143_((Property)BITES) == 0 && !((Boolean)state.m_61143_((Property)SECOND_CAKE)).booleanValue()) {
            if (!player.m_7500_()) {
                heldStack.m_41774_(1);
            }
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)SECOND_CAKE_FACING, (Comparable)direction)).m_61124_((Property)SECOND_CAKE, (Comparable)Boolean.valueOf(true)), 3);
        }
        level.m_5594_(null, pos, SoundEvents.f_12061_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int bites;
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getPieSliceItem();
        FoodProperties sliceFood = sliceStack.m_41720_().m_41473_();
        playerIn.m_36324_().m_38712_(sliceStack.m_41720_(), sliceStack);
        if (this.getPieSliceItem().m_41720_().m_41472_() && sliceFood != null) {
            for (Pair pair : sliceFood.m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                playerIn.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        if ((bites = ((Integer)state.m_61143_((Property)BITES)).intValue()) < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else if (((Boolean)state.m_61143_((Property)SECOND_CAKE)).booleanValue()) {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(0))).m_61124_((Property)SECOND_CAKE, (Comparable)Boolean.valueOf(false)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (bites < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else if (((Boolean)state.m_61143_((Property)SECOND_CAKE)).booleanValue()) {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(0))).m_61124_((Property)SECOND_CAKE, (Comparable)Boolean.valueOf(false)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        Direction direction = player.m_6350_().m_122424_();
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)this.getPieSliceItem(), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        level.m_5594_(null, pos, SoundEvents.f_12112_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(DamageSource.f_19309_, 1.0f);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60767_().m_76333_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BITES, SECOND_CAKE, SECOND_CAKE_FACING});
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        super.m_214162_(state, level, pos, rand);
        VoxelShape shape = this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
        shape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            int i = 0;
            while ((double)i < 0.025) {
                double particleX = minX + (maxX - minX) * rand.m_188500_() + (double)pos.m_123341_();
                double particleY = minY + (maxY - minY) * rand.m_188500_() + (double)pos.m_123342_();
                double particleZ = minZ + (maxZ - minZ) * rand.m_188500_() + (double)pos.m_123343_();
                double offsetX = (rand.m_188500_() - 0.5) * 0.45;
                double offsetY = (rand.m_188500_() - 0.5) * 0.45;
                double offsetZ = (rand.m_188500_() - 0.5) * 0.45;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, particleX + offsetX, particleY + offsetY, particleZ + offsetZ, 0.0, 0.0, 0.0);
                ++i;
            }
        });
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxBites() - (Integer)blockState.m_61143_((Property)BITES);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

