/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.block.PowderyCaneBlock;
import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class PowderyFlowerBlock
extends BambooSaplingBlock {
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    public static final IntegerProperty PRESSURE = IntegerProperty.m_61631_((String)"pressure", (int)0, (int)2);
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)2);

    public PowderyFlowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PRESSURE, (Comparable)Integer.valueOf(0))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT, AGE, PRESSURE});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockBelow = level.m_8055_(pos.m_7495_());
        return blockBelow.m_204336_(MNDTags.POWDERY_CANNON_PLANTABLE_ON) || blockBelow.m_204336_(MNDTags.POWDERY_CANE);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        int age = (Integer)state.m_61143_((Property)AGE);
        boolean isLit = (Boolean)state.m_61143_((Property)LIT);
        if (!state.m_60710_((LevelReader)level, pos) || (Integer)state.m_61143_((Property)PRESSURE) > 0) {
            level.m_186460_(pos, (Block)this, 1);
        }
        if (direction == Direction.UP && offsetState.m_60713_((Block)MNDBlocks.BULLET_PEPPER.get())) {
            level.m_7731_(pos, ((Block)MNDBlocks.POWDERY_CANE.get()).m_49966_(), 2);
        }
        if (isLit && age < 2) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
        return super.m_7417_(state, direction, offsetState, level, pos, offsetPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.f_46443_) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        int pressure = (Integer)state.m_61143_((Property)PRESSURE);
        boolean isLit = (Boolean)state.m_61143_((Property)LIT);
        if (!state.m_60710_((LevelReader)level, pos)) {
            if (isLit) {
                this.explodeAndReset((Level)level, pos, state, age);
            }
            level.m_46961_(pos, true);
        }
        if (pressure > 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSURE, (Comparable)Integer.valueOf(pressure - 1)), 2);
        }
        if (pressure == 2 && isLit) {
            this.explodeAndReset((Level)level, pos, state, age);
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        BlockState blockBelow = world.m_8055_(pos.m_7495_());
        boolean isBlockBelowPowderyCane = blockBelow.m_204336_(MNDTags.POWDERY_CANE);
        boolean isBlockBelowPerfectSoil = blockBelow.m_60713_((Block)MNDBlocks.RESURGENT_SOIL.get()) || blockBelow.m_60713_((Block)MNDBlocks.POWDERY_CANNON.get());
        boolean isBlockBelowPowderySoil = blockBelow.m_60713_(Blocks.f_50699_) || blockBelow.m_60713_(Blocks.f_49994_);
        boolean isBlockBelowLeave = blockBelow.m_61138_((Property)PowderyCaneBlock.LEAVE) && (Boolean)blockBelow.m_61143_((Property)PowderyCaneBlock.LEAVE) == false;
        boolean maxHeight = true;
        for (int i = 1; i <= 4; ++i) {
            if (world.m_8055_(pos.m_6625_(i)).m_60713_((Block)MNDBlocks.POWDERY_CANE.get())) continue;
            maxHeight = false;
            break;
        }
        if (age == 2 && random.m_188503_(2) == 0) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
        } else if (age < 2 && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (random.m_188503_(3) == 0 ? 1 : 0) != 0)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
        if (!maxHeight) {
            if (age != 2 && random.m_188503_(8) == 0 && world.m_46859_(pos.m_7494_()) && isBlockBelowLeave) {
                this.m_48972_((Level)world, pos);
            } else if (age <= 2 && (isBlockBelowPerfectSoil || isBlockBelowPowderyCane || isBlockBelowPowderySoil) && world.m_46859_(pos.m_7494_())) {
                if (isBlockBelowPerfectSoil) {
                    this.m_48972_((Level)world, pos);
                } else if (isBlockBelowPowderyCane && isBlockBelowLeave && random.m_188503_(30) == 0) {
                    this.m_48972_((Level)world, pos);
                } else if (!isBlockBelowLeave && random.m_188503_(300) == 0) {
                    this.m_48972_((Level)world, pos);
                } else if (!isBlockBelowPowderySoil && random.m_188503_(1200) == 0) {
                    this.m_48972_((Level)world, pos);
                }
            }
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.m_6095_() == EntityType.f_20507_ || entity.m_6095_() == EntityType.f_20550_ || entity.m_6047_()) {
            return;
        }
        if (!level.f_46443_ && (Integer)state.m_61143_((Property)PRESSURE) < 2) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PRESSURE) + 1)), 2);
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            int age = state.m_61138_((Property)AGE) ? (Integer)state.m_61143_((Property)AGE) : 0;
            level.m_5594_(null, pos, SoundEvents.f_11988_, SoundSource.BLOCKS, 0.25f, 0.1f);
            this.explodeAndReset(level, pos, state, age);
            this.plantPepper(level, pos);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        ItemStack heldItem;
        if (!level.f_46443_ && (Integer)state.m_61143_((Property)PRESSURE) < 2 && !player.m_6047_()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PRESSURE) + 1)), 2);
        }
        if (!(!((Boolean)state.m_61143_((Property)LIT)).booleanValue() || (heldItem = player.m_21120_(InteractionHand.MAIN_HAND)).m_204117_(ForgeTags.TOOLS_KNIVES) && heldItem.m_204117_(Tags.Items.SHEARS))) {
            int age = state.m_61138_((Property)AGE) ? (Integer)state.m_61143_((Property)AGE) : 0;
            this.explodeAndReset(level, pos, state, age);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        BlockState state = level.m_8055_(pos);
        if (!level.f_46443_ && state.m_61138_((Property)LIT) && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            int age = state.m_61138_((Property)AGE) ? (Integer)state.m_61143_((Property)AGE) : 0;
            this.explodeAndReset(level, pos, state, age);
        }
    }

    private void plantPepper(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            BlockState belowNeighborState = level.m_8055_(neighborPos.m_7495_());
            if (!neighborState.m_60795_() || !belowNeighborState.m_204336_(MNDTags.POWDERY_CANNON_PLANTABLE_ON) || !((double)level.f_46441_.m_188501_() < 0.25)) continue;
            level.m_7731_(neighborPos, ((Block)MNDBlocks.BULLET_PEPPER.get()).m_49966_(), 3);
            break;
        }
    }

    private void explodeAndReset(Level level, BlockPos pos, BlockState state, int age) {
        level.m_5594_(null, pos, SoundEvents.f_11837_, SoundSource.BLOCKS, 0.5f, 0.25f);
        level.m_46518_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1.25f, false, Explosion.BlockInteraction.NONE);
        if (state.m_61138_((Property)AGE) && age > 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age - 1)), 3);
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult context) {
        ItemStack heldItem;
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age == 2 && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && ((heldItem = player.m_21120_(hand)).m_204117_(ForgeTags.TOOLS_KNIVES) || heldItem.m_204117_(Tags.Items.SHEARS))) {
            heldItem.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_46961_(pos, true);
            Random random = new Random();
            PowderyFlowerBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MNDItems.BULLET_PEPPER.get(), random.nextInt(100) < 25 ? 1 : 0));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, context);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)MNDItems.BULLET_PEPPER.get());
    }

    protected void m_48972_(Level level, BlockPos pos) {
        BlockState currentBlockState = level.m_8055_(pos);
        boolean isLit = (Boolean)currentBlockState.m_61143_((Property)LIT);
        BlockState newBlockState = this.m_49966_();
        if (isLit) {
            newBlockState = (BlockState)((BlockState)((Block)MNDBlocks.BULLET_PEPPER.get()).m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(2))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        level.m_7731_(pos.m_7494_(), newBlockState, 3);
    }
}

