/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class ResurgentSoilFarmlandBlock
extends FarmBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public ResurgentSoilFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean hasFireOrLava(LevelReader level, BlockPos pos) {
        BlockState state;
        Iterator var2 = BlockPos.m_121940_((BlockPos)pos.m_7918_(-8, -4, -8), (BlockPos)pos.m_7918_(8, 4, 8)).iterator();
        do {
            if (!var2.hasNext()) {
                return false;
            }
            BlockPos nearbyPos = (BlockPos)var2.next();
            state = level.m_8055_(nearbyPos);
            if (!state.m_60819_().m_205070_(FluidTags.f_13132_)) continue;
            return true;
        } while (!state.m_204336_(MNDTags.LETIOS_FLAMES) || state.m_61138_((Property)BlockStateProperties.f_61443_) && (!state.m_61138_((Property)BlockStateProperties.f_61443_) || !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()));
        return true;
    }

    public static void turnToRichSoil(BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, ResurgentSoilFarmlandBlock.m_49897_((BlockState)state, (BlockState)((Block)MNDBlocks.RESURGENT_SOIL.get()).m_49966_(), (LevelAccessor)level, (BlockPos)pos));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        return super.m_7898_(state, level, pos) || aboveState.m_60734_() instanceof StemGrownBlock;
    }

    public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        if (state.m_60713_((Block)MNDBlocks.RESURGENT_SOIL_FARMLAND.get())) {
            return (Integer)state.m_61143_((Property)f_53243_) > 0;
        }
        return false;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            ResurgentSoilFarmlandBlock.turnToRichSoil(state, (Level)level, pos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int moisture = (Integer)state.m_61143_((Property)f_53243_);
        if (!ResurgentSoilFarmlandBlock.hasFireOrLava((LevelReader)level, pos) && !level.m_46758_(pos.m_7494_())) {
            if (moisture > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(moisture - 1)), 2);
            }
        } else if (moisture < 7) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        } else if (moisture == 7) {
            int age;
            if ((Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() == 0.0) {
                return;
            }
            BlockPos abovePos = pos.m_7494_();
            BlockState aboveState = level.m_8055_(abovePos);
            Block aboveBlock = aboveState.m_60734_();
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = level.m_8055_(belowPos);
            Block belowBlock = belowState.m_60734_();
            if (aboveBlock instanceof NetherWartBlock && (age = ((Integer)aboveState.m_61143_((Property)NetherWartBlock.f_54967_)).intValue()) < 3) {
                aboveState = (BlockState)aboveState.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(age + 1));
                level.m_46597_(abovePos, aboveState);
                return;
            }
            if (!aboveState.m_204336_(MNDTags.NOT_PROPAGATE_PLANT)) {
                if (aboveState.m_204336_(MNDTags.ABOVE_PROPAGATE_PLANT) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / 6.0) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                }
                if (aboveBlock instanceof NetherWartBlock) {
                    age = (Integer)aboveState.m_61143_((Property)NetherWartBlock.f_54967_);
                    if (age < 3) {
                        return;
                    }
                    if (age == 3 && level.f_46441_.m_188503_(8) == 0) {
                        this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    }
                }
                if (aboveBlock instanceof DoublePlantBlock && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get()) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                }
            }
            if (!belowState.m_204336_(MNDTags.NOT_PROPAGATE_PLANT) && belowState.m_204336_(MNDTags.BELOW_PROPAGATE_PLANT) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get()) {
                this.propagateBelowIfPossible(belowBlock, belowPos, level);
            }
            if (aboveState.m_204336_(ModTags.UNAFFECTED_BY_RICH_SOIL) || aboveBlock instanceof TallFlowerBlock) {
                return;
            }
            this.performBonemealIfPossible(aboveBlock, pos.m_7494_(), aboveState, level, 1);
            this.performBonemealIfPossible(belowBlock, pos.m_7495_(), belowState, level, 1);
        }
    }

    private void performBonemealIfPossible(Block block, BlockPos position, BlockState state, ServerLevel level, int distance) {
        if (block instanceof BonemealableBlock) {
            BonemealableBlock growable = (BonemealableBlock)block;
            if ((double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / (double)distance) {
                if (growable.m_7370_((BlockGetter)level, position, state, false) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)position, (BlockState)state, (boolean)true)) {
                    growable.m_214148_(level, level.f_46441_, position, state);
                    level.m_46796_(2005, position, 0);
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)position, (BlockState)state);
                } else {
                    BlockPos checkPos = position.m_7494_();
                    BlockState checkState = level.m_8055_(checkPos);
                    Block checkBlock = checkState.m_60734_();
                    while (checkBlock == block && distance <= 10) {
                        this.performBonemealIfPossible(checkBlock, checkPos, checkState, level, distance + 1);
                        ++distance;
                        checkPos = checkPos.m_7494_();
                        checkState = level.m_8055_(checkPos);
                        checkBlock = checkState.m_60734_();
                    }
                    checkPos = position.m_7495_();
                    checkState = level.m_8055_(checkPos);
                    checkBlock = checkState.m_60734_();
                    while (checkBlock == block && distance <= 10) {
                        this.performBonemealIfPossible(checkBlock, checkPos, checkState, level, distance + 1);
                        ++distance;
                        checkPos = checkPos.m_7495_();
                        checkState = level.m_8055_(checkPos);
                        checkBlock = checkState.m_60734_();
                    }
                }
            }
        }
    }

    private void propagateAboveIfPossible(Block block, BlockPos position, ServerLevel level) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos newPos = position.m_7918_(x, y, z);
                    BlockState newState = level.m_8055_(newPos);
                    if (!this.canAboveBlockSurvive(block, newState, level, newPos)) continue;
                    validPositions.add(newPos);
                }
            }
        }
        if (!validPositions.isEmpty()) {
            boolean canPropagate;
            BlockPos plantPos = (BlockPos)validPositions.get(level.f_46441_.m_188503_(validPositions.size()));
            BlockState targetState = level.m_8055_(plantPos);
            boolean bl = canPropagate = block instanceof LiquidBlockContainer && targetState.m_60734_() == Blocks.f_49990_ || !(block instanceof LiquidBlockContainer) && targetState.m_60734_() == Blocks.f_50016_ || block instanceof SimpleWaterloggedBlock && (targetState.m_60734_() == Blocks.f_50016_ || targetState.m_60734_() == Blocks.f_49990_);
            if (canPropagate) {
                this.placeBlock(block, level, plantPos);
            }
        }
    }

    private boolean canAboveBlockSurvive(Block block, BlockState newState, ServerLevel level, BlockPos newPos) {
        BlockState blockBelowState = level.m_8055_(newPos.m_7495_());
        if (block instanceof DoublePlantBlock && level.m_8055_(newPos.m_7494_()).m_60734_() == Blocks.f_50016_) {
            return ((DoublePlantBlock)block).m_7898_(block.m_49966_(), (LevelReader)level, newPos);
        }
        if (block instanceof NetherWartBlock) {
            return blockBelowState.m_60734_() == Blocks.f_50135_ || blockBelowState.m_60734_() == MNDBlocks.RESURGENT_SOIL.get() || blockBelowState.m_60734_() == MNDBlocks.RESURGENT_SOIL_FARMLAND.get();
        }
        if (!(block instanceof DoublePlantBlock)) {
            return blockBelowState.m_60734_() == ModBlocks.RICH_SOIL_FARMLAND.get() || blockBelowState.m_60734_() == MNDBlocks.RESURGENT_SOIL_FARMLAND.get();
        }
        return false;
    }

    private void propagateBelowIfPossible(Block block, BlockPos position, ServerLevel level) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos newPos = position.m_7918_(x, y, z);
                    if (!this.canBelowBlockSurvive(level, newPos)) continue;
                    validPositions.add(newPos);
                }
            }
        }
        if (!validPositions.isEmpty()) {
            boolean canPropagate;
            BlockPos plantPos = (BlockPos)validPositions.get(level.f_46441_.m_188503_(validPositions.size()));
            BlockState targetState = level.m_8055_(plantPos);
            boolean bl = canPropagate = block instanceof LiquidBlockContainer && targetState.m_60734_() == Blocks.f_49990_ || !(block instanceof LiquidBlockContainer) && targetState.m_60734_() == Blocks.f_50016_ || block instanceof SimpleWaterloggedBlock && (targetState.m_60734_() == Blocks.f_50016_ || targetState.m_60734_() == Blocks.f_49990_);
            if (canPropagate) {
                this.placeBlock(block, level, plantPos);
            }
        }
    }

    private boolean canBelowBlockSurvive(ServerLevel level, BlockPos newPos) {
        BlockState blockAboveState = level.m_8055_(newPos.m_7494_());
        return blockAboveState.m_60734_() == ModBlocks.RICH_SOIL.get() || blockAboveState.m_60734_() == MNDBlocks.RESURGENT_SOIL.get() || blockAboveState.m_60734_() == ModBlocks.RICH_SOIL_FARMLAND.get() || blockAboveState.m_60734_() == MNDBlocks.RESURGENT_SOIL_FARMLAND.get();
    }

    private void placeBlock(Block block, ServerLevel level, BlockPos pos) {
        BlockState state = block.m_49966_();
        if (block instanceof SimpleWaterloggedBlock) {
            FluidState fluidState = level.m_6425_(pos);
            state = fluidState.m_76152_() == Fluids.f_76193_ ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        }
        if (block instanceof DoublePlantBlock) {
            DoublePlantBlock cfr_ignored_0 = (DoublePlantBlock)block;
            DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)state, (BlockPos)pos, (int)3);
        } else {
            level.m_46597_(pos, state);
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        return plantType == PlantType.CROP || plantType == PlantType.PLAINS || plantType == PlantType.NETHER;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((Block)MNDBlocks.RESURGENT_SOIL.get()).m_49966_() : super.m_5573_(context);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }
}

