/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.FeastBlock;
import vectorwing.farmersdelight.common.tag.ModTags;

public class StriderloafBlock
extends FeastBlock {
    protected static final VoxelShape PLATE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    protected static final VoxelShape ROAST_SHAPE = Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), (BooleanOp)BooleanOp.f_82695_);

    public StriderloafBlock(BlockBehaviour.Properties properties, Supplier<Item> servingItem, boolean hasLeftovers) {
        super(properties, servingItem, hasLeftovers);
    }

    private static boolean hasLava(LevelReader level, BlockPos pos) {
        for (BlockPos nearbyPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
            if (level.m_8055_(nearbyPos).m_60819_().m_205070_(FluidTags.f_13132_)) {
                return true;
            }
            if (!nearbyPos.equals((Object)pos.m_7495_()) || !level.m_8055_(nearbyPos).m_204336_(ModTags.HEAT_SOURCES)) continue;
            return true;
        }
        return false;
    }

    private void updateBlockState(ServerLevel worldIn, BlockPos pos, BlockState newState, SoundEvent sound) {
        worldIn.m_46597_(pos, newState);
        worldIn.m_5594_(null, pos, sound, SoundSource.BLOCKS, 0.25f, 0.25f);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.f_46443_) {
            Block targetBlock;
            Block block = state.m_60734_() == MNDBlocks.COLD_STRIDERLOAF_BLOCK.get() && StriderloafBlock.hasLava((LevelReader)level, pos) ? (Block)MNDBlocks.STRIDERLOAF_BLOCK.get() : (targetBlock = state.m_60734_() == MNDBlocks.STRIDERLOAF_BLOCK.get() && !StriderloafBlock.hasLava((LevelReader)level, pos) ? (Block)MNDBlocks.COLD_STRIDERLOAF_BLOCK.get() : null);
            if (targetBlock != null) {
                BlockState newState = (BlockState)((BlockState)targetBlock.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)SERVINGS, (Comparable)((Integer)state.m_61143_((Property)SERVINGS)));
                SoundEvent sound = targetBlock == MNDBlocks.STRIDERLOAF_BLOCK.get() ? SoundEvents.f_12459_ : SoundEvents.f_12462_;
                this.updateBlockState(level, pos, newState, sound);
            }
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.m_8055_(fromPos).m_60819_().m_205070_(FluidTags.f_13132_)) {
            this.m_213897_(state, (ServerLevel)worldIn, pos, null);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)SERVINGS) == 0 ? PLATE_SHAPE : ROAST_SHAPE;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        int servings = (Integer)blockState.m_61143_((Property)this.getServingsProperty());
        if (servings > 0) {
            return blockState.m_60734_() == MNDBlocks.COLD_STRIDERLOAF_BLOCK.get() ? servings : servings + 1;
        }
        return blockState.m_60734_() == MNDBlocks.STRIDERLOAF_BLOCK.get() ? 1 : 0;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)MNDItems.STRIDERLOAF_BLOCK.get());
    }
}

