/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.item;

import com.google.common.collect.Lists;
import com.soytutta.mynethersdelight.common.registry.MNDEffects;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.utility.MathUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

@Mod.EventBusSubscriber(modid="mynethersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HotCreamConeItem
extends ConsumableItem {
    public static final List<MobEffectInstance> EFFECTS = Lists.newArrayList((Object[])new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19596_, 6000, 1)});

    public HotCreamConeItem(Item.Properties properties) {
        super(properties, false, true);
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_11970_;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        MobEffectInstance selectedEffect;
        Iterator itr = consumer.m_21220_().iterator();
        ArrayList<MobEffect> compatibleEffects = new ArrayList<MobEffect>();
        if (!consumer.m_5825_()) {
            consumer.m_7311_(consumer.m_20094_() + 1);
            consumer.m_20254_(10);
        }
        while (itr.hasNext()) {
            selectedEffect = (MobEffectInstance)itr.next();
            if (!selectedEffect.isCurativeItem(new ItemStack((ItemLike)Items.f_42455_))) continue;
            compatibleEffects.add(selectedEffect.m_19544_());
        }
        if (!compatibleEffects.isEmpty()) {
            MobEffect effectToRemove = (MobEffect)compatibleEffects.get(level.f_46441_.m_188503_(compatibleEffects.size()));
            selectedEffect = consumer.m_21124_(effectToRemove);
            int purgentSeconds = selectedEffect.m_19557_() / 15;
            int fireResistanceSeconds = purgentSeconds / 2;
            consumer.m_21195_(selectedEffect.m_19544_());
            if (fireResistanceSeconds > 0) {
                consumer.m_7292_(new MobEffectInstance(MobEffects.f_19607_, fireResistanceSeconds * 3));
            }
            if (purgentSeconds > 0) {
                consumer.m_7292_(new MobEffectInstance((MobEffect)MNDEffects.GPUNGENT.get(), purgentSeconds * 3));
            }
        }
        level.m_5594_(null, consumer.m_20183_(), SoundEvents.f_12031_, consumer.m_5720_(), 1.0f, 1.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            MutableComponent textWhenFeeding = TextUtils.getTranslation((String)"tooltip.strider_feed.when_feeding", (Object[])new Object[0]);
            tooltip.add((Component)textWhenFeeding.m_130940_(ChatFormatting.GRAY));
            for (MobEffectInstance effectInstance : EFFECTS) {
                MutableComponent effectDescription = Component.m_237113_((String)" ");
                MutableComponent effectName = Component.m_237115_((String)effectInstance.m_19576_());
                effectDescription.m_7220_((Component)effectName);
                MobEffect effect = effectInstance.m_19544_();
                if (effectInstance.m_19564_() > 0) {
                    effectDescription.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("potion.potency." + effectInstance.m_19564_())));
                }
                if (effectInstance.m_19557_() > 20) {
                    effectDescription.m_130946_(" (").m_130946_(MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f)).m_130946_(")");
                }
                tooltip.add((Component)effectDescription.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (target instanceof Strider) {
            Strider strider = (Strider)target;
            strider.m_21153_(strider.m_21233_());
            for (MobEffectInstance effect : EFFECTS) {
                strider.m_7292_(new MobEffectInstance(effect));
            }
            strider.f_19853_.m_5594_(null, target.m_20183_(), SoundEvents.f_12459_, SoundSource.PLAYERS, 0.8f, 0.8f);
            for (int i = 0; i < 5; ++i) {
                double d0 = MathUtils.RAND.nextGaussian() * 0.02;
                double d1 = MathUtils.RAND.nextGaussian() * 0.02;
                double d2 = MathUtils.RAND.nextGaussian() * 0.02;
                strider.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.STAR.get(), strider.m_20208_(1.0), strider.m_20187_() + 0.5, strider.m_20262_(1.0), d0, d1, d2);
            }
            if (!playerIn.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Mod.EventBusSubscriber(modid="mynethersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class StriderFeedEvent {
        @SubscribeEvent
        public static void onStriderFeedApplied(PlayerInteractEvent.EntityInteract event) {
            LivingEntity entity;
            Player player = event.getEntity();
            Entity target = event.getTarget();
            ItemStack heldStack = event.getItemStack();
            if (target instanceof LivingEntity && (entity = (LivingEntity)target) instanceof Strider && entity.m_6084_() && heldStack.m_41720_().equals(MNDItems.HOT_CREAM_CONE.get())) {
                entity.m_21153_(entity.m_21233_());
                for (MobEffectInstance effect : EFFECTS) {
                    entity.m_7292_(new MobEffectInstance(effect));
                }
                entity.f_19853_.m_5594_(null, target.m_20183_(), SoundEvents.f_12459_, SoundSource.PLAYERS, 0.8f, 0.8f);
                for (int i = 0; i < 5; ++i) {
                    double d0 = MathUtils.RAND.nextGaussian() * 0.02;
                    double d1 = MathUtils.RAND.nextGaussian() * 0.02;
                    double d2 = MathUtils.RAND.nextGaussian() * 0.02;
                    entity.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.STAR.get(), entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), d0, d1, d2);
                }
                if (!player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

