/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.soytutta.mynethersdelight.common.block.MagmaCakeBlock;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.loot.modifier.PastrySlicingModifier;

public class MNDPastrySlicingModifier
extends PastrySlicingModifier {
    public static final Supplier<Codec<MNDPastrySlicingModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> MNDPastrySlicingModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("slice").forGetter(m -> m.pastrySlice)).apply((Applicative)inst, MNDPastrySlicingModifier::new)));
    private final Item pastrySlice;

    protected MNDPastrySlicingModifier(LootItemCondition[] conditionsIn, Item pastrySliceIn) {
        super(conditionsIn, pastrySliceIn);
        this.pastrySlice = pastrySliceIn;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (state != null && state.m_60734_() instanceof MagmaCakeBlock) {
            int bites = (Integer)state.m_61143_((Property)MagmaCakeBlock.BITES);
            int count = (Boolean)state.m_61143_((Property)MagmaCakeBlock.SECOND_CAKE) != false ? 14 - bites : 7 - bites;
            generatedLoot.add((Object)new ItemStack((ItemLike)this.pastrySlice, count));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

