/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.integration.jei;

import com.google.common.collect.ImmutableList;
import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.utility.MNDTextUtils;
import com.soytutta.mynethersdelight.integration.jei.MNDRecipeTypes;
import com.soytutta.mynethersdelight.integration.jei.category.ForgotingRecipeCategory;
import com.soytutta.mynethersdelight.integration.jei.resource.ForgotingDummy;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.integration.jei.FDRecipes;

@ParametersAreNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("mynethersdelight", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ForgotingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        new FDRecipes();
        registration.addRecipes(MNDRecipeTypes.FORGOTING, (List)ImmutableList.of((Object)new ForgotingDummy()));
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)MNDItems.BULLET_PEPPER.get()), new ItemStack((ItemLike)MNDItems.POWDER_CANNON.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{MNDTextUtils.getTranslation("jei.info.wild_powdery", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)MNDItems.RESURGENT_SOIL_FARMLAND.get()), new ItemStack((ItemLike)MNDItems.RESURGENT_SOIL.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{MNDTextUtils.getTranslation("jei.info.r_soil", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModItems.BROWN_MUSHROOM_COLONY.get()), new ItemStack((ItemLike)ModItems.RED_MUSHROOM_COLONY.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{MNDTextUtils.getTranslation("jei.info.mushroom_colony", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)Items.f_42588_), new ItemStack((ItemLike)MNDItems.WARPED_FUNGUS_COLONY.get()), new ItemStack((ItemLike)MNDItems.CRIMSON_FUNGUS_COLONY.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{MNDTextUtils.getTranslation("jei.info.fungus_colony", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)MNDItems.STRIDER_ROCK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{MNDTextUtils.getTranslation("jei.info.strider_egg", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)MNDItems.HOGLIN_HIDE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{MNDTextUtils.getTranslation("jei.info.hoglin_hide", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)MNDItems.HOT_CREAM_CONE.get()), new ItemStack((ItemLike)MNDItems.HOT_CREAM.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{MNDTextUtils.getTranslation("jei.info.hot_cream", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)MNDItems.ROAST_STUFFED_HOGLIN.get()), new ItemStack((ItemLike)MNDItems.ROAST_EAR.get()), new ItemStack((ItemLike)MNDItems.PLATE_OF_STUFFED_HOGLIN_SNOUT.get()), new ItemStack((ItemLike)MNDItems.PLATE_OF_STUFFED_HOGLIN_HAM.get()), new ItemStack((ItemLike)MNDItems.PLATE_OF_STUFFED_HOGLIN.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{MNDTextUtils.getTranslation("jei.info.plate_of_stuffed_hoglin", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)MNDItems.GHASTA_WITH_CREAM_BLOCK.get()), new ItemStack((ItemLike)MNDItems.GHASTA_WITH_CREAM.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{MNDTextUtils.getTranslation("jei.info.plate_of_ghasta", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)MNDItems.STRIDERLOAF_BLOCK.get()), new ItemStack((ItemLike)MNDItems.STRIDERLOAF.get()), new ItemStack((ItemLike)MNDItems.COLD_STRIDERLOAF.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{MNDTextUtils.getTranslation("jei.info.plate_of_striderloaf", new Object[0])});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MNDItems.NETHER_STOVE.get()), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MNDItems.SOUL_NETHER_STOVE.get()), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MNDBlocks.LETIOS_COMPOST.get()), new RecipeType[]{MNDRecipeTypes.FORGOTING});
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

