/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.CoFHCore;
import cofh.lib.fluid.FluidCoFH;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class HoneyFluid
extends FluidCoFH {
    private static HoneyFluid INSTANCE;
    public static final RegistryObject<FluidType> TYPE;

    public static HoneyFluid create() {
        if (INSTANCE == null) {
            INSTANCE = new HoneyFluid();
        }
        return INSTANCE;
    }

    protected HoneyFluid() {
        super(CoFHCore.FLUIDS, "honey");
    }

    @Override
    protected ForgeFlowingFluid.Properties fluidProperties() {
        return new ForgeFlowingFluid.Properties(this.type(), (Supplier)this.stillFluid, (Supplier)this.flowingFluid);
    }

    @Override
    protected Supplier<FluidType> type() {
        return TYPE;
    }

    static {
        TYPE = CoFHCore.FLUID_TYPES.register("honey", () -> new FluidType(FluidType.Properties.create().density(1500).viscosity(1000000).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11770_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11769_)){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private static final ResourceLocation STILL = new ResourceLocation("cofh_core:block/fluids/honey_still");
                    private static final ResourceLocation FLOW = new ResourceLocation("cofh_core:block/fluids/honey_flow");

                    public ResourceLocation getStillTexture() {
                        return STILL;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FLOW;
                    }
                });
            }
        });
    }
}

