/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import cofh.lib.enchantment.EnchantmentCoFH;
import cofh.lib.tags.ItemTagsCoFH;
import cofh.lib.util.helpers.MathHelper;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.glfw.GLFW;

public class Utils {
    public static final int TIME_CONSTANT = 40;
    public static final int TIME_CONSTANT_HALF = 20;
    public static final int TIME_CONSTANT_QUARTER = 10;
    private static int timeConstant = 0;
    private static int timeConstantHalf = 0;
    private static int timeConstantQuarter = 0;

    private Utils() {
    }

    public static boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    public static boolean isClientWorld(Level world) {
        return world.f_46443_;
    }

    public static boolean isServerWorld(Level world) {
        return !world.f_46443_;
    }

    public static boolean isFakePlayer(Entity entity) {
        return entity instanceof FakePlayer;
    }

    public static boolean isCreativePlayer(Entity entity) {
        Player player;
        return entity instanceof Player && (player = (Player)entity).m_7500_();
    }

    public static EquipmentSlot handToEquipSlot(InteractionHand hand) {
        return hand.equals((Object)InteractionHand.MAIN_HAND) ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }

    public static InteractionHand otherHand(InteractionHand hand) {
        return hand.equals((Object)InteractionHand.MAIN_HAND) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public static EquipmentSlot otherHand(EquipmentSlot slot) {
        return slot.equals((Object)EquipmentSlot.MAINHAND) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
    }

    public static String createPrettyJSON(String jsonString) {
        JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)json);
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public static boolean spawnLightningBolt(Level world, BlockPos pos) {
        return Utils.spawnLightningBolt(world, pos, null);
    }

    public static boolean spawnLightningBolt(Level world, BlockPos pos, Entity caster) {
        if (Utils.isServerWorld(world)) {
            ServerPlayer player;
            LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            bolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
            bolt.m_20879_(caster instanceof ServerPlayer ? (player = (ServerPlayer)caster) : null);
            world.m_7967_((Entity)bolt);
        }
        return true;
    }

    public static void spawnXpOrbs(Level world, int xp, Vec3 pos) {
        if (world == null) {
            return;
        }
        while (xp > 0) {
            int orbAmount = ExperienceOrb.m_20782_((int)xp);
            xp -= orbAmount;
            world.m_7967_((Entity)new ExperienceOrb(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, orbAmount));
        }
    }

    public static boolean destroyBlock(Level world, BlockPos pos, boolean dropBlock, @Nullable Entity entityIn) {
        Player player;
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_() || state.m_60800_((BlockGetter)world, pos) < 0.0f || entityIn instanceof Player && state.m_60625_(player = (Player)entityIn, (BlockGetter)world, pos) < 0.0f) {
            return false;
        }
        FluidState ifluidstate = world.m_6425_(pos);
        if (dropBlock) {
            BlockEntity tileentity = state.m_155947_() ? world.m_7702_(pos) : null;
            Block.m_49881_((BlockState)state, (Level)world, (BlockPos)pos, (BlockEntity)tileentity, (Entity)entityIn, (ItemStack)ItemStack.f_41583_);
        }
        return world.m_7731_(pos, ifluidstate.m_76188_(), 3);
    }

    public static boolean isWrench(ItemStack item) {
        return item.m_204117_(ItemTagsCoFH.TOOLS_WRENCH);
    }

    @Nullable
    public static String getKeynameFromKeycode(int code) {
        return GLFW.glfwGetKeyName((int)code, (int)-1);
    }

    @Nullable
    public static String getKeyNameFromScanCode(int code) {
        return GLFW.glfwGetKeyName((int)-1, (int)code);
    }

    public static void openEntityScreen(ServerPlayer player, MenuProvider containerSupplier, Entity entity) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)containerSupplier, buf -> buf.m_130130_(entity.m_19879_()));
    }

    public static <E extends Entity> E getEntityFromBuf(FriendlyByteBuf buf, Class<E> type) {
        if (buf == null) {
            throw new IllegalArgumentException("Null packet buffer.");
        }
        return (E)((Entity)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.m_91087_().f_91073_ == null) {
                throw new IllegalStateException("Client world is null.");
            }
            int entityId = buf.m_130242_();
            Entity e = Minecraft.m_91087_().f_91073_.m_6815_(entityId);
            if (type.isInstance(e)) {
                return e;
            }
            throw new IllegalStateException("Client could not locate entity (id: " + entityId + ")  for entity container or the entity was of an invalid type. This is likely caused by a mod breaking client side entity lookup.");
        }));
    }

    public static void tickTimeConstants() {
        if (++timeConstant >= 40) {
            timeConstant = 0;
        }
        if (++timeConstantHalf >= 20) {
            timeConstantHalf = 0;
        }
        if (++timeConstantQuarter >= 10) {
            timeConstantQuarter = 0;
        }
    }

    public static boolean timeCheck() {
        return timeConstant == 0;
    }

    public static boolean timeCheckHalf() {
        return timeConstantHalf == 0;
    }

    public static boolean timeCheckQuarter() {
        return timeConstantQuarter == 0;
    }

    public static void spawnBlockParticlesClient(Level world, ParticleOptions particle, BlockPos pos, RandomSource rand, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = (double)pos.m_123341_() + rand.m_188500_();
            double d1 = (double)pos.m_123342_() + rand.m_188500_();
            double d2 = (double)pos.m_123343_() + rand.m_188500_();
            double d3 = (rand.m_188500_() - 0.5) * 0.5;
            double d4 = (rand.m_188500_() - 0.5) * 0.5;
            double d5 = (rand.m_188500_() - 0.5) * 0.5;
            world.m_7106_(particle, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void spawnParticles(Level world, ParticleOptions particle, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        if (Utils.isServerWorld(world)) {
            ((ServerLevel)world).m_8767_(particle, posX, posY + 1.0, posZ, particleCount, xOffset, yOffset, zOffset, speed);
        } else {
            world.m_7106_(particle, posX + xOffset, posY + yOffset, posZ + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticles(Level level, ParticleOptions particle, int count, Vec3 pos, float posVar, Vec3 velocity, float velVar) {
        for (int i = 0; i < count; ++i) {
            Utils.spawnParticles(level, particle, pos, posVar, velocity, velVar);
        }
    }

    public static void spawnParticles(Level level, ParticleOptions particle, Vec3 pos, float posVar, Vec3 velocity, float velVar) {
        RandomSource rand = level.m_213780_();
        Utils.spawnParticles(level, particle, pos.m_82520_((double)(rand.m_188501_() * posVar * 2.0f - posVar), (double)(rand.m_188501_() * posVar * 2.0f - posVar), (double)(rand.m_188501_() * posVar * 2.0f - posVar)), velocity.m_82520_((double)(rand.m_188501_() * velVar * 2.0f - velVar), (double)(rand.m_188501_() * velVar * 2.0f - velVar), (double)(rand.m_188501_() * velVar * 2.0f - velVar)));
    }

    public static void spawnParticles(Level level, ParticleOptions particle, Vec3 pos, Vec3 velocity) {
        level.m_7106_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
    }

    public static boolean addToPlayerInventory(Player player, ItemStack stack) {
        ArmorItem armorItem;
        int index;
        if (stack.m_41619_() || player == null) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem && ((ItemStack)player.m_150109_().f_35975_.get(index = (armorItem = (ArmorItem)item).m_40402_().m_20749_())).m_41619_()) {
            player.m_150109_().f_35975_.set(index, (Object)stack);
            return true;
        }
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.f_35974_.size(); ++i) {
            if (!((ItemStack)inv.f_35974_.get(i)).m_41619_()) continue;
            inv.f_35974_.set(i, (Object)stack.m_41777_());
            return true;
        }
        return false;
    }

    public static boolean addPotionEffectNoEvent(LivingEntity entity, MobEffectInstance effectInstanceIn) {
        if (!Utils.isPotionApplicableNoEvent(entity, effectInstanceIn)) {
            return false;
        }
        MobEffectInstance effectinstance = (MobEffectInstance)entity.m_21221_().get(effectInstanceIn.m_19544_());
        if (effectinstance == null) {
            entity.m_21221_().put(effectInstanceIn.m_19544_(), effectInstanceIn);
            entity.m_142540_(effectInstanceIn, null);
            return true;
        }
        if (effectinstance.m_19558_(effectInstanceIn)) {
            entity.m_141973_(effectinstance, true, null);
            return true;
        }
        return false;
    }

    public static boolean isPotionApplicableNoEvent(LivingEntity entity, MobEffectInstance potioneffectIn) {
        if (entity.m_6336_() == MobType.f_21641_) {
            MobEffect effect = potioneffectIn.m_19544_();
            return effect != MobEffects.f_19605_ && effect != MobEffects.f_19614_;
        }
        return true;
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, Level world, Vec3 pos) {
        return Utils.dropItemStackIntoWorld(stack, world, pos, false);
    }

    public static boolean dropItemStackIntoWorldWithRandomness(ItemStack stack, Level world, BlockPos pos) {
        return Utils.dropItemStackIntoWorld(stack, world, Vec3.m_82512_((Vec3i)pos), true);
    }

    public static boolean dropItemStackIntoWorldWithRandomness(ItemStack stack, Level world, Vec3 pos) {
        return Utils.dropItemStackIntoWorld(stack, world, pos, true);
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, Level world, Vec3 pos, boolean velocity) {
        if (stack.m_41619_()) {
            return false;
        }
        float x2 = 0.5f;
        float y2 = 0.0f;
        float z2 = 0.5f;
        if (velocity) {
            x2 = world.f_46441_.m_188501_() * 0.8f + 0.1f;
            y2 = world.f_46441_.m_188501_() * 0.8f + 0.1f;
            z2 = world.f_46441_.m_188501_() * 0.8f + 0.1f;
        }
        ItemEntity entity = new ItemEntity(world, pos.f_82479_ + (double)x2, pos.f_82480_ + (double)y2, pos.f_82481_ + (double)z2, stack.m_41777_());
        if (velocity) {
            entity.m_20334_(world.f_46441_.m_188583_() * (double)0.05f, world.f_46441_.m_188583_() * (double)0.05f + (double)0.2f, world.f_46441_.m_188583_() * (double)0.05f);
        } else {
            entity.m_20334_(-0.05, 0.0, 0.0);
        }
        world.m_7967_((Entity)entity);
        return true;
    }

    public static boolean dropDismantleStackIntoWorld(ItemStack stack, Level world, BlockPos pos) {
        if (stack.m_41619_() || Utils.isClientWorld(world)) {
            return false;
        }
        float f = 0.3f;
        double x2 = (double)(world.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.5;
        double y2 = (double)(world.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.5;
        double z2 = (double)(world.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.5;
        ItemEntity dropEntity = new ItemEntity(world, (double)pos.m_123341_() + x2, (double)pos.m_123342_() + y2, (double)pos.m_123343_() + z2, stack);
        dropEntity.m_32010_(10);
        world.m_7967_((Entity)dropEntity);
        return true;
    }

    public static boolean teleportEntityTo(Entity entity, BlockPos pos) {
        return Utils.teleportEntityTo(entity, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
    }

    public static boolean teleportEntityTo(Entity entity, double x, double y, double z) {
        if (entity instanceof LivingEntity) {
            return Utils.teleportEntityTo((LivingEntity)entity, x, y, z);
        }
        entity.m_7678_(x, y, z, entity.m_146908_(), entity.m_146909_());
        entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean teleportEntityTo(LivingEntity entity, double x, double y, double z) {
        event = new EntityTeleportEvent.EnderEntity(entity, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (!(entity instanceof ServerPlayer)) ** GOTO lbl-1000
        player = (ServerPlayer)entity;
        if (!Utils.isFakePlayer((Entity)entity)) {
            if (player.f_8906_.m_6198_().m_129536_() && !player.m_5803_()) {
                if (entity.m_20159_()) {
                    entity.m_8127_();
                }
                entity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                entity.f_19789_ = 0.0f;
            }
        } else lbl-1000:
        // 2 sources

        {
            if (entity.m_20159_()) {
                entity.m_8127_();
            }
            entity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            entity.f_19789_ = 0.0f;
        }
        entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        return true;
    }

    public static Enchantment getEnchantment(String modId, String enchantId) {
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(modId, enchantId));
    }

    public static int getEnchantedCapacity(int amount, int holding) {
        return MathHelper.clamp(amount + amount * holding / 2, 0, Integer.MAX_VALUE);
    }

    public static int getItemEnchantmentLevel(Enchantment ench, ItemStack stack) {
        if (ench == null || ench instanceof EnchantmentCoFH && !((EnchantmentCoFH)ench).isEnabled()) {
            return 0;
        }
        return EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)stack);
    }

    public static int getHeldEnchantmentLevel(LivingEntity living, Enchantment ench) {
        if (ench == null || ench instanceof EnchantmentCoFH && !((EnchantmentCoFH)ench).isEnabled()) {
            return 0;
        }
        return Math.max(EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)living.m_21205_()), EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)living.m_21206_()));
    }

    public static int getMaxEquippedEnchantmentLevel(LivingEntity living, Enchantment ench) {
        if (ench == null || ench instanceof EnchantmentCoFH && !((EnchantmentCoFH)ench).isEnabled()) {
            return 0;
        }
        return EnchantmentHelper.m_44836_((Enchantment)ench, (LivingEntity)living);
    }

    public static void addEnchantment(ItemStack stack, Enchantment ench, int level) {
        stack.m_41663_(ench, level);
    }

    public static void removeEnchantment(ItemStack stack, Enchantment ench) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128425_("Enchantments", 9)) {
            return;
        }
        ListTag list = stack.m_41783_().m_128437_("Enchantments", 10);
        String encId = String.valueOf(ForgeRegistries.ENCHANTMENTS.getKey((Object)ench));
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            String id = tag.m_128461_("id");
            if (!encId.equals(id)) continue;
            list.remove(i);
            break;
        }
        if (list.isEmpty()) {
            stack.m_41749_("Enchantments");
        }
    }

    public static ResourceLocation getRegistryName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static ResourceLocation getRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getRegistryName(Fluid fluid) {
        return ForgeRegistries.FLUIDS.getKey((Object)fluid);
    }

    public static ResourceLocation getRegistryName(EntityType entity) {
        return ForgeRegistries.ENTITY_TYPES.getKey((Object)entity);
    }

    public static ResourceLocation getRegistryName(MobEffect effect) {
        return ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
    }

    public static String getModId(Block block) {
        ResourceLocation loc = Utils.getRegistryName(block);
        return loc == null ? "" : loc.m_135827_();
    }

    public static String getName(Block block) {
        ResourceLocation loc = Utils.getRegistryName(block);
        return loc == null ? "" : loc.m_135815_();
    }

    public static String getModId(Item item) {
        ResourceLocation loc = Utils.getRegistryName(item);
        return loc == null ? "" : loc.m_135827_();
    }

    public static String getModId(ItemStack stack) {
        ResourceLocation loc = Utils.getRegistryName(stack.m_41720_());
        return loc == null ? "" : loc.m_135827_();
    }

    public static String getName(Item item) {
        ResourceLocation loc = Utils.getRegistryName(item);
        return loc == null ? "" : loc.m_135815_();
    }

    public static String getName(ItemStack stack) {
        ResourceLocation loc = Utils.getRegistryName(stack.m_41720_());
        return loc == null ? "" : loc.m_135815_();
    }

    public static String getModId(Fluid fluid) {
        ResourceLocation loc = Utils.getRegistryName(fluid);
        return loc == null ? "" : loc.m_135827_();
    }

    public static String getModId(FluidStack stack) {
        ResourceLocation loc = Utils.getRegistryName(stack.getFluid());
        return loc == null ? "" : loc.m_135827_();
    }

    public static String getName(Fluid fluid) {
        ResourceLocation loc = Utils.getRegistryName(fluid);
        return loc == null ? "" : loc.m_135815_();
    }

    public static String getName(FluidStack stack) {
        ResourceLocation loc = Utils.getRegistryName(stack.getFluid());
        return loc == null ? "" : loc.m_135815_();
    }
}

