/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.dogslie.common.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import me.ichun.mods.dogslie.common.LetSleepingDogsLie;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class EventHandlerClient {
    public Random rand = new Random();
    public WeakHashMap<Wolf, WolfInfo> wolfInfo = new WeakHashMap();

    public abstract void fireClientLevelLoad(ClientLevel var1);

    public void onEntityJoinLevel(Level level, Entity entity) {
        Wolf wolf;
        if (level.f_46443_ && entity instanceof Wolf && !this.wolfInfo.containsKey(wolf = (Wolf)entity)) {
            this.wolfInfo.put(wolf, new WolfInfo(LetSleepingDogsLie.config.dogsSpawnLying.get() != false && Minecraft.m_91087_().f_91075_ != null && Minecraft.m_91087_().f_91075_.f_19797_ < 20));
        }
    }

    public void onClientTickEnd(Minecraft client) {
        if (!client.m_91104_()) {
            this.wolfInfo.entrySet().removeIf(e -> !((WolfInfo)e.getValue()).tick((Wolf)e.getKey()));
        }
    }

    public void onLevelLoad() {
        Minecraft.m_91087_().execute(this::clean);
    }

    public void onClientDisconnected() {
        Minecraft.m_91087_().execute(this::clean);
    }

    public void clean() {
        this.wolfInfo.clear();
    }

    @NotNull
    public WolfInfo getWolfInfo(Wolf wolf) {
        return this.wolfInfo.computeIfAbsent(wolf, w -> new WolfInfo(LetSleepingDogsLie.config.dogsSpawnLying.get() != false && Minecraft.m_91087_().f_91075_ != null && Minecraft.m_91087_().f_91075_.f_19797_ < 20));
    }

    public class WolfInfo {
        public int sitTime;
        public String[] setPoses = null;

        public WolfInfo(boolean lying) {
            this.sitTime = lying ? LetSleepingDogsLie.config.timeBeforeLie.get() : 0;
        }

        public boolean tick(Wolf parent) {
            if (parent.m_213877_()) {
                return false;
            }
            if (parent.m_21825_()) {
                List ents;
                boolean isLying = this.isLying();
                ++this.sitTime;
                if (!isLying && this.isLying() && Minecraft.m_91087_().f_91075_ != null && Minecraft.m_91087_().f_91075_.f_19797_ > 20) {
                    parent.m_20193_().m_7785_(parent.m_20185_(), parent.m_20186_() + (double)parent.m_20192_(), parent.m_20189_(), SoundEvents.f_12625_, parent.m_5720_(), 0.4f, parent.m_6162_() ? (parent.m_217043_().m_188501_() - parent.m_217043_().m_188501_()) * 0.2f + 1.5f : (parent.m_217043_().m_188501_() - parent.m_217043_().m_188501_()) * 0.2f + 1.0f, false);
                }
                LetSleepingDogsLie.GetsUpFor getsUpFor = LetSleepingDogsLie.config.getsUpTo.get();
                if (parent.f_19797_ % 10 == 0 && getsUpFor != LetSleepingDogsLie.GetsUpFor.NOBODY && LetSleepingDogsLie.config.rangeBeforeGettingUp.get() > 0.1 && (ents = parent.m_20193_().m_45933_((Entity)parent, parent.m_20191_().m_82400_(LetSleepingDogsLie.config.rangeBeforeGettingUp.get().doubleValue()))).stream().anyMatch(entity -> (getsUpFor == LetSleepingDogsLie.GetsUpFor.OWNER && entity instanceof LivingEntity && parent.m_21830_((LivingEntity)entity) || getsUpFor == LetSleepingDogsLie.GetsUpFor.PLAYERS && entity instanceof Player && !entity.m_5833_() || getsUpFor == LetSleepingDogsLie.GetsUpFor.ANY_LIVING_ENTITY && entity instanceof LivingEntity && (!(entity instanceof Player) || !entity.m_5833_())) && parent.m_142582_(entity))) {
                    if (isLying) {
                        parent.m_20193_().m_7785_(parent.m_20185_(), parent.m_20186_() + (double)parent.m_20192_(), parent.m_20189_(), SoundEvents.f_12617_, parent.m_5720_(), 0.4f, parent.m_6162_() ? (parent.m_217043_().m_188501_() - parent.m_217043_().m_188501_()) * 0.2f + 1.5f : (parent.m_217043_().m_188501_() - parent.m_217043_().m_188501_()) * 0.2f + 1.0f, false);
                    }
                    this.sitTime = 0;
                    this.setPoses = null;
                }
            } else {
                this.sitTime = 0;
                this.setPoses = null;
            }
            return true;
        }

        public boolean isLying() {
            return this.sitTime > LetSleepingDogsLie.config.timeBeforeLie.get();
        }

        public String[] getCompatiblePoses(Wolf parent) {
            if (this.setPoses == null) {
                String[] poses = new String[2];
                ArrayList<String> front = new ArrayList<String>();
                ArrayList<String> rear = new ArrayList<String>();
                for (String s : LetSleepingDogsLie.config.enabledPoses.get()) {
                    if (s.startsWith("foreleg") && (!parent.m_6162_() || s.equalsIgnoreCase("forelegSprawledBack") || s.equalsIgnoreCase("forelegSide"))) {
                        front.add(s);
                    }
                    if (!s.startsWith("hindleg")) continue;
                    rear.add(s);
                }
                if (front.isEmpty()) {
                    if (!parent.m_6162_()) {
                        front.add("forelegStraight");
                        front.add("forelegSprawled");
                        front.add("forelegSkewed");
                    }
                    front.add("forelegSprawledBack");
                    front.add("forelegSide");
                }
                if (rear.isEmpty()) {
                    rear.add("hindlegStraight");
                    rear.add("hindlegStraightBack");
                    rear.add("hindlegSprawled");
                    rear.add("hindlegSprawledBack");
                    rear.add("hindlegSide");
                }
                if (EventHandlerClient.this.rand.nextBoolean()) {
                    poses[0] = (String)front.get(EventHandlerClient.this.rand.nextInt(front.size()));
                    poses[1] = (String)rear.get(EventHandlerClient.this.rand.nextInt(rear.size()));
                } else {
                    poses[1] = (String)rear.get(EventHandlerClient.this.rand.nextInt(rear.size()));
                    poses[0] = (String)front.get(EventHandlerClient.this.rand.nextInt(front.size()));
                }
                if (poses[0].endsWith("Side") && poses[1].endsWith("Side")) {
                    String side = EventHandlerClient.this.rand.nextBoolean() ? "L" : "R";
                    poses[0] = poses[0] + side;
                    poses[1] = poses[1] + side;
                } else {
                    if (poses[0].endsWith("Side") || poses[0].endsWith("Skewed")) {
                        poses[0] = poses[0] + (EventHandlerClient.this.rand.nextBoolean() ? "L" : "R");
                    }
                    if (poses[1].endsWith("Side")) {
                        poses[1] = poses[1] + (EventHandlerClient.this.rand.nextBoolean() ? "L" : "R");
                    }
                }
                this.setPoses = poses;
            }
            return this.setPoses;
        }
    }
}

