/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.rosemods.windswept.core.other.WindsweptTiers;
import com.rosemods.windswept.core.other.tags.WindsweptBlockTags;
import com.rosemods.windswept.core.registry.WindsweptAttributes;
import com.rosemods.windswept.core.registry.WindsweptItems;
import com.teamabnormals.blueprint.core.util.item.filling.TargetedItemCategoryFiller;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SnowBootsItem
extends DyeableArmorItem {
    private static final UUID SNOW_SPEED_UUID = UUID.fromString("713d8671-29b8-4600-ba51-580b91cc24cf");
    private static final UUID SPEED_MODIFIER_SNOW_SPEED_UUID = UUID.fromString("c51348dc-85bf-4ac5-8428-deefefec04aa");
    private static final TargetedItemCategoryFiller FILLER = new TargetedItemCategoryFiller(() -> ((Item)Items.f_42354_).m_5456_());

    public SnowBootsItem(Item.Properties properties) {
        super((ArmorMaterial)WindsweptTiers.SNOW_BOOTS, EquipmentSlot.FEET, properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.m_7167_(slot));
        if (this.f_40377_ == slot) {
            builder.put((Object)((Attribute)WindsweptAttributes.SNOW_SPEED.get()), (Object)new AttributeModifier(SNOW_SPEED_UUID, "Snow speed modifier", 0.25, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        return builder.build();
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        FILLER.fillItem((Item)this, tab, items);
    }

    public static boolean onSnowBlock(LivingEntity entity) {
        BlockPos below = entity.m_20099_();
        return entity.f_19853_.m_8055_(below).m_204336_(WindsweptBlockTags.SNOW_BOOTS_BLOCKS) || entity.f_19853_.m_8055_(below.m_7494_()).m_204336_(WindsweptBlockTags.SNOW_BOOTS_BLOCKS);
    }

    public static boolean canSpawnSnowSpeedParticle(LivingEntity entity) {
        return entity.f_19797_ % 5 == 0 && entity.m_20184_().f_82479_ != 0.0 && entity.m_20184_().f_82481_ != 0.0 && !entity.m_5833_() && SnowBootsItem.onSnowBlock(entity) && entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)WindsweptItems.SNOW_BOOTS.get());
    }

    public static boolean shouldRemoveSnowSpeed(BlockState state, LivingEntity entity) {
        return !state.m_60795_() || entity.m_21255_();
    }

    public static void spawnSnowSpeedParticle(LivingEntity entity) {
        Vec3 vec3 = entity.m_20184_();
        entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175821_, entity.m_20185_() + (entity.f_19853_.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_(), entity.m_20186_() + 0.1, entity.m_20189_() + (entity.f_19853_.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_(), vec3.f_82479_ * -0.2, 0.1, vec3.f_82481_ * -0.2);
    }

    public static void removeSnowSpeed(LivingEntity entity) {
        AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
        if (speed != null && speed.m_22111_(SPEED_MODIFIER_SNOW_SPEED_UUID) != null) {
            speed.m_22120_(SPEED_MODIFIER_SNOW_SPEED_UUID);
        }
    }

    public static void tryAddSnowSpeed(LivingEntity entity) {
        AttributeInstance speed;
        if (entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)WindsweptItems.SNOW_BOOTS.get()) && SnowBootsItem.onSnowBlock(entity) && !entity.f_19853_.m_8055_(entity.m_20097_()).m_60795_() && (speed = entity.m_21051_(Attributes.f_22279_)) != null) {
            speed.m_22118_(new AttributeModifier(SPEED_MODIFIER_SNOW_SPEED_UUID, "Snow speed boost", 0.025, AttributeModifier.Operation.ADDITION));
            if (entity.f_19853_.f_46441_.m_188501_() < 0.02f) {
                entity.m_6844_(EquipmentSlot.FEET).m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.FEET));
            }
        }
    }
}

