/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.item.wooden_bucket;

import com.rosemods.windswept.core.WindsweptConfig;
import com.rosemods.windswept.core.api.IWoodenBucketPickupBlock;
import com.rosemods.windswept.core.registry.WindsweptItems;
import com.teamabnormals.blueprint.core.util.item.filling.TargetedItemCategoryFiller;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class WoodenBucketItem
extends BucketItem {
    public static final TargetedItemCategoryFiller FILLER = new TargetedItemCategoryFiller(() -> ((Item)Items.f_151055_).m_5456_());

    public WoodenBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult blockhitresult = WoodenBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.getFluid() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        if (level.m_7966_(player, blockpos) && player.m_36204_(blockpos1, direction, itemstack)) {
            if (this.getFluid() == Fluids.f_76191_) {
                IWoodenBucketPickupBlock pickup;
                BlockState state = level.m_8055_(blockpos);
                Block block = state.m_60734_();
                if (block instanceof IWoodenBucketPickupBlock && (pickup = (IWoodenBucketPickupBlock)block).canPickup((LevelAccessor)level, blockpos, state)) {
                    ItemStack filledBucket = WoodenBucketItem.getFilled(itemstack, (ItemLike)pickup.getWoodenBucketItem(), player);
                    pickup.getWoodenBucketPickupSound().ifPresent(soundevent -> player.m_5496_(soundevent, 1.0f, 1.0f));
                    pickup.pickupBlockFromWoodenBucket((LevelAccessor)level, blockpos, state);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    level.m_142346_((Entity)player, GameEvent.f_157816_, blockpos);
                    if (!level.f_46443_) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, filledBucket);
                    }
                    return InteractionResultHolder.m_19092_((Object)ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)filledBucket), (boolean)level.f_46443_);
                }
            } else {
                BlockPos blockpos2;
                BlockState blockstate = level.m_8055_(blockpos);
                BlockPos blockPos = blockpos2 = this.canBlockContainFluid(level, blockpos, blockstate) ? blockpos : blockpos1;
                if (this.m_142073_(player, level, blockpos2, blockhitresult)) {
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, blockpos2, itemstack);
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    return InteractionResultHolder.m_19092_((Object)WoodenBucketItem.getEmpty(itemstack, player, hand), (boolean)level.f_46443_);
                }
            }
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)WindsweptConfig.COMMON.woodenBucketDurabilty.get();
    }

    private boolean canBlockContainFluid(Level level, BlockPos pos, BlockState state) {
        LiquidBlockContainer container;
        Block block = state.m_60734_();
        return block instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, this.getFluid());
    }

    public boolean isRepairable(ItemStack stack) {
        return this.getFluid() == Fluids.f_76191_;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int getBurnTime(ItemStack stack, RecipeType<?> recipeType) {
        return this.getFluid() == Fluids.f_76191_ ? 600 : super.getBurnTime(stack, recipeType);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return this.getFluid() == Fluids.f_76193_ ? WoodenBucketItem.getEmpty(itemStack, null, null) : super.getCraftingRemainingItem(itemStack);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        FILLER.fillItem((Item)this, group, items);
    }

    public static ItemStack getEmpty(ItemStack handStack, @Nullable Player player, @Nullable InteractionHand hand) {
        ItemStack bucket = new ItemStack((ItemLike)WindsweptItems.WOODEN_BUCKET.get());
        bucket.m_41721_(handStack.m_41773_());
        if (player != null) {
            bucket.m_41622_(1, (LivingEntity)player, p -> {
                if (hand != null) {
                    p.m_21190_(hand);
                }
            });
        } else if (bucket.m_220157_(1, RandomSource.m_216327_(), null)) {
            bucket.m_41764_(0);
        }
        return player != null && player.m_150110_().f_35937_ ? handStack : bucket;
    }

    public static ItemStack getFilled(ItemStack handStack, ItemLike filled, Player player) {
        ItemStack bucket = new ItemStack(filled);
        if (!player.m_150110_().f_35937_) {
            bucket.m_41721_(handStack.m_41773_());
        }
        return ItemUtils.m_41813_((ItemStack)handStack, (Player)player, (ItemStack)bucket);
    }
}

