/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.world.gen.tree.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rosemods.windswept.core.WindsweptConfig;
import com.rosemods.windswept.core.registry.WindsweptTreeDecorators;
import com.teamabnormals.blueprint.common.block.wood.LogBlock;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class BranchDecorator
extends TreeDecorator {
    public static final Codec<BranchDecorator> CODEC = RecordCodecBuilder.create(i -> i.group((App)SimpleStateProvider.f_68797_.fieldOf("state").forGetter(bd -> bd.state), (App)Codec.intRange((int)0, (int)32).fieldOf("minHeight").forGetter(bd -> bd.minHeight)).apply((Applicative)i, BranchDecorator::new));
    private final SimpleStateProvider state;
    private final int minHeight;

    private BranchDecorator(SimpleStateProvider state, int minHeight) {
        this.state = state;
        this.minHeight = minHeight;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)WindsweptTreeDecorators.BRANCH_DECORATOR.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource rand = context.m_226067_();
        if (rand.m_188501_() <= 0.25f) {
            return;
        }
        int i = ((BlockPos)context.m_226068_().get(0)).m_123342_();
        LinkedList<Direction> logs = new LinkedList<Direction>();
        block0: for (BlockPos pos : context.m_226068_()) {
            if (pos.m_123342_() - i < this.minHeight || !(rand.m_188501_() <= 0.25f)) continue;
            LinkedList<Direction> directions = new LinkedList<Direction>(List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST));
            logs.forEach(directions::remove);
            Collections.shuffle(directions, new Random(rand.m_188502_()));
            for (Direction direction : directions) {
                BlockPos blockpos = pos.m_7918_(direction.m_122424_().m_122429_(), 0, direction.m_122424_().m_122431_());
                if (!context.m_226059_(blockpos) || !context.m_226059_(blockpos.m_7495_()) || !context.m_226059_(blockpos.m_7494_())) continue;
                BlockState blockState = this.state.m_213972_(rand, blockpos);
                if (blockState.m_60713_(Blocks.f_50001_) && !((Boolean)WindsweptConfig.COMMON.birchBranches.get()).booleanValue()) {
                    return;
                }
                if (blockState.m_61138_((Property)LogBlock.f_55923_)) {
                    blockState = (BlockState)blockState.m_61124_((Property)LogBlock.f_55923_, (Comparable)direction.m_122434_());
                }
                context.m_226061_(blockpos, blockState);
                logs.add(direction);
                if (rand.m_188499_()) continue block0;
                return;
            }
        }
    }

    public static BranchDecorator create(Block block, int minHeight) {
        return new BranchDecorator(BlockStateProvider.m_191382_((Block)block), minHeight);
    }
}

