/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core;

import com.rosemods.windswept.core.WindsweptConfig;
import com.rosemods.windswept.core.data.client.WindsweptBlockStateProvider;
import com.rosemods.windswept.core.data.client.WindsweptItemModelProvider;
import com.rosemods.windswept.core.data.client.WindsweptLangProvider;
import com.rosemods.windswept.core.data.client.WindsweptSoundProvider;
import com.rosemods.windswept.core.data.server.WindsweptLootTableProvider;
import com.rosemods.windswept.core.data.server.WindsweptRecipeProvider;
import com.rosemods.windswept.core.data.server.WindsweptStructureRepaletterProvider;
import com.rosemods.windswept.core.data.server.modifiers.WindsweptAdvancementModifierProvider;
import com.rosemods.windswept.core.data.server.modifiers.WindsweptBiomeModifier;
import com.rosemods.windswept.core.data.server.modifiers.WindsweptLootModifierProvider;
import com.rosemods.windswept.core.data.server.modifiers.WindsweptModdedBiomeSliceProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptBannerPatternTagProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptBiomeTagProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptBlockTagProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptEntityTagProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptItemTagProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptPaintingVariantTagsProvider;
import com.rosemods.windswept.core.other.WindsweptBlockInfo;
import com.rosemods.windswept.core.other.WindsweptCauldronInteractions;
import com.rosemods.windswept.core.other.WindsweptDataProcessors;
import com.rosemods.windswept.core.other.WindsweptDispenseBehaviors;
import com.rosemods.windswept.core.registry.WindsweptAttributes;
import com.rosemods.windswept.core.registry.WindsweptBannerPatterns;
import com.rosemods.windswept.core.registry.WindsweptEffects;
import com.rosemods.windswept.core.registry.WindsweptEnchantments;
import com.rosemods.windswept.core.registry.WindsweptEntities;
import com.rosemods.windswept.core.registry.WindsweptFeatures;
import com.rosemods.windswept.core.registry.WindsweptFoliagePlacers;
import com.rosemods.windswept.core.registry.WindsweptPaintingVariants;
import com.rosemods.windswept.core.registry.WindsweptTreeDecorators;
import com.rosemods.windswept.core.registry.WindsweptTrunkPlacers;
import com.rosemods.windswept.core.registry.util.EffectSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="windswept")
public class Windswept {
    public static final String MODID = "windswept";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"windswept", h -> h.putSubHelper(ForgeRegistries.MOB_EFFECTS, (ISubRegistryHelper)new EffectSubRegistryHelper((RegistryHelper)h)));

    public Windswept() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        WindsweptDataProcessors.registerData();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        WindsweptTreeDecorators.DECORATORS.register(bus);
        WindsweptFoliagePlacers.FOLIAGE_PLACERS.register(bus);
        WindsweptFeatures.FEATURES.register(bus);
        WindsweptFeatures.Features.CONFIGURED_FEATURES.register(bus);
        WindsweptFeatures.Placements.PLACED_FEATURES.register(bus);
        WindsweptEnchantments.ENCHANTMENTS.register(bus);
        WindsweptAttributes.ATTRIBUTES.register(bus);
        WindsweptBannerPatterns.BANNER_PATTERNS.register(bus);
        WindsweptTrunkPlacers.TRUNK_PLACERS.register(bus);
        WindsweptPaintingVariants.PAINTING_VARIANTS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WindsweptConfig.COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)WindsweptConfig.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            WindsweptBlockInfo.registerCompostables();
            WindsweptBlockInfo.registerFlammables();
            WindsweptEffects.registerPotionRecipes();
            WindsweptDispenseBehaviors.registerDispenseBehaviors();
            WindsweptCauldronInteractions.registerCauldronInteractions();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(WindsweptEntities::registerClient);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        gen.m_236039_(client, (DataProvider)new WindsweptSoundProvider(event));
        gen.m_236039_(client, (DataProvider)new WindsweptLangProvider(event));
        gen.m_236039_(client, (DataProvider)new WindsweptItemModelProvider(event));
        gen.m_236039_(client, (DataProvider)new WindsweptBlockStateProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptBlockTagProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptItemTagProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptEntityTagProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptBiomeTagProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptBannerPatternTagProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptLootTableProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptRecipeProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptAdvancementModifierProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptLootModifierProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptStructureRepaletterProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptModdedBiomeSliceProvider(event));
        gen.m_236039_(server, (DataProvider)new WindsweptPaintingVariantTagsProvider(event));
        gen.m_236039_(server, WindsweptBiomeModifier.register(event));
    }
}

