/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.data.client;

import com.mojang.datafixers.util.Pair;
import com.rosemods.windswept.common.block.wild_berry.WildBerryBushBlock;
import com.rosemods.windswept.core.Windswept;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import com.teamabnormals.blueprint.common.block.VerticalSlabBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import com.teamabnormals.blueprint.core.Blueprint;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class WindsweptBlockStateProvider
extends BlockStateProvider {
    public WindsweptBlockStateProvider(GatherDataEvent event) {
        super(event.getGenerator(), "windswept", event.getExistingFileHelper());
    }

    protected void registerStatesAndModels() {
        this.log(WindsweptBlocks.STRIPPED_HOLLY_LOG);
        this.wood(WindsweptBlocks.STRIPPED_HOLLY_WOOD, this.blockTexture((Block)WindsweptBlocks.STRIPPED_HOLLY_LOG.get()));
        this.log(WindsweptBlocks.HOLLY_LOG);
        this.wood(WindsweptBlocks.HOLLY_WOOD, this.blockTexture((Block)WindsweptBlocks.HOLLY_LOG.get()));
        this.cubeAll(WindsweptBlocks.HOLLY_PLANKS);
        this.slab((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_SLAB, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_PLANKS);
        this.stairs((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_STAIRS, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_PLANKS);
        this.fence((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_FENCE, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_PLANKS);
        this.fenceGate((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_FENCE_GATE, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_PLANKS);
        this.pressurePlate((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_PRESSURE_PLATE, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_PLANKS);
        this.door(WindsweptBlocks.HOLLY_DOOR);
        this.trapdoor(WindsweptBlocks.HOLLY_TRAPDOOR);
        this.button((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_BUTTON, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_PLANKS);
        this.signs(WindsweptBlocks.HOLLY_SIGNS, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_PLANKS);
        this.leaves(WindsweptBlocks.HOLLY_LEAVES);
        this.pottedPlant(WindsweptBlocks.HOLLY_SAPLING, WindsweptBlocks.POTTED_HOLLY_SAPLING);
        this.beehive(WindsweptBlocks.HOLLY_BEEHIVE);
        this.hedge((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_HEDGE, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_LEAVES, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_LOG);
        this.leafCarpet((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_LEAF_CARPET, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_LEAVES);
        this.leafPile((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_LEAF_PILE, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_LEAVES, false);
        this.ladder(WindsweptBlocks.HOLLY_LADDER);
        this.verticalPlanks((RegistryObject<? extends Block>)WindsweptBlocks.VERTICAL_HOLLY_PLANKS, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_PLANKS);
        this.bookshelf((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_BOOKSHELF, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_PLANKS);
        this.boards(WindsweptBlocks.HOLLY_BOARDS);
        this.cabinet(WindsweptBlocks.HOLLY_CABINET);
        this.verticalSlab((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_VERTICAL_SLAB, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_PLANKS);
        this.post((RegistryObject<? extends Block>)WindsweptBlocks.HOLLY_POST, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_LOG);
        this.post((RegistryObject<? extends Block>)WindsweptBlocks.STRIPPED_HOLLY_POST, (Supplier<? extends Block>)WindsweptBlocks.STRIPPED_HOLLY_LOG);
        this.chests(WindsweptBlocks.HOLLY_CHEST, WindsweptBlocks.HOLLY_TRAPPED_CHEST, (Supplier<? extends Block>)WindsweptBlocks.HOLLY_PLANKS);
        this.compressedBlock(WindsweptBlocks.HOLLY_BERRY_BASKET);
        this.log(WindsweptBlocks.STRIPPED_CHESTNUT_LOG);
        this.wood(WindsweptBlocks.STRIPPED_CHESTNUT_WOOD, this.blockTexture((Block)WindsweptBlocks.STRIPPED_CHESTNUT_LOG.get()));
        this.log(WindsweptBlocks.CHESTNUT_LOG);
        this.wood(WindsweptBlocks.CHESTNUT_WOOD, this.blockTexture((Block)WindsweptBlocks.CHESTNUT_LOG.get()));
        this.cubeAll(WindsweptBlocks.CHESTNUT_PLANKS);
        this.slab((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_SLAB, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_PLANKS);
        this.stairs((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_STAIRS, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_PLANKS);
        this.fence((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_FENCE, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_PLANKS);
        this.fenceGate((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_FENCE_GATE, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_PLANKS);
        this.pressurePlate((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_PRESSURE_PLATE, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_PLANKS);
        this.door(WindsweptBlocks.CHESTNUT_DOOR);
        this.trapdoor(WindsweptBlocks.CHESTNUT_TRAPDOOR);
        this.button((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_BUTTON, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_PLANKS);
        this.signs(WindsweptBlocks.CHESTNUT_SIGNS, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_PLANKS);
        this.leaves(WindsweptBlocks.CHESTNUT_LEAVES);
        this.pottedPlant(WindsweptBlocks.CHESTNUT_SAPLING, WindsweptBlocks.POTTED_CHESTNUT_SAPLING);
        this.beehive(WindsweptBlocks.CHESTNUT_BEEHIVE);
        this.hedge((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_HEDGE, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_LEAVES, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_LOG);
        this.leafCarpet((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_LEAF_CARPET, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_LEAVES);
        this.leafPile((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_LEAF_PILE, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_LEAVES, true);
        this.ladder(WindsweptBlocks.CHESTNUT_LADDER);
        this.verticalPlanks((RegistryObject<? extends Block>)WindsweptBlocks.VERTICAL_CHESTNUT_PLANKS, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_PLANKS);
        this.bookshelf((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_BOOKSHELF, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_PLANKS);
        this.boards(WindsweptBlocks.CHESTNUT_BOARDS);
        this.cabinet(WindsweptBlocks.CHESTNUT_CABINET);
        this.verticalSlab((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_VERTICAL_SLAB, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_PLANKS);
        this.post((RegistryObject<? extends Block>)WindsweptBlocks.CHESTNUT_POST, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_LOG);
        this.post((RegistryObject<? extends Block>)WindsweptBlocks.STRIPPED_CHESTNUT_POST, (Supplier<? extends Block>)WindsweptBlocks.STRIPPED_CHESTNUT_LOG);
        this.chests(WindsweptBlocks.CHESTNUT_CHEST, WindsweptBlocks.CHESTNUT_TRAPPED_CHEST, (Supplier<? extends Block>)WindsweptBlocks.CHESTNUT_PLANKS);
        this.compressedBlock(WindsweptBlocks.CHESTNUT_CRATE);
        this.compressedBlock(WindsweptBlocks.ROASTED_CHESTNUT_CRATE);
        this.cubeAll(WindsweptBlocks.SNOW_BRICKS);
        this.stairs((RegistryObject<? extends Block>)WindsweptBlocks.SNOW_BRICK_STAIRS, (Supplier<? extends Block>)WindsweptBlocks.SNOW_BRICKS);
        this.slab((RegistryObject<? extends Block>)WindsweptBlocks.SNOW_BRICK_SLAB, (Supplier<? extends Block>)WindsweptBlocks.SNOW_BRICKS);
        this.wall((RegistryObject<? extends Block>)WindsweptBlocks.SNOW_BRICK_WALL, (Supplier<? extends Block>)WindsweptBlocks.SNOW_BRICKS);
        this.verticalSlab((RegistryObject<? extends Block>)WindsweptBlocks.SNOW_BRICK_VERTICAL_SLAB, (Supplier<? extends Block>)WindsweptBlocks.SNOW_BRICKS);
        this.cubeAll(WindsweptBlocks.PACKED_ICE_BRICKS);
        this.cubeAll(WindsweptBlocks.CHISELED_PACKED_ICE_BRICKS);
        this.stairs((RegistryObject<? extends Block>)WindsweptBlocks.PACKED_ICE_BRICK_STAIRS, (Supplier<? extends Block>)WindsweptBlocks.PACKED_ICE_BRICKS);
        this.slab((RegistryObject<? extends Block>)WindsweptBlocks.PACKED_ICE_BRICK_SLAB, (Supplier<? extends Block>)WindsweptBlocks.PACKED_ICE_BRICKS);
        this.wall((RegistryObject<? extends Block>)WindsweptBlocks.PACKED_ICE_BRICK_WALL, (Supplier<? extends Block>)WindsweptBlocks.PACKED_ICE_BRICKS);
        this.verticalSlab((RegistryObject<? extends Block>)WindsweptBlocks.PACKED_ICE_BRICK_VERTICAL_SLAB, (Supplier<? extends Block>)WindsweptBlocks.PACKED_ICE_BRICKS);
        this.cubeAll(WindsweptBlocks.BLUE_ICE_BRICKS);
        this.cubeAll(WindsweptBlocks.CHISELED_BLUE_ICE_BRICKS);
        this.stairs((RegistryObject<? extends Block>)WindsweptBlocks.BLUE_ICE_BRICK_STAIRS, (Supplier<? extends Block>)WindsweptBlocks.BLUE_ICE_BRICKS);
        this.slab((RegistryObject<? extends Block>)WindsweptBlocks.BLUE_ICE_BRICK_SLAB, (Supplier<? extends Block>)WindsweptBlocks.BLUE_ICE_BRICKS);
        this.wall((RegistryObject<? extends Block>)WindsweptBlocks.BLUE_ICE_BRICK_WALL, (Supplier<? extends Block>)WindsweptBlocks.BLUE_ICE_BRICKS);
        this.verticalSlab((RegistryObject<? extends Block>)WindsweptBlocks.BLUE_ICE_BRICK_VERTICAL_SLAB, (Supplier<? extends Block>)WindsweptBlocks.BLUE_ICE_BRICKS);
        this.pressurePlate(WindsweptBlocks.POLISHED_DEEPSLATE_PRESSURE_PLATE, () -> Blocks.f_152555_);
        this.button(WindsweptBlocks.POLISHED_DEEPSLATE_BUTTON, () -> Blocks.f_152555_);
        this.simpleCross(WindsweptBlocks.SNOWY_SPROUTS);
        this.pot(WindsweptBlocks.POTTED_SNOWY_SPROUTS, this.modLoc("block/potted_snowy_sprouts"));
        this.tallPlant(WindsweptBlocks.RED_ROSE_BUSH);
        this.tallPlant(WindsweptBlocks.PINK_ROSE_BUSH);
        this.tallPlant(WindsweptBlocks.BLUE_ROSE_BUSH);
        this.tallPlant(WindsweptBlocks.WHITE_ROSE_BUSH);
        this.tallPlant(WindsweptBlocks.YELLOW_ROSE_BUSH);
        this.tallPlant(WindsweptBlocks.WITHER_ROSE_BUSH);
        this.pottedPlant(WindsweptBlocks.RED_ROSE, WindsweptBlocks.POTTED_RED_ROSE);
        this.pottedPlant(WindsweptBlocks.PINK_ROSE, WindsweptBlocks.POTTED_PINK_ROSE);
        this.pottedPlant(WindsweptBlocks.BLUE_ROSE, WindsweptBlocks.POTTED_BLUE_ROSE);
        this.pottedPlant(WindsweptBlocks.WHITE_ROSE, WindsweptBlocks.POTTED_WHITE_ROSE);
        this.pottedPlant(WindsweptBlocks.YELLOW_ROSE, WindsweptBlocks.POTTED_YELLOW_ROSE);
        this.pottedPlant(WindsweptBlocks.FOXGLOVE, WindsweptBlocks.POTTED_FOXGLOVE);
        this.pottedPlant(WindsweptBlocks.NIGHTSHADE, WindsweptBlocks.POTTED_NIGHTSHADE);
        this.blubells(WindsweptBlocks.BLUEBELLS, WindsweptBlocks.POTTED_BLUEBELLS);
        this.wildBerryBush(WindsweptBlocks.WILD_BERRY_BUSH);
        this.compressedBlock(WindsweptBlocks.WILD_BERRY_BASKET);
        this.simpleCross(WindsweptBlocks.WILD_BERRY_BUSH_PIPS);
        this.compressedBlock(WindsweptBlocks.RED_MUSHROOM_BASKET);
        this.compressedBlock(WindsweptBlocks.BROWN_MUSHROOM_BASKET);
        this.compressedBlock(WindsweptBlocks.GLOW_SHROOM_BASKET);
        this.iceSheet(WindsweptBlocks.ICE_SHEET, () -> Blocks.f_50126_);
        this.cubeAll(WindsweptBlocks.FROZEN_FLESH_BLOCK);
    }

    private void wildBerryBush(RegistryObject<Block> bush) {
        String name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)bush.get()))).m_135815_();
        Function<Integer, ModelFile> model = i -> ((BlockModelBuilder)this.models().cross(name + "_stage" + i, this.modLoc("block/" + name + "_stage" + i))).renderType("cutout");
        this.getVariantBuilder((Block)bush.get()).partialState().with((Property)WildBerryBushBlock.AGE, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{new ConfiguredModel(model.apply(0), 0, 0, true)}).partialState().with((Property)WildBerryBushBlock.AGE, (Comparable)Integer.valueOf(1)).addModels(new ConfiguredModel[]{new ConfiguredModel(model.apply(1), 0, 180, true)}).partialState().with((Property)WildBerryBushBlock.AGE, (Comparable)Integer.valueOf(2)).addModels(new ConfiguredModel[]{new ConfiguredModel(model.apply(2), 0, 90, true)});
    }

    private void blubells(RegistryObject<Block> bluebells, RegistryObject<Block> pot) {
        this.pot(pot, this.modLoc("block/potted_" + this.getName((Supplier<? extends ItemLike>)bluebells)));
        this.simpleBlock((Block)bluebells.get(), (ModelFile)this.models().withExistingParent(this.getName((Supplier<? extends ItemLike>)bluebells), Windswept.REGISTRY_HELPER.prefix("bluebells_template")));
        this.generatedItem(bluebells);
    }

    private void tallPlant(RegistryObject<Block> flower) {
        String name = this.getName((Supplier<? extends ItemLike>)flower);
        Function<String, ModelFile> model = s -> ((BlockModelBuilder)this.models().cross(name + "_" + s, this.modLoc("block/" + name + "_" + s))).renderType("cutout");
        ((ItemModelBuilder)this.itemModels().withExistingParent(name, "item/generated")).texture("layer0", this.modLoc("block/" + name + "_top"));
        this.getVariantBuilder((Block)flower.get()).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).addModels(new ConfiguredModel[]{new ConfiguredModel(model.apply("top"))}).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).addModels(new ConfiguredModel[]{new ConfiguredModel(model.apply("bottom"))});
    }

    private void pottedPlant(RegistryObject<Block> plant, RegistryObject<Block> pot) {
        this.pot(pot, this.blockTexture((Block)plant.get()));
        this.simpleCross(plant);
        this.generatedItem(plant);
    }

    private void pot(RegistryObject<Block> pot, ResourceLocation texture) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)pot.get()))).m_135815_(), "block/flower_pot_cross")).texture("plant", texture)).renderType("cutout");
        this.simpleBlock((Block)pot.get(), (ModelFile)model);
    }

    private void iceSheet(RegistryObject<Block> block, Supplier<Block> textureBlock) {
        ResourceLocation texture = this.blockTexture(textureBlock.get());
        this.paneBlockWithRenderType((IronBarsBlock)block.get(), texture, texture, "translucent");
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(this.getName((Supplier<? extends ItemLike>)block), "item/generated")).texture("layer0", texture)).renderType("translucent");
    }

    private void trapdoor(RegistryObject<? extends Block> trapdoor) {
        this.trapdoorBlockWithRenderType((TrapDoorBlock)trapdoor.get(), this.blockTexture((Block)trapdoor.get()), true, "cutout");
        this.itemModels().withExistingParent(this.getName((Supplier<? extends ItemLike>)trapdoor), this.modLoc("block/" + this.getName((Supplier<? extends ItemLike>)trapdoor) + "_bottom"));
    }

    private void door(RegistryObject<? extends Block> door) {
        String name = "block/" + this.getName((Supplier<? extends ItemLike>)door);
        this.doorBlockWithRenderType((DoorBlock)door.get(), this.getName((Supplier<? extends ItemLike>)door).replace("_door", ""), this.modLoc(name + "_bottom"), this.modLoc(name + "_top"), "cutout");
    }

    private void button(RegistryObject<? extends Block> button, Supplier<? extends Block> textureBlock) {
        ResourceLocation texture = this.blockTexture(textureBlock.get());
        this.buttonBlock((ButtonBlock)button.get(), texture);
        this.itemModels().buttonInventory(this.getName((Supplier<? extends ItemLike>)button), texture);
    }

    private void pressurePlate(RegistryObject<? extends Block> pressurePlate, Supplier<? extends Block> textureBlock) {
        this.pressurePlateBlock((PressurePlateBlock)pressurePlate.get(), this.blockTexture(textureBlock.get()));
        this.itemModel(pressurePlate);
    }

    private void ladder(RegistryObject<? extends Block> ladder) {
        ResourceLocation texture = this.blockTexture((Block)ladder.get());
        this.horizontalBlock((Block)ladder.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Supplier<? extends ItemLike>)ladder), "block/ladder")).texture("particle", texture)).renderType("cutout")).texture("texture", texture));
        this.generatedItem(ladder);
    }

    private void fence(RegistryObject<? extends Block> fence, Supplier<? extends Block> textureBlock) {
        ResourceLocation texture = this.blockTexture(textureBlock.get());
        this.fenceBlock((FenceBlock)fence.get(), texture);
        this.itemModels().fenceInventory(this.getName((Supplier<? extends ItemLike>)fence), texture);
    }

    private void fenceGate(RegistryObject<? extends Block> gate, Supplier<? extends Block> textureBlock) {
        this.fenceGateBlock((FenceGateBlock)gate.get(), this.blockTexture(textureBlock.get()));
        this.itemModel(gate);
    }

    private void slab(RegistryObject<? extends Block> slab, Supplier<? extends Block> textureBlock) {
        ResourceLocation texture = this.blockTexture(textureBlock.get());
        this.slabBlock((SlabBlock)slab.get(), texture, texture);
        this.itemModel(slab);
    }

    private void stairs(RegistryObject<? extends Block> stairs, Supplier<? extends Block> textureBlock) {
        this.stairsBlock((StairBlock)stairs.get(), this.blockTexture(textureBlock.get()));
        this.itemModel(stairs);
    }

    private void wall(RegistryObject<? extends Block> wall, Supplier<? extends Block> textureBlock) {
        ResourceLocation texture = this.blockTexture(textureBlock.get());
        this.wallBlock((WallBlock)wall.get(), texture);
        this.itemModels().wallInventory(this.getName((Supplier<? extends ItemLike>)wall), texture);
    }

    private void cubeAll(RegistryObject<? extends Block> block) {
        this.simpleBlock((Block)block.get());
        this.itemModel(block);
    }

    private void compressedBlock(RegistryObject<? extends Block> block) {
        String name = this.getName((Supplier<? extends ItemLike>)block);
        this.directionalBlock((Block)block.get(), (ModelFile)this.models().cubeBottomTop(name, this.modLoc("block/" + name + "_side"), this.modLoc("block/" + name + "_bottom"), this.modLoc("block/" + name + "_top")));
        this.itemModel(block);
    }

    private void leaves(RegistryObject<? extends Block> leaves) {
        this.simpleBlock((Block)leaves.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Supplier<? extends ItemLike>)leaves), "block/leaves")).texture("all", this.blockTexture((Block)leaves.get()))).renderType("cutout"));
        this.itemModel(leaves);
    }

    private void simpleCross(RegistryObject<? extends Block> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.getName((Supplier<? extends ItemLike>)block), this.blockTexture((Block)block.get()))).renderType("cutout"));
    }

    private void signs(Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> signs, Supplier<? extends Block> textureBlock) {
        this.signBlock((StandingSignBlock)((RegistryObject)signs.getFirst()).get(), (WallSignBlock)((RegistryObject)signs.getSecond()).get(), this.blockTexture(textureBlock.get()));
    }

    private void beehive(RegistryObject<? extends Block> beehive) {
        String name = this.getName((Supplier<? extends ItemLike>)beehive);
        ModelBuilder model = this.models().orientable(name, this.modLoc("block/" + name + "_side"), this.modLoc("block/" + name + "_front"), this.modLoc("block/" + name + "_end"));
        ModelBuilder model_honey = this.models().orientable(name + "_honey", this.modLoc("block/" + name + "_side"), this.modLoc("block/" + name + "_front_honey"), this.modLoc("block/" + name + "_end"));
        this.horizontalBlock((Block)beehive.get(), arg_0 -> WindsweptBlockStateProvider.lambda$beehive$5((ModelFile)model_honey, (ModelFile)model, arg_0));
        this.itemModel(beehive);
    }

    private void cabinet(RegistryObject<? extends Block> cabinet) {
        String name = this.getName((Supplier<? extends ItemLike>)cabinet);
        ModelBuilder model = this.models().orientable(name, this.modLoc("block/" + name + "_side"), this.modLoc("block/" + name + "_front"), this.modLoc("block/" + name + "_end"));
        ModelBuilder model_open = this.models().orientable(name + "_open", this.modLoc("block/" + name + "_side"), this.modLoc("block/" + name + "_front_open"), this.modLoc("block/" + name + "_end"));
        this.horizontalBlock((Block)cabinet.get(), arg_0 -> WindsweptBlockStateProvider.lambda$cabinet$6((ModelFile)model_open, (ModelFile)model, arg_0));
        this.itemModel(cabinet);
    }

    private void log(RegistryObject<? extends Block> log) {
        this.axisBlock((RotatedPillarBlock)log.get(), this.blockTexture((Block)log.get()), this.modLoc("block/" + this.getName((Supplier<? extends ItemLike>)log) + "_top"));
        this.itemModel(log);
    }

    private void wood(RegistryObject<? extends Block> log, ResourceLocation texture) {
        this.axisBlock((RotatedPillarBlock)log.get(), texture, texture);
        this.itemModel(log);
    }

    private void bookshelf(RegistryObject<? extends Block> bookshelf, Supplier<? extends Block> planks) {
        this.simpleBlock((Block)bookshelf.get(), (ModelFile)this.models().cubeColumn(this.getName((Supplier<? extends ItemLike>)bookshelf), this.blockTexture((Block)bookshelf.get()), this.blockTexture(planks.get())));
        this.itemModel(bookshelf);
    }

    private void hedge(RegistryObject<? extends Block> hedge, Supplier<? extends Block> leaves, Supplier<? extends Block> log) {
        ModelBuilder post = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Supplier<? extends ItemLike>)hedge) + "_post", "blueprint:block/hedge_post")).texture("leaf", this.blockTexture(leaves.get()))).texture("log", this.blockTexture(log.get()))).renderType("cutout");
        ModelBuilder side = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Supplier<? extends ItemLike>)hedge) + "_side", "blueprint:block/hedge_side")).texture("leaf", this.blockTexture(leaves.get()))).renderType("cutout");
        ModelBuilder extend = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Supplier<? extends ItemLike>)hedge) + "_extend", "blueprint:block/hedge_extend")).texture("leaf", this.blockTexture(leaves.get()))).renderType("cutout");
        this.itemModels().withExistingParent(this.getName((Supplier<? extends ItemLike>)hedge), this.modLoc("block/" + this.getName((Supplier<? extends ItemLike>)hedge) + "_post"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)hedge.get()).part().modelFile((ModelFile)post).addModel()).condition((Property)BooleanProperty.m_61465_((String)"extend"), (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)extend).addModel()).condition((Property)BooleanProperty.m_61465_((String)"extend"), (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)side).uvLock(true).addModel()).condition((Property)CrossCollisionBlock.f_52309_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)side).uvLock(true).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.f_52310_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)side).uvLock(true).rotationY(180).addModel()).condition((Property)CrossCollisionBlock.f_52311_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)side).uvLock(true).rotationY(270).addModel()).condition((Property)CrossCollisionBlock.f_52312_, (Comparable[])new Boolean[]{true}).end();
    }

    private void chests(RegistryObject<BlueprintChestBlock> chest, RegistryObject<BlueprintTrappedChestBlock> trapped, Supplier<? extends Block> textureBlock) {
        ModelBuilder model = ((BlockModelBuilder)this.models().getBuilder(this.getName((Supplier<? extends ItemLike>)chest))).texture("particle", this.blockTexture(textureBlock.get()));
        this.simpleBlock((Block)chest.get(), (ModelFile)model);
        this.simpleBlock((Block)trapped.get(), (ModelFile)model);
        this.itemModels().withExistingParent(this.getName((Supplier<? extends ItemLike>)chest), "blueprint:item/template_chest");
        this.itemModels().withExistingParent(this.getName((Supplier<? extends ItemLike>)trapped), "blueprint:item/template_chest");
    }

    private void leafCarpet(RegistryObject<? extends Block> carpet, Supplier<? extends Block> textureBlock) {
        this.simpleBlock((Block)carpet.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Supplier<? extends ItemLike>)carpet), "blueprint:block/leaf_carpet")).texture("all", this.blockTexture(textureBlock.get()))).renderType("cutout"));
        this.itemModel(carpet);
    }

    private void post(RegistryObject<? extends Block> post, Supplier<? extends Block> textureBlock) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.getName((Supplier<? extends ItemLike>)post), "blueprint:block/post")).texture("texture", this.blockTexture(textureBlock.get()));
        ModelFile.ExistingModelFile chain = this.models().getExistingFile(Blueprint.REGISTRY_HELPER.prefix("block/chain_small"));
        ModelFile.ExistingModelFile chainTop = this.models().getExistingFile(Blueprint.REGISTRY_HELPER.prefix("block/chain_small_top"));
        this.itemModel(post);
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)post.get()).part().modelFile((ModelFile)model).addModel()).condition((Property)BlockStateProperties.f_61365_, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).end().part().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61365_, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile((ModelFile)model).rotationX(90).addModel()).condition((Property)BlockStateProperties.f_61365_, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end().part().modelFile((ModelFile)chain).addModel()).condition((Property)BooleanProperty.m_61465_((String)"chain_down"), (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainTop).addModel()).condition((Property)BooleanProperty.m_61465_((String)"chain_up"), (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainTop).rotationX(90).addModel()).condition((Property)BooleanProperty.m_61465_((String)"chain_north"), (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chain).rotationX(90).addModel()).condition((Property)BooleanProperty.m_61465_((String)"chain_south"), (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainTop).rotationX(90).rotationY(90).addModel()).condition((Property)BooleanProperty.m_61465_((String)"chain_east"), (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chain).rotationX(90).rotationY(90).addModel()).condition((Property)BooleanProperty.m_61465_((String)"chain_west"), (Comparable[])new Boolean[]{true}).end();
    }

    private void leafPile(RegistryObject<? extends Block> leafPile, Supplier<? extends Block> textureBlock, boolean tinted) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Supplier<? extends ItemLike>)leafPile), "blueprint:block/" + (tinted ? "tinted_" : "") + "leaf_pile")).texture("all", this.blockTexture(textureBlock.get()))).renderType("cutout");
        ((ItemModelBuilder)this.itemModels().withExistingParent(this.getName((Supplier<? extends ItemLike>)leafPile), "item/generated")).texture("layer0", this.modLoc("block/" + this.getName(textureBlock)));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)leafPile.get()).part().modelFile((ModelFile)model).uvLock(true).rotationX(270).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).uvLock(true).rotationX(90).addModel()).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).uvLock(true).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).uvLock(true).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).uvLock(true).rotationY(270).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
    }

    private void verticalSlab(RegistryObject<? extends Block> slab, Supplier<? extends Block> textureBlock) {
        ResourceLocation texture = this.blockTexture(textureBlock.get());
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Supplier<? extends ItemLike>)slab), "blueprint:block/vertical_slab")).texture("top", texture)).texture("bottom", texture)).texture("side", texture);
        this.itemModel(slab);
        this.getVariantBuilder((Block)slab.get()).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.NORTH).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, 0, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.SOUTH).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, 180, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.EAST).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, 90, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.WEST).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, 270, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(texture))});
    }

    private void verticalPlanks(RegistryObject<? extends Block> planks, Supplier<? extends Block> textureBlock) {
        ResourceLocation texture = this.blockTexture(textureBlock.get());
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.getName((Supplier<? extends ItemLike>)planks), "blueprint:block/vertical_planks")).texture("all", texture);
        this.itemModel(planks);
        this.simpleBlock((Block)planks.get(), (ModelFile)model);
    }

    private void boards(RegistryObject<? extends Block> boards) {
        ResourceLocation texture = this.blockTexture((Block)boards.get());
        ModelBuilder boardsModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.getName((Supplier<? extends ItemLike>)boards))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/template_boards")))).texture("all", texture);
        ModelBuilder boardsHorizontalModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.getName((Supplier<? extends ItemLike>)boards) + "_horizontal")).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/template_boards_horizontal")))).texture("all", texture);
        this.itemModel(boards);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)boards.get()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)boardsModel).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)boardsHorizontalModel).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)boardsHorizontalModel).rotationY(270).addModel();
    }

    private void itemModel(RegistryObject<? extends Block> block) {
        this.itemModels().withExistingParent(this.getName((Supplier<? extends ItemLike>)block), this.blockTexture((Block)block.get()));
    }

    private void generatedItem(RegistryObject<? extends ItemLike> item) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(this.getName((Supplier<? extends ItemLike>)item), "item/generated")).texture("layer0", this.modLoc("block/" + this.getName((Supplier<? extends ItemLike>)item)));
    }

    private String getName(Supplier<? extends ItemLike> object) {
        return ForgeRegistries.ITEMS.getKey((Object)object.get().m_5456_()).m_135815_();
    }

    private static /* synthetic */ ModelFile lambda$cabinet$6(ModelFile model_open, ModelFile model, BlockState s) {
        return (Boolean)s.m_61143_((Property)BlockStateProperties.f_61446_) != false ? model_open : model;
    }

    private static /* synthetic */ ModelFile lambda$beehive$5(ModelFile model_honey, ModelFile model, BlockState s) {
        return (Integer)s.m_61143_((Property)BeehiveBlock.f_49564_) == 5 ? model_honey : model;
    }
}

